#ifndef ATL_dtGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,360,480,720,1440,1560,1800,1920,2160,2520,2640,2760,2880
 * N : 25,360,480,720,1440,1560,1800,1920,2160,2520,2640,2760,2880
 * NB : 2,20,24,24,24,48,40,48,160,160,160,160,240
 */
#define ATL_dtGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 192) (nb_) = 2; \
   else if ((n_) < 420) (nb_) = 20; \
   else if ((n_) < 1500) (nb_) = 24; \
   else if ((n_) < 1680) (nb_) = 48; \
   else if ((n_) < 1860) (nb_) = 40; \
   else if ((n_) < 2040) (nb_) = 48; \
   else if ((n_) < 2820) (nb_) = 160; \
   else (nb_) = 240; \
}


#endif    /* end ifndef ATL_dtGetNB_geqrf */
