/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2020 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/

#ifndef PIPESTREAM_H
#define PIPESTREAM_H

#include "cdoStream.h"
#include "pipe.h"

#ifdef HAVE_LIBPTHREAD

class FileStream;  // Predeclaration only for copyRecord(...)

class PipeStream : public CdoStream
{
public:
  // Constructors
  PipeStream(int p_processID);
  // ---

  // CdoStream Interface functions
  int openRead();
  int openWrite(int p_filetype);
  int openAppend();

  int inqVlist();
  void defVlist(int p_vlistID);

  void inqRecord(int *varID, int *levelID);
  void defRecord(int varID, int levelID);

  void readRecord(float *p_data, size_t *nmiss);
  void readRecord(double *p_data, size_t *nmiss);
  void readRecord(Field *p_field, size_t *nmiss);

  void writeRecord(float *p_data, size_t nmiss);
  void writeRecord(double *p_data, size_t nmiss);
  void writeRecord(Field *p_field, size_t nmiss);

  void copyRecord(CdoStreamID p_fileStream);

  int inqTimestep(int tsID);
  void defTimestep(int tsID);

  int inqFileType();
  int inqByteorder();

  void close();

  size_t getNvals();
  // ---

  // FileStreamOnly
  // ---

private:
  PipeStream() = delete;
  std::shared_ptr<pipe_t> m_pipe;
  pthread_t rthreadID; // read  thread ID
  pthread_t wthreadID; // write thread ID
  void waitForPipe();
};
#endif

#endif
