/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.Vector;

public class ArgParser {
    Vector matchList;
    String synopsisString;
    boolean helpOptionsEnabled = true;
    Record defaultHelpOption = null;
    Record firstHelpOption = null;
    PrintStream printStream = System.out;
    int helpIndent = 24;
    String errMsg = null;
    String unmatchedArg = null;
    static String validConversionCodes = "iodxcbfsvh";
    public static int EXIT_ON_ERROR = 1;
    public static int EXIT_ON_UNMATCHED = 2;

    public static String getValidConversionCodes() {
        return validConversionCodes;
    }

    private String firstHelpOptionName() {
        if (this.firstHelpOption != null) {
            return this.firstHelpOption.nameList.name;
        }
        return null;
    }

    public ArgParser(String synopsisString) {
        this(synopsisString, true);
    }

    public ArgParser(String synopsisString, boolean defaultHelp) {
        this.matchList = new Vector(128);
        this.synopsisString = synopsisString;
        if (defaultHelp) {
            this.addOption("-help,-? %h #displays help information", null);
            this.defaultHelpOption = this.firstHelpOption = (Record)this.matchList.get(0);
        }
    }

    public String getSynopsisString() {
        return this.synopsisString;
    }

    public void setSynopsisString(String s) {
        this.synopsisString = s;
    }

    public boolean getHelpOptionsEnabled() {
        return this.helpOptionsEnabled;
    }

    public void setHelpOptionsEnabled(boolean enable) {
        this.helpOptionsEnabled = enable;
    }

    public PrintStream getDefaultPrintStream() {
        return this.printStream;
    }

    public void setDefaultPrintStream(PrintStream stream) {
        this.printStream = stream;
    }

    public int getHelpIndentation() {
        return this.helpIndent;
    }

    public void setHelpIndentation(int indent) {
        this.helpIndent = indent;
    }

    private void scanRangeSpec(Record rec, String s) throws IllegalArgumentException {
        StringScanner scanner = new StringScanner(s);
        boolean i = true;
        scanner.setStringDelimiters(")],}");
        char c = scanner.getc();
        scanner.skipWhiteSpace();
        while ((c = scanner.peekc()) != '}') {
            RangePnt p0;
            if (c == '[' || c == '(') {
                if (rec.convertCode == 'v' || rec.convertCode == 'b') {
                    throw new IllegalArgumentException("Sub ranges not supported for %b or %v");
                }
                char c0 = scanner.getc();
                scanner.skipWhiteSpace();
                p0 = new RangePnt(scanner, rec.type);
                scanner.skipWhiteSpace();
                if (scanner.getc() != ',') {
                    throw new IllegalArgumentException("Missing ',' in subrange specification");
                }
                RangePnt p1 = new RangePnt(scanner, rec.type);
                scanner.skipWhiteSpace();
                char c1 = scanner.getc();
                if (c1 != ']' && c1 != ')') {
                    throw new IllegalArgumentException("Unterminated subrange");
                }
                if (c0 == '(') {
                    p0.setClosed(false);
                }
                if (c1 == ')') {
                    p1.setClosed(false);
                }
                rec.addRangeAtom(new RangeAtom(p0, p1, rec.type));
            } else {
                scanner.skipWhiteSpace();
                p0 = new RangePnt(scanner, rec.type);
                rec.addRangeAtom(new RangeAtom(p0));
            }
            scanner.skipWhiteSpace();
            c = scanner.peekc();
            if (c == ',') {
                scanner.getc();
                scanner.skipWhiteSpace();
                continue;
            }
            if (c == '}') continue;
            throw new IllegalArgumentException("Range spec: ',' or '}' expected");
        }
        rec.rangeDesc = rec.numRangeAtoms() == 1 ? s.substring(1, s.length() - 1) : s;
    }

    private int defaultResultType(char convertCode) {
        switch (convertCode) {
            case 'd': 
            case 'i': 
            case 'o': 
            case 'x': {
                return 4;
            }
            case 'c': {
                return 2;
            }
            case 'b': 
            case 'v': {
                return 1;
            }
            case 'f': {
                return 6;
            }
            case 's': {
                return 7;
            }
        }
        return 0;
    }

    public void addOption(String spec, Object resHolder) throws IllegalArgumentException {
        int i1;
        int i0;
        NameDesc ndesc;
        char c;
        StringScanner scanner = new StringScanner(spec);
        Record rec = null;
        NameDesc nameTail = null;
        do {
            ndesc = new NameDesc();
            boolean nameEndsInWhiteSpace = false;
            scanner.skipWhiteSpace();
            i0 = scanner.getIndex();
            while (!Character.isWhitespace(c = scanner.getc()) && c != ',' && c != '%' && c != '\u0000') {
            }
            i1 = scanner.getIndex();
            if (c != '\u0000') {
                --i1;
            }
            if (i0 == i1) {
                throw new IllegalArgumentException("Null option name given");
            }
            if (Character.isWhitespace(c)) {
                nameEndsInWhiteSpace = true;
                scanner.skipWhiteSpace();
                c = scanner.getc();
            }
            if (c == '\u0000') {
                throw new IllegalArgumentException("No conversion character given");
            }
            if (c != ',' && c != '%') {
                throw new IllegalArgumentException("Names not separated by ','");
            }
            ndesc.name = scanner.substring(i0, i1);
            if (rec == null) {
                rec = new Record();
                rec.nameList = ndesc;
            } else {
                nameTail.next = ndesc;
            }
            nameTail = ndesc;
            boolean bl = ndesc.oneWord = !nameEndsInWhiteSpace;
        } while (c != '%');
        if (nameTail == null) {
            throw new IllegalArgumentException("Null option name given");
        }
        if (!nameTail.oneWord) {
            ndesc = rec.nameList;
            while (ndesc != null) {
                ndesc.oneWord = false;
                ndesc = ndesc.next;
            }
        }
        if ((c = scanner.getc()) == '\u0000') {
            throw new IllegalArgumentException("No conversion character given");
        }
        if (validConversionCodes.indexOf(c) == -1) {
            throw new IllegalArgumentException("Conversion code '" + c + "' not one of '" + validConversionCodes + "'");
        }
        rec.convertCode = c;
        if (resHolder instanceof Vector) {
            rec.vectorResult = true;
            rec.type = this.defaultResultType(rec.convertCode);
        } else {
            switch (rec.convertCode) {
                case 'd': 
                case 'i': 
                case 'o': 
                case 'x': {
                    if (resHolder instanceof LongHolder || resHolder instanceof long[]) {
                        rec.type = 4;
                        break;
                    }
                    if (resHolder instanceof IntHolder || resHolder instanceof int[]) {
                        rec.type = 3;
                        break;
                    }
                    throw new IllegalArgumentException("Invalid result holder for %" + c);
                }
                case 'c': {
                    if (!(resHolder instanceof CharHolder) && !(resHolder instanceof char[])) {
                        throw new IllegalArgumentException("Invalid result holder for %c");
                    }
                    rec.type = 2;
                    break;
                }
                case 'b': 
                case 'v': {
                    if (!(resHolder instanceof BooleanHolder) && !(resHolder instanceof boolean[])) {
                        throw new IllegalArgumentException("Invalid result holder for %" + c);
                    }
                    rec.type = 1;
                    break;
                }
                case 'f': {
                    if (resHolder instanceof DoubleHolder || resHolder instanceof double[]) {
                        rec.type = 6;
                        break;
                    }
                    if (resHolder instanceof FloatHolder || resHolder instanceof float[]) {
                        rec.type = 5;
                        break;
                    }
                    throw new IllegalArgumentException("Invalid result holder for %f");
                }
                case 's': {
                    if (!(resHolder instanceof StringHolder) && !(resHolder instanceof String[])) {
                        throw new IllegalArgumentException("Invalid result holder for %s");
                    }
                    rec.type = 7;
                    break;
                }
            }
        }
        rec.resHolder = rec.convertCode == 'h' ? null : resHolder;
        scanner.skipWhiteSpace();
        if (scanner.peekc() == '{') {
            if (rec.convertCode == 'h') {
                throw new IllegalArgumentException("Ranges not supported for %h");
            }
            i0 = scanner.getIndex();
            do {
                if ((c = scanner.getc()) != '\u0000') continue;
                throw new IllegalArgumentException("Unterminated range specification");
            } while (c != '}');
            i1 = scanner.getIndex();
            this.scanRangeSpec(rec, scanner.substring(i0, i1));
            if (rec.convertCode == 'v' && rec.rangeList != null) {
                rec.vval = rec.rangeList.low.bval;
            }
        }
        if (scanner.peekc() == 'X') {
            if (rec.convertCode == 'h') {
                throw new IllegalArgumentException("Multipliers not supported for %h");
            }
            scanner.getc();
            try {
                rec.numValues = (int)scanner.scanInt();
            }
            catch (StringScanException e) {
                throw new IllegalArgumentException("Malformed value multiplier");
            }
            if (rec.numValues <= 0) {
                throw new IllegalArgumentException("Value multiplier number must be > 0");
            }
        } else {
            rec.numValues = 1;
        }
        if (rec.numValues > 1) {
            ndesc = rec.nameList;
            while (ndesc != null) {
                if (ndesc.oneWord) {
                    throw new IllegalArgumentException("Multiplier value incompatible with one word option " + ndesc.name);
                }
                ndesc = ndesc.next;
            }
        }
        if (resHolder != null && resHolder.getClass().isArray()) {
            if (Array.getLength(resHolder) < rec.numValues) {
                throw new IllegalArgumentException("Result holder array must have a length >= " + rec.numValues);
            }
        } else if (rec.numValues > 1 && !(resHolder instanceof Vector)) {
            throw new IllegalArgumentException("Multiplier requires result holder to be an array of length >= " + rec.numValues);
        }
        scanner.skipWhiteSpace();
        if (!scanner.atEnd()) {
            if (scanner.getc() != '#') {
                throw new IllegalArgumentException("Illegal character(s), expecting '#'");
            }
            String helpInfo = scanner.substring(scanner.getIndex());
            int k = helpInfo.indexOf("#");
            if (k != -1) {
                rec.valueDesc = helpInfo.substring(0, k);
                rec.helpMsg = helpInfo.substring(k + 1);
            } else {
                rec.helpMsg = helpInfo;
            }
        } else {
            rec.helpMsg = "";
        }
        if (rec.convertCode == 'h' && this.firstHelpOption == this.defaultHelpOption) {
            this.matchList.remove(this.defaultHelpOption);
            this.firstHelpOption = rec;
        }
        this.matchList.add(rec);
    }

    Record lastMatchRecord() {
        return (Record)this.matchList.lastElement();
    }

    private Record getRecord(String arg, ObjectHolder ndescHolder) {
        for (int i = 0; i < this.matchList.size(); ++i) {
            Record rec = (Record)this.matchList.get(i);
            NameDesc ndesc = rec.nameList;
            while (ndesc != null) {
                if (rec.convertCode != 'v' && ndesc.oneWord) {
                    if (arg.startsWith(ndesc.name)) {
                        if (ndescHolder != null) {
                            ndescHolder.value = ndesc;
                        }
                        return rec;
                    }
                } else if (arg.equals(ndesc.name)) {
                    if (ndescHolder != null) {
                        ndescHolder.value = ndesc;
                    }
                    return rec;
                }
                ndesc = ndesc.next;
            }
        }
        return null;
    }

    Object getResultHolder(String arg) {
        Record rec = this.getRecord(arg, null);
        return rec != null ? rec.resHolder : null;
    }

    String getOptionName(String arg) {
        ObjectHolder ndescHolder = new ObjectHolder();
        Record rec = this.getRecord(arg, ndescHolder);
        return rec != null ? ((NameDesc)ndescHolder.value).name : null;
    }

    String getOptionRangeDesc(String arg) {
        Record rec = this.getRecord(arg, null);
        return rec != null ? rec.rangeDesc : null;
    }

    String getOptionTypeName(String arg) {
        Record rec = this.getRecord(arg, null);
        return rec != null ? rec.valTypeName() : null;
    }

    private Object createResultHolder(Record rec) {
        if (rec.numValues == 1) {
            switch (rec.type) {
                case 4: {
                    return new LongHolder();
                }
                case 2: {
                    return new CharHolder();
                }
                case 1: {
                    return new BooleanHolder();
                }
                case 6: {
                    return new DoubleHolder();
                }
                case 7: {
                    return new StringHolder();
                }
            }
        } else {
            switch (rec.type) {
                case 4: {
                    return new long[rec.numValues];
                }
                case 2: {
                    return new char[rec.numValues];
                }
                case 1: {
                    return new boolean[rec.numValues];
                }
                case 6: {
                    return new double[rec.numValues];
                }
                case 7: {
                    return new String[rec.numValues];
                }
            }
        }
        return null;
    }

    static void stringToArgs(Vector vec, String s, boolean allowQuotedStrings) throws StringScanException {
        StringScanner scanner = new StringScanner(s);
        scanner.skipWhiteSpace();
        while (!scanner.atEnd()) {
            if (allowQuotedStrings) {
                vec.add(scanner.scanString());
            } else {
                vec.add(scanner.scanNonWhiteSpaceString());
            }
            scanner.skipWhiteSpace();
        }
    }

    public static String[] prependArgs(Reader reader, String[] args) throws IOException {
        String line;
        if (args == null) {
            args = new String[]{};
        }
        LineNumberReader lineReader = new LineNumberReader(reader);
        Vector vec = new Vector(100, 100);
        while ((line = lineReader.readLine()) != null) {
            int commentIdx = line.indexOf("#");
            if (commentIdx != -1) {
                line = line.substring(0, commentIdx);
            }
            try {
                ArgParser.stringToArgs(vec, line, true);
            }
            catch (StringScanException e) {
                throw new IOException("malformed string, line " + lineReader.getLineNumber());
            }
        }
        String[] result = new String[vec.size() + args.length];
        for (int i = 0; i < vec.size(); ++i) {
            result[i] = (String)vec.get(i);
        }
        for (int k = 0; k < args.length; ++k) {
            result[i++] = args[k];
        }
        return result;
    }

    public static String[] prependArgs(File file, String[] args) throws IOException {
        if (args == null) {
            args = new String[]{};
        }
        if (!file.canRead()) {
            return args;
        }
        try {
            return ArgParser.prependArgs(new FileReader(file), args);
        }
        catch (IOException e) {
            throw new IOException("File " + file.getName() + ": " + e.getMessage());
        }
    }

    protected void setError(String msg) {
        this.errMsg = msg;
    }

    public void printErrorAndExit(String msg) {
        if (this.helpOptionsEnabled && this.firstHelpOptionName() != null) {
            msg = msg + "\nUse " + this.firstHelpOptionName() + " for help information";
        }
        if (this.printStream != null) {
            this.printStream.println(msg);
        }
        System.exit(1);
    }

    public void matchAllArgs(String[] args) {
        this.matchAllArgs(args, 0, EXIT_ON_UNMATCHED | EXIT_ON_ERROR);
    }

    public String[] matchAllArgs(String[] args, int idx, int exitFlags) {
        Vector<String> unmatched = new Vector<String>(10);
        while (idx < args.length) {
            try {
                idx = this.matchArg(args, idx);
                if (this.unmatchedArg == null) continue;
                if ((exitFlags & EXIT_ON_UNMATCHED) != 0) {
                    this.printErrorAndExit("Unrecognized argument: " + this.unmatchedArg);
                    continue;
                }
                unmatched.add(this.unmatchedArg);
            }
            catch (ArgParseException e) {
                if ((exitFlags & EXIT_ON_ERROR) == 0) break;
                this.printErrorAndExit(e.getMessage());
                break;
            }
        }
        if (unmatched.size() == 0) {
            return null;
        }
        return unmatched.toArray(new String[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int matchArg(String[] args, int idx) throws ArgParseException {
        this.unmatchedArg = null;
        this.setError(null);
        try {
            ObjectHolder ndescHolder = new ObjectHolder();
            Record rec = this.getRecord(args[idx], ndescHolder);
            if (rec == null || rec.convertCode == 'h' && !this.helpOptionsEnabled) {
                this.unmatchedArg = new String(args[idx]);
                return idx + 1;
            }
            NameDesc ndesc = (NameDesc)ndescHolder.value;
            Object result = rec.resHolder instanceof Vector ? this.createResultHolder(rec) : rec.resHolder;
            if (rec.convertCode == 'h') {
                if (!this.helpOptionsEnabled) return idx + 1;
                this.printStream.println(this.getHelpMessage());
                System.exit(0);
            } else if (rec.convertCode != 'v') {
                if (ndesc.oneWord) {
                    rec.scanValue(result, ndesc.name, args[idx].substring(ndesc.name.length()), 0);
                } else {
                    if (idx + rec.numValues >= args.length) {
                        throw new ArgParseException(ndesc.name, "requires " + rec.numValues + " value" + (rec.numValues > 1 ? "s" : ""));
                    }
                    for (int k = 0; k < rec.numValues; ++k) {
                        rec.scanValue(result, ndesc.name, args[++idx], k);
                    }
                }
            } else if (rec.resHolder instanceof BooleanHolder) {
                ((BooleanHolder)result).value = rec.vval;
            } else {
                for (int k = 0; k < rec.numValues; ++k) {
                    ((boolean[])result)[k] = rec.vval;
                }
            }
            if (!(rec.resHolder instanceof Vector)) return idx + 1;
            ((Vector)rec.resHolder).add(result);
            return idx + 1;
        }
        catch (ArgParseException e) {
            this.setError(e.getMessage());
            throw e;
        }
    }

    private String spaceString(int n) {
        StringBuffer sbuf = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            sbuf.append(' ');
        }
        return sbuf.toString();
    }

    public String getHelpMessage() {
        boolean hasOneWordAlias = false;
        String s = "Usage: " + this.synopsisString + "\n";
        s = s + "Options include:\n\n";
        for (int i = 0; i < this.matchList.size(); ++i) {
            String optionInfo = "";
            Record rec = (Record)this.matchList.get(i);
            if (rec.convertCode == 'h' && !this.helpOptionsEnabled) continue;
            NameDesc ndesc = rec.nameList;
            while (ndesc != null) {
                if (ndesc.oneWord) {
                    hasOneWordAlias = true;
                    break;
                }
                ndesc = ndesc.next;
            }
            ndesc = rec.nameList;
            while (ndesc != null) {
                optionInfo = optionInfo + ndesc.name;
                if (hasOneWordAlias && !ndesc.oneWord) {
                    optionInfo = optionInfo + " ";
                }
                if (ndesc.next != null) {
                    optionInfo = optionInfo + ",";
                }
                ndesc = ndesc.next;
            }
            if (!hasOneWordAlias) {
                optionInfo = optionInfo + " ";
            }
            if (rec.convertCode != 'v' && rec.convertCode != 'h') {
                optionInfo = rec.valueDesc != null ? optionInfo + rec.valueDesc : (rec.rangeDesc != null ? optionInfo + "<" + rec.valTypeName() + " " + rec.rangeDesc + ">" : optionInfo + "<" + rec.valTypeName() + ">");
            }
            if (rec.numValues > 1) {
                optionInfo = optionInfo + "X" + rec.numValues;
            }
            s = s + optionInfo;
            if (rec.helpMsg.length() > 0) {
                int pad = this.helpIndent - optionInfo.length();
                if (pad < 2) {
                    pad = this.helpIndent;
                }
                s = s + this.spaceString(4) + rec.helpMsg;
            }
            s = s + '\n';
        }
        return s;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public String getUnmatchedArgument() {
        return this.unmatchedArg;
    }

    class Record {
        NameDesc nameList;
        static final int NOTYPE = 0;
        static final int BOOLEAN = 1;
        static final int CHAR = 2;
        static final int INT = 3;
        static final int LONG = 4;
        static final int FLOAT = 5;
        static final int DOUBLE = 6;
        static final int STRING = 7;
        int type;
        int numValues;
        boolean vectorResult = false;
        String helpMsg = null;
        String valueDesc = null;
        String rangeDesc = null;
        Object resHolder = null;
        RangeAtom rangeList = null;
        RangeAtom rangeTail = null;
        char convertCode;
        boolean vval = true;

        Record() {
        }

        NameDesc firstNameDesc() {
            return this.nameList;
        }

        RangeAtom firstRangeAtom() {
            return this.rangeList;
        }

        int numRangeAtoms() {
            int cnt = 0;
            RangeAtom ra = this.rangeList;
            while (ra != null) {
                ++cnt;
                ra = ra.next;
            }
            return cnt;
        }

        void addRangeAtom(RangeAtom ra) {
            if (this.rangeList == null) {
                this.rangeList = ra;
            } else {
                this.rangeTail.next = ra;
            }
            this.rangeTail = ra;
        }

        boolean withinRange(double d) {
            if (this.rangeList == null) {
                return true;
            }
            RangeAtom ra = this.rangeList;
            while (ra != null) {
                if (ra.match(d)) {
                    return true;
                }
                ra = ra.next;
            }
            return false;
        }

        boolean withinRange(long l) {
            if (this.rangeList == null) {
                return true;
            }
            RangeAtom ra = this.rangeList;
            while (ra != null) {
                if (ra.match(l)) {
                    return true;
                }
                ra = ra.next;
            }
            return false;
        }

        boolean withinRange(String s) {
            if (this.rangeList == null) {
                return true;
            }
            RangeAtom ra = this.rangeList;
            while (ra != null) {
                if (ra.match(s)) {
                    return true;
                }
                ra = ra.next;
            }
            return false;
        }

        boolean withinRange(boolean b) {
            if (this.rangeList == null) {
                return true;
            }
            RangeAtom ra = this.rangeList;
            while (ra != null) {
                if (ra.match(b)) {
                    return true;
                }
                ra = ra.next;
            }
            return false;
        }

        String valTypeName() {
            switch (this.convertCode) {
                case 'i': {
                    return "integer";
                }
                case 'o': {
                    return "octal integer";
                }
                case 'd': {
                    return "decimal integer";
                }
                case 'x': {
                    return "hex integer";
                }
                case 'c': {
                    return "char";
                }
                case 'b': {
                    return "boolean";
                }
                case 'f': {
                    return "float";
                }
                case 's': {
                    return "string";
                }
            }
            return "unknown";
        }

        void scanValue(Object result, String name, String s, int resultIdx) throws ArgParseException {
            double dval = 0.0;
            String sval = null;
            long lval = 0L;
            boolean bval = false;
            if (s.length() == 0) {
                throw new ArgParseException(name, "requires a contiguous value");
            }
            StringScanner scanner = new StringScanner(s);
            try {
                switch (this.convertCode) {
                    case 'i': {
                        lval = scanner.scanInt();
                        break;
                    }
                    case 'o': {
                        lval = scanner.scanInt(8, false);
                        break;
                    }
                    case 'd': {
                        lval = scanner.scanInt(10, false);
                        break;
                    }
                    case 'x': {
                        lval = scanner.scanInt(16, false);
                        break;
                    }
                    case 'c': {
                        lval = scanner.scanChar();
                        break;
                    }
                    case 'b': {
                        bval = scanner.scanBoolean();
                        break;
                    }
                    case 'f': {
                        dval = scanner.scanDouble();
                        break;
                    }
                    case 's': {
                        sval = scanner.getString();
                    }
                }
            }
            catch (StringScanException e) {
                throw new ArgParseException(name, "malformed " + this.valTypeName() + " '" + s + "'");
            }
            scanner.skipWhiteSpace();
            if (!scanner.atEnd()) {
                throw new ArgParseException(name, "malformed " + this.valTypeName() + " '" + s + "'");
            }
            boolean outOfRange = false;
            switch (this.type) {
                case 2: 
                case 3: 
                case 4: {
                    outOfRange = !this.withinRange(lval);
                    break;
                }
                case 5: 
                case 6: {
                    outOfRange = !this.withinRange(dval);
                    break;
                }
                case 7: {
                    outOfRange = !this.withinRange(sval);
                    break;
                }
                case 1: {
                    boolean bl = outOfRange = !this.withinRange(bval);
                }
            }
            if (outOfRange) {
                String errmsg = "value " + s + " not in range ";
                throw new ArgParseException(name, "value '" + s + "' not in range " + this.rangeDesc);
            }
            if (result.getClass().isArray()) {
                switch (this.type) {
                    case 1: {
                        ((boolean[])result)[resultIdx] = bval;
                        break;
                    }
                    case 2: {
                        ((char[])result)[resultIdx] = (char)lval;
                        break;
                    }
                    case 3: {
                        ((int[])result)[resultIdx] = (int)lval;
                        break;
                    }
                    case 4: {
                        ((long[])result)[resultIdx] = lval;
                        break;
                    }
                    case 5: {
                        ((float[])result)[resultIdx] = (float)dval;
                        break;
                    }
                    case 6: {
                        ((double[])result)[resultIdx] = dval;
                        break;
                    }
                    case 7: {
                        ((String[])result)[resultIdx] = sval;
                    }
                }
            } else {
                switch (this.type) {
                    case 1: {
                        ((BooleanHolder)result).value = bval;
                        break;
                    }
                    case 2: {
                        ((CharHolder)result).value = (char)lval;
                        break;
                    }
                    case 3: {
                        ((IntHolder)result).value = (int)lval;
                        break;
                    }
                    case 4: {
                        ((LongHolder)result).value = lval;
                        break;
                    }
                    case 5: {
                        ((FloatHolder)result).value = (float)dval;
                        break;
                    }
                    case 6: {
                        ((DoubleHolder)result).value = dval;
                        break;
                    }
                    case 7: {
                        ((StringHolder)result).value = sval;
                    }
                }
            }
        }
    }

    class RangeAtom {
        RangePnt low = null;
        RangePnt high = null;
        RangeAtom next = null;

        RangeAtom(RangePnt p0, RangePnt p1, int type) throws IllegalArgumentException {
            int cmp = 0;
            switch (type) {
                case 2: 
                case 3: 
                case 4: {
                    cmp = p0.compareTo(p1.lval);
                    break;
                }
                case 5: 
                case 6: {
                    cmp = p0.compareTo(p1.dval);
                    break;
                }
                case 7: {
                    cmp = p0.compareTo(p1.sval);
                }
            }
            if (cmp > 0) {
                this.low = p1;
                this.high = p0;
            } else {
                this.low = p0;
                this.high = p1;
            }
        }

        RangeAtom(RangePnt p0) throws IllegalArgumentException {
            this.low = p0;
        }

        boolean match(double d) {
            int lc = this.low.compareTo(d);
            if (this.high != null) {
                int hc = this.high.compareTo(d);
                return lc * hc < 0 || this.low.closed && lc == 0 || this.high.closed && hc == 0;
            }
            return lc == 0;
        }

        boolean match(long l) {
            int lc = this.low.compareTo(l);
            if (this.high != null) {
                int hc = this.high.compareTo(l);
                return lc * hc < 0 || this.low.closed && lc == 0 || this.high.closed && hc == 0;
            }
            return lc == 0;
        }

        boolean match(String s) {
            int lc = this.low.compareTo(s);
            if (this.high != null) {
                int hc = this.high.compareTo(s);
                return lc * hc < 0 || this.low.closed && lc == 0 || this.high.closed && hc == 0;
            }
            return lc == 0;
        }

        boolean match(boolean b) {
            return this.low.compareTo(b) == 0;
        }

        public String toString() {
            return "low=" + (this.low == null ? "null" : this.low.toString()) + ", high=" + (this.high == null ? "null" : this.high.toString());
        }
    }

    static class RangePnt {
        double dval = 0.0;
        long lval = 0L;
        String sval = null;
        boolean bval = true;
        boolean closed = true;

        RangePnt(String s, boolean closed) {
            this.sval = s;
            this.closed = closed;
        }

        RangePnt(double d, boolean closed) {
            this.dval = d;
            this.closed = closed;
        }

        RangePnt(long l, boolean closed) {
            this.lval = l;
            this.closed = closed;
        }

        RangePnt(boolean b, boolean closed) {
            this.bval = b;
            this.closed = closed;
        }

        RangePnt(StringScanner scanner, int type) throws IllegalArgumentException {
            String typeName = null;
            try {
                switch (type) {
                    case 2: {
                        typeName = "character";
                        this.lval = scanner.scanChar();
                        break;
                    }
                    case 3: 
                    case 4: {
                        typeName = "integer";
                        this.lval = scanner.scanInt();
                        break;
                    }
                    case 5: 
                    case 6: {
                        typeName = "float";
                        this.dval = scanner.scanDouble();
                        break;
                    }
                    case 7: {
                        typeName = "string";
                        this.sval = scanner.scanString();
                        break;
                    }
                    case 1: {
                        typeName = "boolean";
                        this.bval = scanner.scanBoolean();
                    }
                }
            }
            catch (StringScanException e) {
                throw new IllegalArgumentException("Malformed " + typeName + " '" + scanner.substring(scanner.getIndex(), e.getFailIndex() + 1) + "' in range spec");
            }
        }

        void setClosed(boolean closed) {
            this.closed = closed;
        }

        boolean getClosed() {
            return this.closed;
        }

        int compareTo(double d) {
            if (this.dval < d) {
                return -1;
            }
            if (d == this.dval) {
                return 0;
            }
            return 1;
        }

        int compareTo(long l) {
            if (this.lval < l) {
                return -1;
            }
            if (l == this.lval) {
                return 0;
            }
            return 1;
        }

        int compareTo(String s) {
            return this.sval.compareTo(s);
        }

        int compareTo(boolean b) {
            if (b == this.bval) {
                return 0;
            }
            return 1;
        }

        public String toString() {
            return "{ dval=" + this.dval + ", lval=" + this.lval + ", sval=" + this.sval + ", bval=" + this.bval + ", closed=" + this.closed + "}";
        }
    }

    static class NameDesc {
        String name;
        boolean oneWord;
        NameDesc next = null;

        NameDesc() {
        }
    }
}

