/*
 * SPDX-FileCopyrightText: 2011 Peter Penz <peter.penz19@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "viewmodesettings.h"

#include "dolphin_compactmodesettings.h"
#include "dolphin_detailsmodesettings.h"
#include "dolphin_iconsmodesettings.h"

#define VIEWMODESETTINGS_SET_VALUE(mode, setValue, value) \
    switch (mode) { \
    case ViewModeSettings::IconsMode:   IconsModeSettings::setValue(value); break; \
    case ViewModeSettings::CompactMode: CompactModeSettings::setValue(value); break; \
    case ViewModeSettings::DetailsMode: DetailsModeSettings::setValue(value); break; \
    default: Q_ASSERT(false); break; \
    }

#define VIEWMODESETTINGS_RETURN_VALUE(mode, getValue, type) \
    type value; \
    switch (m_mode) { \
    case IconsMode:   value = IconsModeSettings::getValue(); break; \
    case CompactMode: value = CompactModeSettings::getValue(); break; \
    case DetailsMode: value = DetailsModeSettings::getValue(); break; \
    default:          value = IconsModeSettings::getValue(); \
                      Q_ASSERT(false); \
                      break; \
    } \
    return value

ViewModeSettings::ViewModeSettings(ViewMode mode) :
    m_mode(mode)
{
}

ViewModeSettings::~ViewModeSettings()
{
}

void ViewModeSettings::setIconSize(int size) const
{
    VIEWMODESETTINGS_SET_VALUE(m_mode, setIconSize, size);
}

int ViewModeSettings::iconSize() const
{
    VIEWMODESETTINGS_RETURN_VALUE(m_mode, iconSize, int);
}

void ViewModeSettings::setPreviewSize(int size) const
{
    VIEWMODESETTINGS_SET_VALUE(m_mode, setPreviewSize, size);
}

int ViewModeSettings::previewSize() const
{
    VIEWMODESETTINGS_RETURN_VALUE(m_mode, previewSize, int);
}

void ViewModeSettings::setUseSystemFont(bool flag)
{
    VIEWMODESETTINGS_SET_VALUE(m_mode, setUseSystemFont, flag);
}

bool ViewModeSettings::useSystemFont() const
{
    VIEWMODESETTINGS_RETURN_VALUE(m_mode, useSystemFont, bool);
}

void ViewModeSettings::setFontFamily(const QString& fontFamily)
{
    VIEWMODESETTINGS_SET_VALUE(m_mode, setFontFamily, fontFamily);
}

QString ViewModeSettings::fontFamily() const
{
    VIEWMODESETTINGS_RETURN_VALUE(m_mode, fontFamily, QString);
}

void ViewModeSettings::setFontSize(qreal fontSize)
{
    VIEWMODESETTINGS_SET_VALUE(m_mode, setFontSize, fontSize);
}

qreal ViewModeSettings::fontSize() const
{
    VIEWMODESETTINGS_RETURN_VALUE(m_mode, fontSize, qreal);
}

void ViewModeSettings::setItalicFont(bool italic)
{
    VIEWMODESETTINGS_SET_VALUE(m_mode, setItalicFont, italic);
}

bool ViewModeSettings::italicFont() const
{
    VIEWMODESETTINGS_RETURN_VALUE(m_mode, italicFont, bool);
}

void ViewModeSettings::setFontWeight(int fontWeight)
{
    VIEWMODESETTINGS_SET_VALUE(m_mode, setFontWeight, fontWeight);
}

int ViewModeSettings::fontWeight() const
{
    VIEWMODESETTINGS_RETURN_VALUE(m_mode, fontWeight, int);
}

void ViewModeSettings::readConfig()
{
    switch (m_mode) {
    case ViewModeSettings::IconsMode:   IconsModeSettings::self()->load(); break;
    case ViewModeSettings::CompactMode: CompactModeSettings::self()->load(); break;
    case ViewModeSettings::DetailsMode: DetailsModeSettings::self()->load(); break;
    default: Q_ASSERT(false); break;
    }
}

void ViewModeSettings::save()
{
    switch (m_mode) {
    case ViewModeSettings::IconsMode:   IconsModeSettings::self()->save(); break;
    case ViewModeSettings::CompactMode: CompactModeSettings::self()->save(); break;
    case ViewModeSettings::DetailsMode: DetailsModeSettings::self()->save(); break;
    default: Q_ASSERT(false); break;
    }
}
