// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file sequence_structTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "sequence_structTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "sequence_struct.hpp"


using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_NestedSequenceElement_type_identifier(
        TypeIdentifierPair& type_ids_NestedSequenceElement)
{

    ReturnCode_t return_code_NestedSequenceElement {eprosima::fastdds::dds::RETCODE_OK};
    return_code_NestedSequenceElement =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "NestedSequenceElement", type_ids_NestedSequenceElement);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_NestedSequenceElement)
    {
        StructTypeFlag struct_flags_NestedSequenceElement = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_NestedSequenceElement = "NestedSequenceElement";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_NestedSequenceElement;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_NestedSequenceElement;
        CompleteTypeDetail detail_NestedSequenceElement = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_NestedSequenceElement, ann_custom_NestedSequenceElement, type_name_NestedSequenceElement.to_string());
        CompleteStructHeader header_NestedSequenceElement;
        header_NestedSequenceElement = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_NestedSequenceElement);
        CompleteStructMemberSeq member_seq_NestedSequenceElement;
        {
            TypeIdentifierPair type_ids_my_string;
            ReturnCode_t return_code_my_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_my_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_string)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_my_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_my_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_string = 0x00000000;
            bool common_my_string_ec {false};
            CommonStructMember common_my_string {TypeObjectUtils::build_common_struct_member(member_id_my_string, member_flags_my_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_string, common_my_string_ec))};
            if (!common_my_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_string = "my_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_string;
            ann_custom_NestedSequenceElement.reset();
            CompleteMemberDetail detail_my_string = TypeObjectUtils::build_complete_member_detail(name_my_string, member_ann_builtin_my_string, ann_custom_NestedSequenceElement);
            CompleteStructMember member_my_string = TypeObjectUtils::build_complete_struct_member(common_my_string, detail_my_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_NestedSequenceElement, member_my_string);
        }
        CompleteStructType struct_type_NestedSequenceElement = TypeObjectUtils::build_complete_struct_type(struct_flags_NestedSequenceElement, header_NestedSequenceElement, member_seq_NestedSequenceElement);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_NestedSequenceElement, type_name_NestedSequenceElement.to_string(), type_ids_NestedSequenceElement))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "NestedSequenceElement already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ComplexSequenceElement_type_identifier(
        TypeIdentifierPair& type_ids_ComplexSequenceElement)
{

    ReturnCode_t return_code_ComplexSequenceElement {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ComplexSequenceElement =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ComplexSequenceElement", type_ids_ComplexSequenceElement);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ComplexSequenceElement)
    {
        StructTypeFlag struct_flags_ComplexSequenceElement = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ComplexSequenceElement = "ComplexSequenceElement";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ComplexSequenceElement;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ComplexSequenceElement;
        CompleteTypeDetail detail_ComplexSequenceElement = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ComplexSequenceElement, ann_custom_ComplexSequenceElement, type_name_ComplexSequenceElement.to_string());
        CompleteStructHeader header_ComplexSequenceElement;
        header_ComplexSequenceElement = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ComplexSequenceElement);
        CompleteStructMemberSeq member_seq_ComplexSequenceElement;
        {
            TypeIdentifierPair type_ids_my_short;
            ReturnCode_t return_code_my_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_my_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_short = 0x00000000;
            bool common_my_short_ec {false};
            CommonStructMember common_my_short {TypeObjectUtils::build_common_struct_member(member_id_my_short, member_flags_my_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_short, common_my_short_ec))};
            if (!common_my_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_short = "my_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_short;
            ann_custom_ComplexSequenceElement.reset();
            CompleteMemberDetail detail_my_short = TypeObjectUtils::build_complete_member_detail(name_my_short, member_ann_builtin_my_short, ann_custom_ComplexSequenceElement);
            CompleteStructMember member_my_short = TypeObjectUtils::build_complete_struct_member(common_my_short, detail_my_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_ComplexSequenceElement, member_my_short);
        }
        {
            TypeIdentifierPair type_ids_my_long;
            ReturnCode_t return_code_my_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_my_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_long = 0x00000001;
            bool common_my_long_ec {false};
            CommonStructMember common_my_long {TypeObjectUtils::build_common_struct_member(member_id_my_long, member_flags_my_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_long, common_my_long_ec))};
            if (!common_my_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_long = "my_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_long;
            ann_custom_ComplexSequenceElement.reset();
            CompleteMemberDetail detail_my_long = TypeObjectUtils::build_complete_member_detail(name_my_long, member_ann_builtin_my_long, ann_custom_ComplexSequenceElement);
            CompleteStructMember member_my_long = TypeObjectUtils::build_complete_struct_member(common_my_long, detail_my_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_ComplexSequenceElement, member_my_long);
        }
        {
            TypeIdentifierPair type_ids_my_complex_element;
            ReturnCode_t return_code_my_complex_element {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_complex_element =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "NestedSequenceElement", type_ids_my_complex_element);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_complex_element)
            {
            ::register_NestedSequenceElement_type_identifier(type_ids_my_complex_element);
            }
            StructMemberFlag member_flags_my_complex_element = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_complex_element = 0x00000002;
            bool common_my_complex_element_ec {false};
            CommonStructMember common_my_complex_element {TypeObjectUtils::build_common_struct_member(member_id_my_complex_element, member_flags_my_complex_element, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_complex_element, common_my_complex_element_ec))};
            if (!common_my_complex_element_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_complex_element member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_complex_element = "my_complex_element";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_complex_element;
            ann_custom_ComplexSequenceElement.reset();
            CompleteMemberDetail detail_my_complex_element = TypeObjectUtils::build_complete_member_detail(name_my_complex_element, member_ann_builtin_my_complex_element, ann_custom_ComplexSequenceElement);
            CompleteStructMember member_my_complex_element = TypeObjectUtils::build_complete_struct_member(common_my_complex_element, detail_my_complex_element);
            TypeObjectUtils::add_complete_struct_member(member_seq_ComplexSequenceElement, member_my_complex_element);
        }
        CompleteStructType struct_type_ComplexSequenceElement = TypeObjectUtils::build_complete_struct_type(struct_flags_ComplexSequenceElement, header_ComplexSequenceElement, member_seq_ComplexSequenceElement);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ComplexSequenceElement, type_name_ComplexSequenceElement.to_string(), type_ids_ComplexSequenceElement))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ComplexSequenceElement already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SequenceStruct_type_identifier(
        TypeIdentifierPair& type_ids_SequenceStruct)
{

    ReturnCode_t return_code_SequenceStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SequenceStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SequenceStruct", type_ids_SequenceStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SequenceStruct)
    {
        StructTypeFlag struct_flags_SequenceStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SequenceStruct = "SequenceStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SequenceStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SequenceStruct;
        CompleteTypeDetail detail_SequenceStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SequenceStruct, ann_custom_SequenceStruct, type_name_SequenceStruct.to_string());
        CompleteStructHeader header_SequenceStruct;
        header_SequenceStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SequenceStruct);
        CompleteStructMemberSeq member_seq_SequenceStruct;
        {
            TypeIdentifierPair type_ids_my_basic_sequence;
            ReturnCode_t return_code_my_basic_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_basic_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_char_unbounded", type_ids_my_basic_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_basic_sequence)
            {
                return_code_my_basic_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_char", type_ids_my_basic_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_basic_sequence)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_char_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_char_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_basic_sequence, element_identifier_anonymous_sequence_char_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_char_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_char_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_my_basic_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_char_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_char_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_char_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_char_unbounded, element_flags_anonymous_sequence_char_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_char_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_char_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_char_unbounded", type_ids_my_basic_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_char_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_my_basic_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_basic_sequence = 0x00000000;
            bool common_my_basic_sequence_ec {false};
            CommonStructMember common_my_basic_sequence {TypeObjectUtils::build_common_struct_member(member_id_my_basic_sequence, member_flags_my_basic_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_basic_sequence, common_my_basic_sequence_ec))};
            if (!common_my_basic_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_basic_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_basic_sequence = "my_basic_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_basic_sequence;
            ann_custom_SequenceStruct.reset();
            CompleteMemberDetail detail_my_basic_sequence = TypeObjectUtils::build_complete_member_detail(name_my_basic_sequence, member_ann_builtin_my_basic_sequence, ann_custom_SequenceStruct);
            CompleteStructMember member_my_basic_sequence = TypeObjectUtils::build_complete_struct_member(common_my_basic_sequence, detail_my_basic_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceStruct, member_my_basic_sequence);
        }
        {
            TypeIdentifierPair type_ids_my_bounded_sequence;
            ReturnCode_t return_code_my_bounded_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_bounded_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_float_13", type_ids_my_bounded_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_bounded_sequence)
            {
                return_code_my_bounded_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_float", type_ids_my_bounded_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_bounded_sequence)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_float_13_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_float_13 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_bounded_sequence, element_identifier_anonymous_sequence_float_13_ec))};
                if (!element_identifier_anonymous_sequence_float_13_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_float_13 = EK_COMPLETE;
                if (TK_NONE == type_ids_my_bounded_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_float_13 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_float_13 = 0;
                PlainCollectionHeader header_anonymous_sequence_float_13 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_float_13, element_flags_anonymous_sequence_float_13);
                {
                    SBound bound = static_cast<SBound>(13);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_float_13, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_float_13));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_float_13", type_ids_my_bounded_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_float_13 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_my_bounded_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_bounded_sequence = 0x00000001;
            bool common_my_bounded_sequence_ec {false};
            CommonStructMember common_my_bounded_sequence {TypeObjectUtils::build_common_struct_member(member_id_my_bounded_sequence, member_flags_my_bounded_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_bounded_sequence, common_my_bounded_sequence_ec))};
            if (!common_my_bounded_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_bounded_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_bounded_sequence = "my_bounded_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_bounded_sequence;
            ann_custom_SequenceStruct.reset();
            CompleteMemberDetail detail_my_bounded_sequence = TypeObjectUtils::build_complete_member_detail(name_my_bounded_sequence, member_ann_builtin_my_bounded_sequence, ann_custom_SequenceStruct);
            CompleteStructMember member_my_bounded_sequence = TypeObjectUtils::build_complete_struct_member(common_my_bounded_sequence, detail_my_bounded_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceStruct, member_my_bounded_sequence);
        }
        {
            TypeIdentifierPair type_ids_my_complex_sequence;
            ReturnCode_t return_code_my_complex_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_complex_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_ComplexSequenceElement_unbounded", type_ids_my_complex_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_complex_sequence)
            {
                return_code_my_complex_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "ComplexSequenceElement", type_ids_my_complex_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_complex_sequence)
                {
                ::register_ComplexSequenceElement_type_identifier(type_ids_my_complex_sequence);
                }
                bool element_identifier_anonymous_sequence_ComplexSequenceElement_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_ComplexSequenceElement_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_complex_sequence, element_identifier_anonymous_sequence_ComplexSequenceElement_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_ComplexSequenceElement_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_ComplexSequenceElement_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_my_complex_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_ComplexSequenceElement_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_ComplexSequenceElement_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_ComplexSequenceElement_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_ComplexSequenceElement_unbounded, element_flags_anonymous_sequence_ComplexSequenceElement_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_ComplexSequenceElement_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_ComplexSequenceElement_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_ComplexSequenceElement_unbounded", type_ids_my_complex_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_ComplexSequenceElement_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_my_complex_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_complex_sequence = 0x00000002;
            bool common_my_complex_sequence_ec {false};
            CommonStructMember common_my_complex_sequence {TypeObjectUtils::build_common_struct_member(member_id_my_complex_sequence, member_flags_my_complex_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_complex_sequence, common_my_complex_sequence_ec))};
            if (!common_my_complex_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_complex_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_complex_sequence = "my_complex_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_complex_sequence;
            ann_custom_SequenceStruct.reset();
            CompleteMemberDetail detail_my_complex_sequence = TypeObjectUtils::build_complete_member_detail(name_my_complex_sequence, member_ann_builtin_my_complex_sequence, ann_custom_SequenceStruct);
            CompleteStructMember member_my_complex_sequence = TypeObjectUtils::build_complete_struct_member(common_my_complex_sequence, detail_my_complex_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceStruct, member_my_complex_sequence);
        }
        {
            TypeIdentifierPair type_ids_my_complex_bounded_sequence;
            ReturnCode_t return_code_my_complex_bounded_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_complex_bounded_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_ComplexSequenceElement_123", type_ids_my_complex_bounded_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_complex_bounded_sequence)
            {
                return_code_my_complex_bounded_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "ComplexSequenceElement", type_ids_my_complex_bounded_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_complex_bounded_sequence)
                {
                ::register_ComplexSequenceElement_type_identifier(type_ids_my_complex_bounded_sequence);
                }
                bool element_identifier_anonymous_sequence_ComplexSequenceElement_123_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_ComplexSequenceElement_123 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_complex_bounded_sequence, element_identifier_anonymous_sequence_ComplexSequenceElement_123_ec))};
                if (!element_identifier_anonymous_sequence_ComplexSequenceElement_123_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_ComplexSequenceElement_123 = EK_COMPLETE;
                if (TK_NONE == type_ids_my_complex_bounded_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_ComplexSequenceElement_123 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_ComplexSequenceElement_123 = 0;
                PlainCollectionHeader header_anonymous_sequence_ComplexSequenceElement_123 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_ComplexSequenceElement_123, element_flags_anonymous_sequence_ComplexSequenceElement_123);
                {
                    SBound bound = static_cast<SBound>(123);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_ComplexSequenceElement_123, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_ComplexSequenceElement_123));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_ComplexSequenceElement_123", type_ids_my_complex_bounded_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_ComplexSequenceElement_123 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_my_complex_bounded_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_complex_bounded_sequence = 0x00000003;
            bool common_my_complex_bounded_sequence_ec {false};
            CommonStructMember common_my_complex_bounded_sequence {TypeObjectUtils::build_common_struct_member(member_id_my_complex_bounded_sequence, member_flags_my_complex_bounded_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_complex_bounded_sequence, common_my_complex_bounded_sequence_ec))};
            if (!common_my_complex_bounded_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_complex_bounded_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_complex_bounded_sequence = "my_complex_bounded_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_complex_bounded_sequence;
            ann_custom_SequenceStruct.reset();
            CompleteMemberDetail detail_my_complex_bounded_sequence = TypeObjectUtils::build_complete_member_detail(name_my_complex_bounded_sequence, member_ann_builtin_my_complex_bounded_sequence, ann_custom_SequenceStruct);
            CompleteStructMember member_my_complex_bounded_sequence = TypeObjectUtils::build_complete_struct_member(common_my_complex_bounded_sequence, detail_my_complex_bounded_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_SequenceStruct, member_my_complex_bounded_sequence);
        }
        CompleteStructType struct_type_SequenceStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_SequenceStruct, header_SequenceStruct, member_seq_SequenceStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SequenceStruct, type_name_SequenceStruct.to_string(), type_ids_SequenceStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SequenceStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}

