/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */



#include "multi_tap_delay.h"
#include <stdlib.h>



sample *multi_tap_delay_get_buffer(multi_tap_delay *this)
{
  
  return mixer_get_buffer(this->mix);

}

void multi_tap_delay_next_buffer(multi_tap_delay *this)
{
  int i;
  for(i = 0; i < this->num_taps;i++)
    this->combs[i]->next_buffer(this->combs[i]);

  this->mix->next_buffer(this->mix);
}

static sample_producer **get_children(multi_tap_delay *this)
{
  return (sample_producer **)&(this->mix);
}

static char **get_header(multi_tap_delay *this)
{
  static char *header[] = { NULL };
  return header;
}

static char **get_code(multi_tap_delay *this)
{
  static char *code[] = {
    "$o = $i0;",
    NULL
  };
  return code;
}

static char **get_footer(multi_tap_delay *this)
{
  static char *footer[] = { NULL };
  return footer;
}

multi_tap_delay *multi_tap_delay_new(int num_taps, sample_producer *input)
{
  int i;

  multi_tap_delay *out = (multi_tap_delay *)malloc(sizeof(multi_tap_delay));
  out->get_buffer = multi_tap_delay_get_buffer;
  out->next_buffer = multi_tap_delay_next_buffer;
  out->get_children	= get_children;
  out->get_header	= get_header;
  out->get_code		= get_code;
  out->get_footer	= get_footer;
  out->unused		= NULL;

  out->num_taps = num_taps;
  out->input = input;
  out->combs = (delay**)malloc(sizeof(delay*) * (out->num_taps + 1));

  out->combs[0] = delay_new(375,MAX_FEEDBACK *.5,out->input);
  for(i = 1;i < out->num_taps;i++)
    out->combs[i] = delay_new(0,0,(sample_producer *)out->combs[i - 1]);
  out->combs[out->num_taps] = NULL;

  out->mix = mixer_new((sample_producer**)out->combs);

  mixer_set_amplitude(out->mix,MIX_MAX_AMP,0);
  for(i = 1;i < out->num_taps;i++)
    mixer_set_amplitude(out->mix,0,i);

  return out;
}

/*
  Local Variables:
  mode: font-lock
  End:
*/

