// Code generated by cuelang.org/go/pkg/gen. DO NOT EDIT.

package json

import (
	"cuelang.org/go/internal/core/adt"
	"cuelang.org/go/internal/pkg"
)

func init() {
	pkg.Register("encoding/json", p)
}

var _ = adt.TopKind // in case the adt package isn't used

var p = &pkg.Package{
	Native: []*pkg.Builtin{{
		Name: "Valid",
		Params: []pkg.Param{
			{Kind: adt.BytesKind | adt.StringKind},
		},
		Result: adt.BoolKind,
		Func: func(c *pkg.CallCtxt) {
			data := c.Bytes(0)
			if c.Do() {
				c.Ret = Valid(data)
			}
		},
	}, {
		Name: "Compact",
		Params: []pkg.Param{
			{Kind: adt.BytesKind | adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			src := c.Bytes(0)
			if c.Do() {
				c.Ret, c.Err = Compact(src)
			}
		},
	}, {
		Name: "Indent",
		Params: []pkg.Param{
			{Kind: adt.BytesKind | adt.StringKind},
			{Kind: adt.StringKind},
			{Kind: adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			src, prefix, indent := c.Bytes(0), c.String(1), c.String(2)
			if c.Do() {
				c.Ret, c.Err = Indent(src, prefix, indent)
			}
		},
	}, {
		Name: "HTMLEscape",
		Params: []pkg.Param{
			{Kind: adt.BytesKind | adt.StringKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			src := c.Bytes(0)
			if c.Do() {
				c.Ret = HTMLEscape(src)
			}
		},
	}, {
		Name: "Marshal",
		Params: []pkg.Param{
			{Kind: adt.TopKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			v := c.Value(0)
			if c.Do() {
				c.Ret, c.Err = Marshal(v)
			}
		},
	}, {
		Name: "MarshalStream",
		Params: []pkg.Param{
			{Kind: adt.TopKind},
		},
		Result: adt.StringKind,
		Func: func(c *pkg.CallCtxt) {
			v := c.Value(0)
			if c.Do() {
				c.Ret, c.Err = MarshalStream(v)
			}
		},
	}, {
		Name: "UnmarshalStream",
		Params: []pkg.Param{
			{Kind: adt.BytesKind | adt.StringKind},
		},
		Result: adt.TopKind,
		Func: func(c *pkg.CallCtxt) {
			data := c.Bytes(0)
			if c.Do() {
				c.Ret, c.Err = UnmarshalStream(data)
			}
		},
	}, {
		Name: "Unmarshal",
		Params: []pkg.Param{
			{Kind: adt.BytesKind | adt.StringKind},
		},
		Result: adt.TopKind,
		Func: func(c *pkg.CallCtxt) {
			b := c.Bytes(0)
			if c.Do() {
				c.Ret, c.Err = Unmarshal(b)
			}
		},
	}, {
		Name: "Validate",
		Params: []pkg.Param{
			{Kind: adt.BytesKind | adt.StringKind},
			{Kind: adt.TopKind},
		},
		Result:      adt.BoolKind,
		NonConcrete: true,
		Func: func(c *pkg.CallCtxt) {
			b, v := c.Bytes(0), c.Schema(1)
			if c.Do() {
				c.Ret, c.Err = validate(c.OpContext(), b, v)
			}
		},
	}},
}
