package main

import (
    "bytes"
    "compress/gzip"
    "fmt"
    "io"
)

func bindata_read(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	return buf.Bytes(), nil
}

func views_example_ace() ([]byte, error) {
	return bindata_read([]byte{
		0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x00, 0xff, 0x84, 0xcb,
		0xb1, 0x11, 0x83, 0x30, 0x14, 0x03, 0xd0, 0x9e, 0x29, 0xb4, 0x40, 0x8a,
		0x74, 0x69, 0xbc, 0x41, 0x96, 0x10, 0xfc, 0x4f, 0xcc, 0x9d, 0xed, 0xcf,
		0x19, 0xa5, 0xf0, 0xf6, 0x21, 0x2c, 0x40, 0x23, 0xdd, 0xe9, 0x9e, 0x12,
		0x2c, 0x16, 0x8d, 0xdd, 0x91, 0x55, 0xcb, 0xf4, 0x0f, 0x14, 0xb6, 0x4f,
		0xf2, 0x36, 0x01, 0xd9, 0x69, 0x67, 0x01, 0xd5, 0x45, 0x2c, 0x99, 0xfd,
		0x70, 0xa5, 0xaf, 0xd6, 0xc7, 0xeb, 0x9a, 0xb5, 0xa9, 0x38, 0xde, 0x41,
		0x83, 0xbc, 0xee, 0x85, 0xf2, 0x03, 0x6b, 0x8f, 0x8a, 0x79, 0x6b, 0xec,
		0x03, 0x46, 0xf1, 0x94, 0x73, 0xd8, 0xb8, 0x0e, 0xf9, 0x79, 0xab, 0x7f,
		0x01, 0x00, 0x00, 0xff, 0xff, 0x6b, 0xc6, 0x6a, 0x49, 0x92, 0x00, 0x00,
		0x00,
		},
		"views/example.ace",
	)
}


// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	if f, ok := _bindata[name]; ok {
		return f()
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string] func() ([]byte, error) {
	"views/example.ace": views_example_ace,
}
