# Copyright 2018 OpenStack Foundation.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Increase delayed_calls_v2.auth_context column size from JsonDictType to
JsonMediumDictType

Revision ID: 030
Revises: 029
Create Date: 2018-08-07 08:35:57.609328

"""

# revision identifiers, used by Alembic.
revision = '030'
down_revision = '029'

from alembic import op
from mistral.db.sqlalchemy import types as st


def upgrade():
    # Changing column type from JsonDictType to JsonLongDictType
    op.alter_column('delayed_calls_v2', 'auth_context',
                    type_=st.JsonMediumDictType())
