C
C	$Id: conrec.f,v 1.7 2008-07-27 00:23:01 haley Exp $
C                                                                      
C                Copyright (C)  2000
C        University Corporation for Atmospheric Research
C                All Rights Reserved
C
C The use of this Software is governed by a License Agreement.
C
      SUBROUTINE CONREC (Z,L,M,N,FLO,HI,FINC,NSET,NHI,NDOT)
C
C     DIMENSION OF           Z(L,N)
C     ARGUMENTS
C
C     PURPOSE                CONRECQCK draws a contour map from data stored
C                            in a rectangular array.  No line labels.
C
C     USAGE                  If the following assumptions are met, use
C
C                              CALL EZCNTR (Z,M,N)
C
C                              ASSUMPTIONS:
C                                  --All of the array is to be contoured.
C                                  --Contour levels are picked
C                                    internally.
C                                  --Contouring routine picks scale
C                                    factors.
C                                  --Highs and lows are marked.
C                                  --Negative lines are drawn with a
C                                    dashed line pattern.
C                                  --EZCNTR calls FRAME after drawing the
C                                    contour map.
C
C                            If these assumptions are not met, use
C
C                              CALL CONREC (Z,L,M,N,FLO,HI,FINC,NSET,
C                                           NHI,NDOT)
C
C     ARGUMENTS
C
C     ON INPUT               Z
C     FOR EZCNTR               M by N array to be contoured.
C
C                            M
C                              First dimension of Z.
C
C                            N
C                              Second dimension of Z.
C
C     ON OUTPUT              All arguments are unchanged.
C     FOR EZCNTR
C
C     ON INPUT               Z
C     FOR CONREC               The (origin of the) array to be
C                              contoured.  Z is dimensioned L by N.
C
C                            L
C                              The first dimension of Z in the calling
C                              program.
C
C                            M
C                              The number of data values to be contoured
C                              in the X-direction (the first subscript
C                              direction).  When plotting an entire
C                              array, L = M.
C
C                            N
C                              The number of data values to be contoured
C                              in the Y-direction (the second subscript
C                              direction).
C
C                            FLO
C                              The value of the lowest contour level.
C                              If FLO = HI = 0., a value rounded up from
C                              the minimum Z is generated by CONREC.
C
C                            HI
C                              The value of the highest contour level.
C                              If HI = FLO = 0., a value rounded down
C                              from the maximum Z is generated by
C                              CONREC.
C
C                            FINC
C                              > 0  Increment between contour levels.
C                              = 0  A value, which produces between 10
C                                   and 30 contour levels at nice values,
C                                   is generated by CONREC.
C                              < 0  The number of levels generated by
C                                   CONREC is ABS(FINC).
C
C                            NSET
C                              Flag to control scaling.
C                              = 0  CONREC automatically sets the
C                                   window and viewport to properly
C                                   scale the frame to the standard
C                                   configuration.
C                                   The GRIDAL entry PERIM is
C                                   called and tick marks are placed
C                                   corresponding to the data points.
C                              > 0  CONREC assumes that the user
C                                   has set the window and viewport
C                                   in such a way as to properly
C                                   scale the plotting
C                                   instructions generated by CONREC.
C                                   PERIM is not called.
C                              < 0  CONREC generates coordinates so as
C                                   to place the (untransformed) contour
C                                   plot within the limits of the
C                                   user's current window and
C                                   viewport.  PERIM is not called.
C
C                            NHI
C                              Flag to control extra information on the
C                              contour plot.
C                              = 0  Highs and lows are marked with an H
C                                   or L as appropriate, and the value
C                                   of the high or low is plotted under
C                                   the symbol.
C                              > 0  The data values are plotted at
C                                   each Z point, with the center of
C                                   the string indicating the data
C                                   point location.
C                              < 0  Neither of the above.
C
C                            NDOT
C                              A 10-bit constant designating the desired
C                              dashed line pattern.
C                              If ABS(NDOT) = 0, 1, or 1023, solid lines
C                              are drawn.
C                              > 0 NDOT pattern is used for all lines.
C                              < 0 ABS(NDOT) pattern is used for nega-
C                                tive-valued contour lines, and solid is
C                                used for positive-valued contours.
C                                CONREC converts NDOT
C                                to a 16-bit pattern and DASHDB is used.
C                                See DASHDB comments in the DASHLINE
C                                documentation for details.
C
C
C
C     ON OUTPUT              All arguments are unchanged.
C     FOR CONREC
C
C
C     ENTRY POINTS           CONREC, CLGEN, QUICK, MAXMIN, PNTVAL,
C                            CALCNT, EZCNTR, CONBD, CONBDX
C
C     COMMON BLOCKS          CONRE1, CONRE4, CONRE5
C
C     REQUIRED LIBRARY       GRIDAL, the ERPRT77 package, and the SPPS.
C     ROUTINES               DASHCHAR is also needed.
C
C     REQUIRED GKS LEVEL     0A
C
C     NOTE FOR NCAR USERS    This routine is NOT part of the default
C     USERS                  libraries at NCAR.  CONRECQCK must be
C                            be acquired, compiled and loaded to be
C                            used at NCAR.
C
C     I/O                    Plots contour map.
C
C     PRECISION              Single
C
C     LANGUAGE               FORTRAN 77
C
C     HISTORY                A faster version of CONREC without line
C                            labelling capabilities.
C
C     ALGORITHM              The grid space is divided into L*N
C                            cells.  Each cell is processed in turn,
C                            drawing all contour lines in the
C                            particular cell until the entire
C                            rectangular space is contoured.  (This
C                            could result in a relatively long plot
C                            time on mechanical plotters but does
C                            not affect the plot time on CRT-based
C                            plotters.
C
C     NOTE                   To draw non-uniform contour levels, see
C                            the comments in CLGEN.  To make special
C                            modifications for specific needs see the
C                            explanation of the internal parameters
C                            below.
C
C     TIMING                 Varies widely with size and smoothness of
C                            Z.
C
C     INTERNAL PARAMETERS    NAME   DEFAULT         FUNCTION
C                            ----   -------         --------
C
C                            ISIZEM   2      Size of labels for minimums
C                                            and maximums,
C                                            as per the size definitions
C                                            given in the SPPS
C                                            documentation for WTSTR.
C
C                            ISIZEP   0      Size of labels for data
C                                            point values as per the size
C                                            definitions given in the SPPS
C                                            documentation for WTSTR.
C
C                            NLA      16     Approximate number of
C                                            contour levels when
C                                            internally generated.
C
C                            NLM      40     Maximum number of contour
C                                            levels.  If this is to be
C                                            increased, the dimensions
C                                            of CL and RWORK in CONREC
C                                            must be increased by the
C                                            same amount.
C
C                            XLT      .05    Left hand edge of the plot
C                                            (0.0 is the left edge of
C                                            the frame and 1.0 is the
C                                            right edge of the frame.)
C
C                            YBT      .05    Bottom edge of the plot
C                                            (0.0 is the bottom of the
C                                            frame and 1.0 is the top
C                                            of the frame.)
C
C                            SIDE     0.9    Length of longer edge of
C                                            plot (see also EXT).
C
C                            IOFFD    0      Flag to control
C                                            normalization of label
C                                            numbers.
C                                            . IOFFD = 0 means include
C                                              decimal point when
C                                              possible (do not
C                                              normalize unless
C                                              required).
C                                            . IOFFD non-zero means
C                                              normalize all label
C                                              numbers and output a
C                                              scale factor in the
C                                              message below the graph.
C
C                            EXT      .25    Lengths of the sides of the
C                                            plot are proportional to M
C                                            and N (when CONREC sets
C                                            the window and viewport).
C                                            In extreme cases, when
C                                            MIN(M,N)/MAX(M,N) is less
C                                            than EXT, CONREC
C                                            produces a square plot.
C
C                            IOFFP      0    Flag to control special
C                                            value feature.
C                                            . IOFFP = 0 means special
C                                              value feature not in use.
C                                            . IOFFP non-zero means
C                                              special value feature in
C                                              use.  (SPVAL is set to the
C                                              special value.)  Contour
C                                              lines will then be
C                                              omitted from any cell
C                                              with any corner equal to
C                                              the special value.
C
C                            SPVAL    0.     Contains the special value
C                                            when IOFFP is non-zero.
C
C                            IOFFM    0      Flag to control the message
C                                            below the plot.
C                                            . IOFFM = 0  if the message
C                                              is to be plotted.
C                                            . IOFFM non-zero if the
C                                              message is to be omitted.
C
      SAVE
      CHARACTER       ENCSCR*22  ,IWORK*126
      DIMENSION       LNGTHS(5)  ,HOLD(5)
      DIMENSION       Z(L,N)     ,CL(40)
      DIMENSION       WIND(4)    ,VIEW(4)    ,RECT(4)
C
      COMMON /CONRE1/ IOFFP      ,SPVAL
      COMMON /CONRE4/ ISIZEL     ,ISIZEM     ,ISIZEP     ,NREP       ,
     1                NCRT       ,ILAB       ,NULBLL     ,IOFFD      ,
     2                EXT        ,IOFFM      ,ISOLID     ,NLA        ,
     3                NLM        ,XLT        ,YBT        ,SIDE
      COMMON /CONRE5/ SCLY
C
      DATA  LNGTHS(1),LNGTHS(2),LNGTHS(3),LNGTHS(4),LNGTHS(5)
     1      /  12,       3,        20,       9,        17       /
C
C Do a call forcing a BLOCKDATA to be loaded from a binary library.
C
      CALL CONBD
C
C THE FOLLOWING CALL IS FOR GATHERING STATISTICS ON LIBRARY USE AT NCAR
C
      CALL Q8QST4 ('GRAPHX','CONRECQCK','CONREC','VERSION 01')
C
C                       * * * * * * * * * *
C                            * * * * * * * * * *
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
      GL = FLO
      HA = HI
      GP = FINC
      MX = L
      NX = M
      NY = N
      IDASH = NDOT
C
      IF (IDASH.EQ.0 .OR. IDASH.EQ.1) IDASH = ISOLID
C
C SET CONTOUR LEVELS.
C
      CALL CLGEN (Z,MX,NX,NY,GL,HA,GP,NLA,NLM,CL,NCL,ICNST)
C
C
C                       * * * * * * * * * *
C                            * * * * * * * * * *
C
C
C Save the current SET parameters.
C
      CALL GETSET (VIEW(1),VIEW(2),VIEW(3),VIEW(4),
     +             WIND(1),WIND(2),WIND(3),WIND(4),IOLLS)
C
C SET UP SCALING  LABELS
C
      CALL GETUSV ( 'YF' , IYVAL )
      SCLY = 2.0 ** (IYVAL - 15)
C
C SET UP SCALING
C
      IF (NSET) 101,102,106
C
  101 X1 = VIEW(1)
      X2 = VIEW(2)
      Y1 = VIEW(3)
      Y2 = VIEW(4)
C
C
C
C
C
C DEFINE NORMALIZATION 1 AND LOG SCALING
C
      CALL SET(X1,X2,Y1,Y2,1.0,REAL(NX),1.0,REAL(NY),1)
      GO TO 106
  102 X1 = XLT
      X2 = XLT+SIDE
      Y1 = YBT
      Y2 = YBT+SIDE
      X3 = NX
      Y3 = NY
      IF (MIN(X3,Y3)/MAX(X3,Y3) .LT. EXT) GO TO 105
      IF (NX-NY) 103,105,104
  103 X2 = SIDE*X3/Y3+XLT
      GO TO 105
  104 Y2 = SIDE*Y3/X3+YBT
C
  105 CALL SET(X1,X2,Y1,Y2,1.0,X3,1.0,Y3,1)
      CALL PERIM (NX-1,1,NY-1,1)
  106 IF (ICNST .NE. 0) GO TO 111
C
C SET UP LABEL SCALING
C
      IOFFDT = IOFFD
      IF (GL.NE.0.0 .AND. (ABS(GL).LT.0.1 .OR. ABS(GL).GE.1.E5))
     1    IOFFDT = 1
      IF (HA.NE.0.0 .AND. (ABS(HA).LT.0.1 .OR. ABS(HA).GE.1.E5))
     1    IOFFDT = 1
      ASH = 10.**(3-INT(ALOG10(MAX(ABS(GL),ABS(HA),ABS(GP)))
     1                                                  -4999.999)-5000)
      IF (IOFFDT .EQ. 0) ASH = 1.
      IF (IOFFM .NE. 0) GO TO 110
         IWORK = 'CONTOUR FROM              TO              CONTOUR INTE
     1RVAL OF              PT(3,3)=              LABELS SCALED BY'
  107 CONTINUE
      HOLD(1) = GL
      HOLD(2) = HA
      HOLD(3) = GP
      HOLD(4) = Z(3,3)
      HOLD(5) = ASH
      NCHAR = 0
      DO 109 I=1,5
         WRITE (ENCSCR,'(G13.5)') HOLD(I)
         NCHAR = NCHAR+LNGTHS(I)
         DO 108 J=1,13
            NCHAR = NCHAR+1
            IWORK(NCHAR:NCHAR) = ENCSCR(J:J)
  108    CONTINUE
  109 CONTINUE
      IF (ASH .EQ. 1.) NCHAR = NCHAR-13-LNGTHS(5)
C
C WRITE PLOT TITLE
C
C
      CALL GQCLIP (IERR,ICLP,RECT)
      CALL GSCLIP (0)
      CALL WTSTR (CFUX(.5),CFUY(.015625),IWORK(1:NCHAR),0,0,0)
      CALL GSCLIP (ICLP)
C
C
C PROCESS ENTIRE GRID
C
C
C CHANGE 10 BIT PATTERN TO 16 BIT PATTERN FOR USE WITH DASHD
C
  110 IDASH = IOR ( ISHIFT(IDASH,6) , ISHIFT(IDASH,-4) )
      CALL DASHDB ( IDASH )
      CALL QUICK (Z,L,M,N,NCL,CL)
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C
C FIND RELATIVE MINIMUMS AND MAXIMUMS IF WANTED, AND MARK VALUES IF
C WANTED.
C
      IF (NHI .EQ. 0) CALL MAXMIN (Z,MX,NX,NY,ISIZEM,ASH,IOFFDT)
      IF (NHI .GT. 0) CALL MAXMIN (Z,MX,NX,NY,ISIZEP,-ASH,IOFFDT)
C
      GO TO 114
  111 CONTINUE
         IWORK = 'CONSTANT FIELD'
  112 CONTINUE
      WRITE (ENCSCR,'(G22.14)') GL
      DO 113 I=1,22
      IWORK(I+14:I+14) = ENCSCR(I:I)
  113 CONTINUE
C
C WRITE TITLE
      CALL GQCLIP (IERR,ICLP,RECT)
      CALL GSCLIP (0)
      CALL WTSTR (CFUX(.09765),CFUY(.48828),IWORK(1:36),3,0,-1 )
      CALL GSCLIP (ICLP)
  114 CONTINUE
C
C RESTORE NORMALIZATION TRANSFORMATION 1
C
      IF (NSET.LE.0)
     +    CALL SET(VIEW(1),VIEW(2),VIEW(3),VIEW(4),
     +             WIND(1),WIND(2),WIND(3),WIND(4),IOLLS)
C
C
C
C
C
C
      RETURN
C
C
      END
