# Snapshot report for `test/format.js`

The actual snapshot is saved in `format.js.snap`.

Generated by [AVA](https://avajs.dev).

## formats primitive: null

> Snapshot 1

    '%null.open%null%null.close%'

## formats primitive: undefined

> Snapshot 1

    '%undefined.open%undefined%undefined.close%'

## formats primitive: false

> Snapshot 1

    '%boolean.open%false%boolean.close%'

## formats primitive: true

> Snapshot 1

    '%boolean.open%true%boolean.close%'

## formats primitive: 

> Snapshot 1

    '%string.line.open#\'%%string.open%%string.close%%string.line.close#\'%'

## formats primitive: foo

> Snapshot 1

    '%string.line.open#\'%%string.open%foo%string.close%%string.line.close#\'%'

## formats primitive: \ -- ' -- "

> Snapshot 1

    '%string.line.open#\'%%string.open%\\\\ -- \' -- "%string.close%%string.line.close#\'%'

## formats primitive: foo\nbar\baz'"

> Snapshot 1

    `%string.multiline.start#`%%string.open%foo%string.close%%string.controlPicture.open%␊%string.controlPicture.close%%string.open%%string.close%␊
    %string.open%bar\\\\baz'"%string.close%%string.multiline.end#`%`

## formats primitive: qux\r\nquux

> Snapshot 1

    `%string.multiline.start#`%%string.open%qux%string.close%%string.controlPicture.open%␍%string.controlPicture.close%%string.open%%string.close%%string.controlPicture.open%␊%string.controlPicture.close%%string.open%%string.close%␊
    %string.open%quux%string.close%%string.multiline.end#`%`

## formats primitive: qux\rquux

> Snapshot 1

    `%string.multiline.start#`%%string.open%qux%string.close%%string.controlPicture.open%␍%string.controlPicture.close%%string.open%%string.close%␊
    %string.open%quux%string.close%%string.multiline.end#`%`

## formats primitive: 42

> Snapshot 1

    '%number.open%42%number.close%'

## formats primitive: -42

> Snapshot 1

    '%number.open%-42%number.close%'

## formats primitive: -0

> Snapshot 1

    '%number.open%-0%number.close%'

## formats primitive: 0

> Snapshot 1

    '%number.open%0%number.close%'

## formats primitive: Infinity

> Snapshot 1

    '%number.open%Infinity%number.close%'

## formats primitive: -Infinity

> Snapshot 1

    '%number.open%-Infinity%number.close%'

## formats primitive: NaN

> Snapshot 1

    '%number.open%NaN%number.close%'

## formats primitive: Symbol()

> Snapshot 1

    '%symbol.open%Symbol()%symbol.close%'

## formats primitive: Symbol(foo)

> Snapshot 1

    '%symbol.open%Symbol(foo)%symbol.close%'

## formats primitive: Symbol(foo\nbar)

> Snapshot 1

    '%symbol.open%Symbol(foo\\nbar)%symbol.close%'

## formats primitive: Symbol(bar)

> Snapshot 1

    '%symbol.open%Symbol.for(bar)%symbol.close%'

## formats primitive: Symbol(bar\nbaz)

> Snapshot 1

    '%symbol.open%Symbol.for(bar\\nbaz)%symbol.close%'

## formats primitive: Symbol(Symbol.iterator)

> Snapshot 1

    '%symbol.open%Symbol.iterator%symbol.close%'

## formats primitive: 42n

> Snapshot 1

    '%bigInt.open%42n%bigInt.close%'

## formats primitive: -42n

> Snapshot 1

    '%bigInt.open%-42n%bigInt.close%'

## escapes ' according to theme

> Snapshot 1

    '<\\\'>'

> Snapshot 2

    `<\\'␊␊
    >`

## escapes " according to theme

> Snapshot 1

    '<\\">'

> Snapshot 2

    `<\\"␊␊
    >`

## escapes ` according to theme

> Snapshot 1

    '<\\`>'

> Snapshot 2

    `<\\`␊␊
    >`

## escapes singlequotes in one-line strings with the default theme

> should be escaped

    '\'\\\'\''

> should not be escaped

    ``'␊␊
    ``

## escapes backticks in multi-line strings with the default theme

> should not be escaped

    '\'`\''

> should be escaped

    ``\\`␊␊
    ``

## formats a simple object

> Snapshot 1

    `%object.openBracket#{%␊
      baz%property.separator#: %%string.line.open#'%%string.open%qux%string.close%%string.line.close#'%%property.after#,%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %object.closeBracket#}%`

## formats a simple, nested object

> Snapshot 1

    `%object.openBracket#{%␊
      foo%property.separator#: %%object.openBracket#{%␊
        baz%property.separator#: %%string.line.open#'%%string.open%qux%string.close%%string.line.close#'%%property.after#,%␊
      %object.closeBracket#}%%property.after#,%␊
    %object.closeBracket#}%`

## formats multiline strings inside an object

> Snapshot 1

    `%object.openBracket#{%␊
      %string.line.open#'%%string.open%foo\\nbar%string.close%%string.line.close#'%%property.separator#: %%string.multiline.start#`%%string.open%baz%string.close%%string.controlPicture.open%␊%string.controlPicture.close%%string.open%%string.close%␊
      %string.open%qux%string.close%%string.multiline.end#`%%property.after#,%␊
    %object.closeBracket#}%`

## formats symbol keys

> Snapshot 1

    `%object.openBracket#{%␊
      %property.keyBracket.open#[%%symbol.open%Symbol()%symbol.close%%property.keyBracket.close#]%%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %object.closeBracket#}%`

## formats boxed primitive: false

> Snapshot 1

    `%object.ctor.open%Boolean%object.ctor.close% %object.openBracket#{%␊
      %boolean.open%false%boolean.close%␊
    %object.closeBracket#}%`

## formats boxed primitive: true

> Snapshot 1

    `%object.ctor.open%Boolean%object.ctor.close% %object.openBracket#{%␊
      %boolean.open%true%boolean.close%␊
    %object.closeBracket#}%`

## formats boxed primitive: 42

> Snapshot 1

    `%object.ctor.open%Number%object.ctor.close% %object.openBracket#{%␊
      %number.open%42%number.close%␊
    %object.closeBracket#}%`

## formats boxed primitive: -42

> Snapshot 1

    `%object.ctor.open%Number%object.ctor.close% %object.openBracket#{%␊
      %number.open%-42%number.close%␊
    %object.closeBracket#}%`

## formats boxed primitive: -0

> Snapshot 1

    `%object.ctor.open%Number%object.ctor.close% %object.openBracket#{%␊
      %number.open%-0%number.close%␊
    %object.closeBracket#}%`

## formats boxed primitive: 0

> Snapshot 1

    `%object.ctor.open%Number%object.ctor.close% %object.openBracket#{%␊
      %number.open%0%number.close%␊
    %object.closeBracket#}%`

## formats boxed primitive: Infinity

> Snapshot 1

    `%object.ctor.open%Number%object.ctor.close% %object.openBracket#{%␊
      %number.open%Infinity%number.close%␊
    %object.closeBracket#}%`

## formats boxed primitive: -Infinity

> Snapshot 1

    `%object.ctor.open%Number%object.ctor.close% %object.openBracket#{%␊
      %number.open%-Infinity%number.close%␊
    %object.closeBracket#}%`

## formats boxed primitive: NaN

> Snapshot 1

    `%object.ctor.open%Number%object.ctor.close% %object.openBracket#{%␊
      %number.open%NaN%number.close%␊
    %object.closeBracket#}%`

## formats boxed primitive: foo

> Snapshot 1

    `%object.ctor.open%String%object.ctor.close% %object.openBracket#{%␊
      %string.line.open#'%%string.open%foo%string.close%%string.line.close#'%␊
    %object.closeBracket#}%`

## formats boxed primitive: 42n

> Snapshot 1

    `%object.ctor.open%BigInt%object.ctor.close% %object.openBracket#{%␊
      %bigInt.open%42n%bigInt.close%␊
    %object.closeBracket#}%`

## formats boxed primitive: -42n

> Snapshot 1

    `%object.ctor.open%BigInt%object.ctor.close% %object.openBracket#{%␊
      %bigInt.open%-42n%bigInt.close%␊
    %object.closeBracket#}%`

## formats boxed primitives with extra properties

> Snapshot 1

    `%object.ctor.open%String%object.ctor.close% %object.openBracket#{%␊
      %string.line.open#'%%string.open%foo%string.close%%string.line.close#'%␊
      %stats.separator#---%␊
      bar%property.separator#: %%string.line.open#'%%string.open%baz%string.close%%string.line.close#'%%property.after#,%␊
    %object.closeBracket#}%`

## formats a simple array

> Snapshot 1

    `%list.openBracket#[%␊
      %string.line.open#'%%string.open%foo%string.close%%string.line.close#'%%item.after#,%␊
      %string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%item.after#,%␊
    %list.closeBracket#]%`

## formats a simple, nested array

> Snapshot 1

    `%list.openBracket#[%␊
      %list.openBracket#[%␊
        %string.line.open#'%%string.open%foo%string.close%%string.line.close#'%%item.after#,%␊
        %string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%item.after#,%␊
      %list.closeBracket#]%%item.after#,%␊
    %list.closeBracket#]%`

## formats an array with additional properties

> Snapshot 1

    `%list.openBracket#[%␊
      %string.line.open#'%%string.open%foo%string.close%%string.line.close#'%%item.after#,%␊
      %string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%item.after#,%␊
      %stats.separator#---%␊
      baz%property.separator#: %%string.line.open#'%%string.open%qux%string.close%%string.line.close#'%%property.after#,%␊
    %list.closeBracket#]%`

> Snapshot 2

    `%list.openBracket#[%␊
      %number.open%1%number.close%%item.after#,%␊
      %number.open%2%number.close%%item.after#,%␊
      %number.open%3%number.close%%item.after#,%␊
      %stats.separator#---%␊
      -1%property.separator#: %%number.open%-1%number.close%%property.after#,%␊
    %list.closeBracket#]%`

## formats a multiline string inside an array

> Snapshot 1

    `%list.openBracket#[%␊
      %string.multiline.start#`%%string.open%bar%string.close%%string.controlPicture.open%␊%string.controlPicture.close%%string.open%%string.close%␊
      %string.open%baz%string.close%%string.multiline.end#`%%item.after#,%␊
    %list.closeBracket#]%`

## formats maps

> Snapshot 1

    `%object.ctor.open%Map%object.ctor.close% %object.openBracket#{%␊
      %string.line.open#'%%string.open%foo%string.close%%string.line.close#'%%mapEntry.separator# => %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%mapEntry.after#,%␊
      %object.openBracket#{%␊
        baz%property.separator#: %%string.line.open#'%%string.open%qux%string.close%%string.line.close#'%%property.after#,%␊
      %object.closeBracket#}%%mapEntry.separator# => %%string.line.open#'%%string.open%quux%string.close%%string.line.close#'%%mapEntry.after#,%␊
      %string.line.open#'%%string.open%corge%string.close%%string.line.close#'%%mapEntry.separator# => %%object.openBracket#{%␊
        grault%property.separator#: %%string.line.open#'%%string.open%garply%string.close%%string.line.close#'%%property.after#,%␊
      %object.closeBracket#}%%mapEntry.after#,%␊
    %object.closeBracket#}%`

## formats multiline strings inside a map

> Snapshot 1

    `%object.ctor.open%Map%object.ctor.close% %object.openBracket#{%␊
      %string.multiline.start#`%%string.open%foo%string.close%%string.controlPicture.open%␊%string.controlPicture.close%%string.open%%string.close%␊
      %string.open%bar%string.close%%string.multiline.end#`%%mapEntry.separator# => %%string.multiline.start#`%%string.open%baz%string.close%%string.controlPicture.open%␊%string.controlPicture.close%%string.open%%string.close%␊
      %string.open%qux%string.close%%string.multiline.end#`%%mapEntry.after#,%␊
    %object.closeBracket#}%`

## formats maps with additional properties

> Snapshot 1

    `%object.ctor.open%Map%object.ctor.close% %object.openBracket#{%␊
      baz%property.separator#: %%string.line.open#'%%string.open%qux%string.close%%string.line.close#'%%property.after#,%␊
      %stats.separator#---%␊
      %string.line.open#'%%string.open%foo%string.close%%string.line.close#'%%mapEntry.separator# => %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%mapEntry.after#,%␊
    %object.closeBracket#}%`

## formats sets

> Snapshot 1

    `%object.ctor.open%Set%object.ctor.close% %object.openBracket#{%␊
      %string.line.open#'%%string.open%foo%string.close%%string.line.close#'%%item.after#,%␊
      %object.openBracket#{%␊
        bar%property.separator#: %%string.line.open#'%%string.open%baz%string.close%%string.line.close#'%%property.after#,%␊
      %object.closeBracket#}%%item.after#,%␊
    %object.closeBracket#}%`

## formats a multiline string inside sets

> Snapshot 1

    `%object.ctor.open%Set%object.ctor.close% %object.openBracket#{%␊
      %string.multiline.start#`%%string.open%bar%string.close%%string.controlPicture.open%␊%string.controlPicture.close%%string.open%%string.close%␊
      %string.open%baz%string.close%%string.multiline.end#`%%item.after#,%␊
    %object.closeBracket#}%`

## formats sets with additional properties

> Snapshot 1

    `%object.ctor.open%Set%object.ctor.close% %object.openBracket#{%␊
      bar%property.separator#: %%string.line.open#'%%string.open%baz%string.close%%string.line.close#'%%property.after#,%␊
      %stats.separator#---%␊
      %string.line.open#'%%string.open%foo%string.close%%string.line.close#'%%item.after#,%␊
    %object.closeBracket#}%`

## formats funky objects that are lists and have an iterator

> Snapshot 1

    `%list.openBracket#[%␊
      %string.line.open#'%%string.open%first%string.close%%string.line.close#'%%item.after#,%␊
      %string.line.open#'%%string.open%second%string.close%%string.line.close#'%%item.after#,%␊
      %stats.separator#---%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
      %stats.separator#---%␊
      %string.line.open#'%%string.open%baz%string.close%%string.line.close#'%%item.after#,%␊
    %list.closeBracket#]%`

## formats regular expressions

> Snapshot 1

    '%regexp.source.open#/%foo%regexp.source.close#/%%regexp.flags.open%gim%regexp.flags.close%'

## formats regular expressions with additional properties

> Snapshot 1

    `%object.ctor.open%RegExp%object.ctor.close% %object.openBracket#{%␊
      %regexp.source.open#/%foo%regexp.source.close#/%%regexp.flags.open%gim%regexp.flags.close%␊
      %regexp.separator#---%␊
      bar%property.separator#: %%string.line.open#'%%string.open%baz%string.close%%string.line.close#'%%property.after#,%␊
    %object.closeBracket#}%`

## formats anonymous functions

> Snapshot 1

    '%function.stringTag.open%Function%function.stringTag.close% %object.openBracket#{%%object.closeBracket#}%'

## formats named functions

> Snapshot 1

    '%function.stringTag.open%Function%function.stringTag.close% %function.name.open%foo%function.name.close% %object.openBracket#{%%object.closeBracket#}%'

## formats functions with additional properties

> Snapshot 1

    `%function.stringTag.open%Function%function.stringTag.close% %function.name.open%foo%function.name.close% %object.openBracket#{%␊
      bar%property.separator#: %%string.line.open#'%%string.open%baz%string.close%%string.line.close#'%%property.after#,%␊
    %object.closeBracket#}%`

## formats arguments

> Snapshot 1

    `%object.ctor.open%Arguments%object.ctor.close% %list.openBracket#[%␊
      %string.line.open#'%%string.open%foo%string.close%%string.line.close#'%%item.after#,%␊
      %string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%item.after#,%␊
      %string.line.open#'%%string.open%baz%string.close%%string.line.close#'%%item.after#,%␊
    %list.closeBracket#]%`

## formats simple errors

> Snapshot 1

    `%error.name.open%TypeError%error.name.close% %object.openBracket#{%␊
      message%property.separator#: %%string.line.open#'%%string.open%Test message%string.close%%string.line.close#'%%property.after#,%␊
    %object.closeBracket#}%`

## formats simple errors with a modified name

> Snapshot 1

    `%error.name.open%FooError%error.name.close% %error.ctor.open#(%TypeError%error.ctor.close#)% %object.openBracket#{%␊
      message%property.separator#: %%string.line.open#'%%string.open%Test message%string.close%%string.line.close#'%%property.after#,%␊
    %object.closeBracket#}%`

## formats errors with a name that does not include Error and does not match the constructor

> Snapshot 1

    `%error.name.open%Bar%error.name.close% %error.ctor.open#(%Foo%error.ctor.close#)% %object.secondaryStringTag.open#@%Error%object.secondaryStringTag.close% %object.openBracket#{%␊
      message%property.separator#: %%string.line.open#'%%string.open%Test message%string.close%%string.line.close#'%%property.after#,%␊
    %object.closeBracket#}%`

## formats errors with additional properties

> Snapshot 1

    `%error.name.open%TypeError%error.name.close% %object.openBracket#{%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
      message%property.separator#: %%string.line.open#'%%string.open%Test message%string.close%%string.line.close#'%%property.after#,%␊
    %object.closeBracket#}%`

## formats promises

> Snapshot 1

    '%object.ctor.open%Promise%object.ctor.close% %object.openBracket#{%%object.closeBracket#}%'

## formats promises with additional properties

> Snapshot 1

    `%object.ctor.open%Promise%object.ctor.close% %object.openBracket#{%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %object.closeBracket#}%`

## formats pointers

> Snapshot 1

    `%object.openBracket#{%␊
      baz%property.separator#: %%object.openBracket#{%␊
        foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
      %object.closeBracket#}%%property.after#,%␊
      qux%property.separator#: %%object.openBracket#{%␊
        quux%property.separator#: %%object.openBracket#{%␊
          foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
        %object.closeBracket#}%%property.after#,%␊
      %object.closeBracket#}%%property.after#,%␊
    %object.closeBracket#}%`

## formats circular references

> Snapshot 1

    `%object.openBracket#{%␊
      circular%property.separator#: %%circular#[Circular]%%property.after#,%␊
    %object.closeBracket#}%`

## formats ArrayBuffer

> Snapshot 1

    `%object.ctor.open%ArrayBuffer%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
    %list.closeBracket#]%`

## formats ArrayBuffer with additional properties

> Snapshot 1

    `%object.ctor.open%ArrayBuffer%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %stats.separator#---%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %list.closeBracket#]%`

## formats Buffer @Uint8Array

> Snapshot 1

    `%object.ctor.open%Buffer%object.ctor.close% %object.secondaryStringTag.open#@%Uint8Array%object.secondaryStringTag.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
    %list.closeBracket#]%`

## formats Buffer @Uint8Array with additional properties

> Snapshot 1

    `%object.ctor.open%Buffer%object.ctor.close% %object.secondaryStringTag.open#@%Uint8Array%object.secondaryStringTag.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %stats.separator#---%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %list.closeBracket#]%`

## formats DataView

> Snapshot 1

    `%object.ctor.open%DataView%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
    %list.closeBracket#]%`

## formats DataView with additional properties

> Snapshot 1

    `%object.ctor.open%DataView%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %stats.separator#---%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %list.closeBracket#]%`

## formats Float32Array

> Snapshot 1

    `%object.ctor.open%Float32Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
    %list.closeBracket#]%`

## formats Float32Array with additional properties

> Snapshot 1

    `%object.ctor.open%Float32Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %stats.separator#---%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %list.closeBracket#]%`

## formats Float64Array

> Snapshot 1

    `%object.ctor.open%Float64Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
    %list.closeBracket#]%`

## formats Float64Array with additional properties

> Snapshot 1

    `%object.ctor.open%Float64Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %stats.separator#---%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %list.closeBracket#]%`

## formats Int16Array

> Snapshot 1

    `%object.ctor.open%Int16Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
    %list.closeBracket#]%`

## formats Int16Array with additional properties

> Snapshot 1

    `%object.ctor.open%Int16Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %stats.separator#---%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %list.closeBracket#]%`

## formats Int32Array

> Snapshot 1

    `%object.ctor.open%Int32Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
    %list.closeBracket#]%`

## formats Int32Array with additional properties

> Snapshot 1

    `%object.ctor.open%Int32Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %stats.separator#---%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %list.closeBracket#]%`

## formats Int8Array

> Snapshot 1

    `%object.ctor.open%Int8Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
    %list.closeBracket#]%`

## formats Int8Array with additional properties

> Snapshot 1

    `%object.ctor.open%Int8Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %stats.separator#---%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %list.closeBracket#]%`

## formats Uint16Array

> Snapshot 1

    `%object.ctor.open%Uint16Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
    %list.closeBracket#]%`

## formats Uint16Array with additional properties

> Snapshot 1

    `%object.ctor.open%Uint16Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %stats.separator#---%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %list.closeBracket#]%`

## formats Uint32Array

> Snapshot 1

    `%object.ctor.open%Uint32Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
    %list.closeBracket#]%`

## formats Uint32Array with additional properties

> Snapshot 1

    `%object.ctor.open%Uint32Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %stats.separator#---%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %list.closeBracket#]%`

## formats Uint8Array

> Snapshot 1

    `%object.ctor.open%Uint8Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
    %list.closeBracket#]%`

## formats Uint8Array with additional properties

> Snapshot 1

    `%object.ctor.open%Uint8Array%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %stats.separator#---%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %list.closeBracket#]%`

## formats Uint8ClampedArray

> Snapshot 1

    `%object.ctor.open%Uint8ClampedArray%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
    %list.closeBracket#]%`

## formats Uint8ClampedArray with additional properties

> Snapshot 1

    `%object.ctor.open%Uint8ClampedArray%object.ctor.close% %list.openBracket#[%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close% %typedArray.bytes.open%decafbad%typedArray.bytes.close%␊
      %stats.separator#---%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %list.closeBracket#]%`

## formats dates

> Snapshot 1

    '%object.ctor.open%Date%object.ctor.close% %date.value.open%1969-07-20 20:17:40 12ms UTC%date.value.close% %object.openBracket#{%%object.closeBracket#}%'

> Snapshot 2

    '%object.ctor.open%Date%object.ctor.close% %date.invalid#invalid% %object.openBracket#{%%object.closeBracket#}%'

## formats dates with additional properties

> Snapshot 1

    `%object.ctor.open%Date%object.ctor.close% %date.value.open%1969-07-20 20:17:40 UTC%date.value.close% %object.openBracket#{%␊
      foo%property.separator#: %%string.line.open#'%%string.open%bar%string.close%%string.line.close#'%%property.after#,%␊
    %object.closeBracket#}%`

## shows non-Object tag if constructor name is different

> Snapshot 1

    '%object.ctor.open%Foo%object.ctor.close% %object.openBracket#{%%object.closeBracket#}%'

> Snapshot 2

    '%object.ctor.open%Bar%object.ctor.close% %object.secondaryStringTag.open#@%Array%object.secondaryStringTag.close% %list.openBracket#[%%list.closeBracket#]%'

> Snapshot 3

    '%object.ctor.open%Baz%object.ctor.close% %object.secondaryStringTag.open#@%Date%object.secondaryStringTag.close% %date.value.open%1969-07-20 20:17:40 UTC%date.value.close% %object.openBracket#{%%object.closeBracket#}%'

> Snapshot 4

    `%object.ctor.open%Qux%object.ctor.close% %object.secondaryStringTag.open#@%RegExp%object.secondaryStringTag.close% %object.openBracket#{%␊
      %regexp.source.open#/%foo%regexp.source.close#/%%regexp.flags.open%%regexp.flags.close%␊
    %object.closeBracket#}%`

> Snapshot 5

    '%object.ctor.open%Quux%object.ctor.close% %object.secondaryStringTag.open#@%Int16Array%object.secondaryStringTag.close% %list.openBracket#[%%list.closeBracket#]%'

## shows string tag if object has no constructor

> Snapshot 1

    '%object.stringTag.open#@%Object%object.stringTag.close% %object.openBracket#{%%object.closeBracket#}%'

## formats global

> Snapshot 1

    '%global.open%Global%global.close% %object.openBracket#{%%object.closeBracket#}%'

## format with given plugin

> Snapshot 1

    `CustomError @Error {␊
      code: 'PLUGIN',␊
    }`

> Snapshot 2

    `Error {␊
      message: 'error',␊
    }`
