/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Square root of the mathematical constant `π`.
*
* @module @stdlib/constants/float64/sqrt-pi
* @type {number}
*
* @example
* var SQRT_PI = require( '@stdlib/constants/float64/sqrt-pi' );
* // returns 1.7724538509055160
*/


// MAIN //

/**
* Square root of the mathematical constant `π`.
*
* @constant
* @type {number}
* @default 1.7724538509055160
* @see [OEIS]{@link https://oeis.org/A002161}
* @see [Wikipedia]{@link https://en.wikipedia.org/wiki/Pi}
*/
var SQRT_PI = 1.772453850905516027298167483341145182797549456122387128213;


// EXPORTS //

module.exports = SQRT_PI;
