## Usage

```js
var toAbsGlob = require('{%= name %}');
toAbsGlob('a/*.js');
//=> '/dev/foo/a/*.js'
```

## Examples

Given the current project folder (cwd) is `/dev/foo/`:

**makes a path absolute**

```js
toAbsGlob('a');
//=> '/dev/foo/a'
```

**makes a glob absolute**

```js
toAbsGlob('a/*.js');
//=> '/dev/foo/a/*.js'
```

**retains trailing slashes**

```js
toAbsGlob('a/*/');
//=> '/dev/foo/a/*/'
```

**retains trailing slashes with cwd**

```js
toAbsGlob('./fixtures/whatsgoingon/*/', {cwd: __dirname});
//=> '/dev/foo/'
```

**makes a negative glob absolute**

```js
toAbsGlob('!a/*.js');
//=> '!/dev/foo/a/*.js'
```

**from a cwd**

```js
toAbsGlob('a/*.js', {cwd: 'foo'});
//=> '/dev/foo/foo/a/*.js'
```

**makes a negative glob absolute from a cwd**

```js
toAbsGlob('!a/*.js', {cwd: 'foo'});
//=> '!/dev/foo/foo/a/*.js'
```

**from a root path**

```js
toAbsGlob('/a/*.js', {root: 'baz'});
//=> '/dev/foo/baz/a/*.js'
```

**from a root slash**

```js
toAbsGlob('/a/*.js', {root: '/'});
//=> '/dev/foo/a/*.js'
```

**from a negative root path**

```js
toAbsGlob('!/a/*.js', {root: 'baz'});
//=> '!/dev/foo/baz/a/*.js'
```

**from a negative root slash**

```js
toAbsGlob('!/a/*.js', {root: '/'});
//=> '!/dev/foo/a/*.js'
```
