/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToTurbomoleInput
extends AbstractBasisSetXmlToText {
    protected String mTitle = "";

    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        this.enableSplitSP();
        return this.readBasisSet(data, elementList, optimize);
    }

    @Override
    protected void addHeader(StringBuffer output, Element root) throws FormatException {
        this.mTitle = root.getChildText("title", BSEProperties.mDcNs);
        output.append("$basis\n");
    }

    @Override
    protected void addFooter(StringBuffer output) throws FormatException {
        output.append("*\n$end\n");
    }

    @Override
    protected void addElementDescription(StringBuffer output, String element, Element contractions) {
        output.append("*\n");
        output.append(element.toLowerCase() + "   " + this.mTitle + "\n");
        output.append("*\n");
    }

    @Override
    protected void readCmlMatrix(StringBuffer output, Vector matrices, String element, String shell) throws FormatException {
        for (int k = 0; k < matrices.size(); ++k) {
            Matrix matrix = (Matrix)matrices.get(k);
            int rows = matrix.getNumRows();
            int columns = matrix.getNumColumns();
            Matrix[] matricesList = this.splitMatrixNcolumnTo2column(matrix);
            try {
                for (int m = 0; m < matricesList.length; ++m) {
                    int rows2 = matricesList[m].getNumRows();
                    int columns2 = matricesList[m].getNumColumns();
                    output.append("    " + rows2 + "  " + shell.toLowerCase() + "\n");
                    for (int i = 0; i < rows2; ++i) {
                        for (int j = 0; j < columns2; ++j) {
                            String value = this.formattedValue(matricesList[m].getValue(i, j));
                            output.append(value);
                        }
                        output.append("\n");
                    }
                }
                continue;
            }
            catch (IndexOutOfBoundsException ie) {
                throw new FormatException(ie.getMessage());
            }
        }
    }
}

