/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.statemanager.SessionStateBindingListener;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.CalendarEdit;
import org.chefproject.core.ContentCollection;
import org.chefproject.core.ContentCollectionEdit;
import org.chefproject.core.Edit;
import org.chefproject.core.Event;
import org.chefproject.core.MessageChannel;
import org.chefproject.core.MessageChannelEdit;
import org.chefproject.core.Notification;
import org.chefproject.core.NotificationEdit;
import org.chefproject.core.Realm;
import org.chefproject.core.RealmEdit;
import org.chefproject.core.Resource;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.core.RoleEdit;
import org.chefproject.core.Site;
import org.chefproject.core.SiteEdit;
import org.chefproject.core.SitePage;
import org.chefproject.core.SitePageEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.core.ToolConfiguration;
import org.chefproject.core.ToolConfigurationEdit;
import org.chefproject.core.ToolRegistration;
import org.chefproject.core.User;
import org.chefproject.core.component.BaseResourcePropertiesEdit;
import org.chefproject.core.component.EmailSiteEmailNotification;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.InconsistentException;
import org.chefproject.exception.PermissionException;
import org.chefproject.exception.TypeException;
import org.chefproject.service.CalendarService;
import org.chefproject.service.ContentHostingService;
import org.chefproject.service.EventTrackingService;
import org.chefproject.service.IdService;
import org.chefproject.service.MailArchiveService;
import org.chefproject.service.NotificationService;
import org.chefproject.service.RealmService;
import org.chefproject.service.SecurityService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.generic.GenericAnnouncementService;
import org.chefproject.service.generic.GenericChatService;
import org.chefproject.service.generic.GenericDiscussionService;
import org.chefproject.service.generic.GenericMessageService;
import org.chefproject.service.generic.GenericSiteService;
import org.chefproject.util.Cache;
import org.chefproject.util.CacheRefresher;
import org.chefproject.util.DefaultId;
import org.chefproject.util.Dropbox;
import org.chefproject.util.ResourceVector;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Time;
import org.chefproject.util.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseSiteService
extends TurbineBaseService
implements GenericSiteService,
StorageUser,
CacheRefresher {
    protected Storage m_storage = null;
    protected Cache m_cache = null;
    protected String m_accessPoint = null;
    protected String m_relativeAccessPoint = null;

    protected abstract Storage newStorage();

    protected String getAccessPoint(boolean relative) {
        return relative ? this.m_relativeAccessPoint : this.m_accessPoint;
    }

    protected String siteId(String ref) {
        String start = this.getAccessPoint(true) + "/";
        int i = ref.indexOf(start);
        if (i == -1) {
            return ref;
        }
        String id = ref.substring(i + start.length());
        return id;
    }

    protected boolean unlockCheck(String lock, String resource) {
        return SecurityService.unlock(lock, resource);
    }

    protected void unlock(String lock, String resource) throws PermissionException {
        if (!this.unlockCheck(lock, resource)) {
            throw new PermissionException(UsageSessionService.getSessionUser().getId(), lock, resource);
        }
    }

    protected void addLiveUpdateProperties(ResourcePropertiesEdit props) {
        props.addProperty("CHEF:modifiedby", UsageSessionService.getSessionUser().getId());
        props.addProperty("DAV:getlastmodified", new Time().toString());
    }

    protected void addLiveProperties(ResourcePropertiesEdit props) {
        String current = UsageSessionService.getSessionUser().getId();
        props.addProperty("CHEF:creator", current);
        props.addProperty("CHEF:modifiedby", current);
        String now = new Time().toString();
        props.addProperty("DAV:creationdate", now);
        props.addProperty("DAV:getlastmodified", now);
    }

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.info("chef", this + ".init(ServletConfig)");
    }

    public void init(RunData data) throws InitializationException {
        this.m_relativeAccessPoint = "/site";
        this.m_accessPoint = ServerConfigurationService.getAccessUrl() + this.m_relativeAccessPoint;
        super.init(data);
        Log.info("chef", this + ".init(RunData): access point: " + this.m_accessPoint);
    }

    public void init() throws InitializationException {
        super.init();
        Log.info("chef", this + ".init()");
        this.m_storage = this.newStorage();
        this.m_storage.open();
        this.m_cache = new Cache((CacheRefresher)this, this.siteReference(""));
    }

    public void shutdown() {
        this.m_cache.clear();
        this.m_cache = null;
        this.m_storage.close();
        this.m_storage = null;
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    public boolean allowAccessSite(String id) {
        boolean rv = false;
        try {
            Site site = this.getSite(id);
            switch (site.getStatus()) {
                case 2: {
                    rv = this.unlockCheck("site.visit", site.getReference());
                    break;
                }
                case 1: {
                    rv = this.unlockCheck("site.visit.unp", site.getReference());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rv;
    }

    public Site getSite(String id) throws IdUnusedException {
        Site site = null;
        String key = this.siteReference(id);
        if (this.m_cache.containsKey(key)) {
            site = (Site)this.m_cache.get(key);
        } else {
            site = this.m_storage.get(id);
            this.m_cache.put(key, site);
        }
        if (site == null) {
            throw new IdUnusedException(id);
        }
        return site;
    }

    public boolean allowUpdateSite(String id) {
        return this.unlockCheck("site.upd", this.siteReference(id));
    }

    public SiteEdit editSite(String id) throws IdUnusedException, PermissionException, InUseException {
        String ref = this.siteReference(id);
        this.unlock("site.upd", ref);
        if (this.m_cache.get(ref) == null && !this.m_storage.check(id)) {
            throw new IdUnusedException(id);
        }
        SiteEdit site = this.m_storage.edit(id);
        if (site == null) {
            throw new InUseException(id);
        }
        ((BaseSiteEdit)site).setEvent("site.upd");
        return site;
    }

    public void commitEdit(SiteEdit site) {
        if (!site.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitEdit(): closed SiteEdit", (Throwable)e);
                return;
            }
        }
        this.addLiveUpdateProperties(site.getPropertiesEdit());
        this.enableRelated(site);
        this.m_storage.commit(site);
        EventTrackingService.post(EventTrackingService.newEvent(((BaseSiteEdit)site).getEvent(), site.getReference(), true));
        ((BaseSiteEdit)site).closeEdit();
    }

    public void cancelEdit(SiteEdit site) {
        if (!site.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelEdit(): closed SiteEdit", (Throwable)e);
                return;
            }
        }
        this.m_storage.cancel(site);
        ((BaseSiteEdit)site).closeEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSites() {
        List sites = new Vector();
        if (this.m_cache.disabled()) {
            sites = this.m_storage.getAll();
        } else if (this.m_cache.isComplete()) {
            sites = this.m_cache.getAll();
        } else {
            Cache cache = this.m_cache;
            synchronized (cache) {
                block9: {
                    if (!this.m_cache.isComplete()) break block9;
                    sites = this.m_cache.getAll();
                    List list = sites;
                    return list;
                }
                this.m_cache.holdEvents();
                sites = this.m_storage.getAll();
                int i = 0;
                while (i < sites.size()) {
                    Site site = (Site)sites.get(i);
                    this.m_cache.put(site.getReference(), site);
                    ++i;
                }
                this.m_cache.setComplete();
                this.m_cache.processEvents();
            }
        }
        return sites;
    }

    public boolean allowAddSite(String id) {
        return this.unlockCheck("site.add", this.siteReference(id));
    }

    public SiteEdit addSite(String id) throws IdInvalidException, IdUsedException, PermissionException {
        Validator.checkResourceId(id);
        this.unlock("site.add", this.siteReference(id));
        SiteEdit site = this.m_storage.put(id);
        if (site == null) {
            throw new IdUsedException(id);
        }
        ((BaseSiteEdit)site).setEvent("site.add");
        return site;
    }

    public SiteEdit addSite(String id, Site other) throws IdInvalidException, IdUsedException, PermissionException {
        Validator.checkResourceId(id);
        this.unlock("site.add", this.siteReference(id));
        SiteEdit site = this.m_storage.put(id);
        if (site == null) {
            throw new IdUsedException(id);
        }
        ((BaseSiteEdit)site).setEvent("site.add");
        ((BaseSite)((Object)site)).set((BaseSite)other);
        site.getPropertiesEdit().removeProperty("CHEF:site-email-notification-id");
        this.addLiveProperties(site.getPropertiesEdit());
        return site;
    }

    public boolean allowRemoveSite(String id) {
        return this.unlockCheck("site.del", this.siteReference(id));
    }

    public void removeSite(SiteEdit site) throws PermissionException {
        if (!site.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".removeSite(): closed SiteEdit", (Throwable)e);
                return;
            }
        }
        this.unlock("site.del", site.getReference());
        this.m_storage.remove(site);
        EventTrackingService.post(EventTrackingService.newEvent("site.del", site.getReference(), true));
        this.disableRelated(site);
        ((BaseSiteEdit)site).closeEdit();
    }

    public String siteReference(String id) {
        return this.getAccessPoint(true) + "/" + id;
    }

    public String sitePageReference(String siteId, String pageId) {
        return this.getAccessPoint(true) + "/" + siteId + "/" + "page" + "/" + pageId;
    }

    public String siteToolReference(String siteId, String toolId) {
        return this.getAccessPoint(true) + "/" + siteId + "/" + "tool" + "/" + toolId;
    }

    public boolean isUserSite(String site) {
        if (site.startsWith(this.siteReference("~"))) {
            return true;
        }
        return site.startsWith("~");
    }

    public String getSiteUserId(String site) {
        String ref = this.siteReference("~");
        if (site.startsWith(ref)) {
            return site.substring(ref.length());
        }
        if (site.startsWith("~")) {
            return site.substring(1);
        }
        return null;
    }

    public String getUserSiteId(String userId) {
        return "~" + userId;
    }

    public boolean isSpecialSite(String site) {
        if (site.startsWith(this.siteReference("!"))) {
            return true;
        }
        return site.startsWith("!");
    }

    public String getSiteSpecialId(String site) {
        String ref = this.siteReference("!");
        if (site.startsWith(ref)) {
            return site.substring(ref.length());
        }
        if (site.startsWith("!")) {
            return site.substring(1);
        }
        return null;
    }

    public String getSpecialSiteId(String special) {
        return "!" + special;
    }

    public String getSiteDisplay(String id) {
        String rv = "(" + id + ")";
        try {
            Site site = this.getSite(id);
            rv = "\"" + site.getTitle() + "\" " + rv;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rv;
    }

    protected void enableRelated(SiteEdit site) {
        boolean hasChat = false;
        boolean hasMailbox = false;
        boolean hasResources = false;
        boolean hasDropbox = false;
        boolean hasSchedule = false;
        boolean hasAnnouncements = false;
        boolean hasDiscussion = false;
        boolean hasAssignment = false;
        boolean hasDissertation = false;
        Iterator iPages = site.getPages().iterator();
        while (iPages.hasNext()) {
            SitePage page = (SitePage)iPages.next();
            Iterator iTools = page.getTools().iterator();
            while (iTools.hasNext()) {
                ToolConfiguration tool = (ToolConfiguration)iTools.next();
                if ("chef.chat".equals(tool.getToolId())) {
                    hasChat = true;
                    continue;
                }
                if ("chef.mailbox".equals(tool.getToolId())) {
                    hasMailbox = true;
                    continue;
                }
                if ("chef.resources".equals(tool.getToolId())) {
                    hasResources = true;
                    continue;
                }
                if ("chef.dropbox".equals(tool.getToolId())) {
                    hasDropbox = true;
                    continue;
                }
                if ("chef.schedule".equals(tool.getToolId())) {
                    hasSchedule = true;
                    continue;
                }
                if ("chef.announcements".equals(tool.getToolId())) {
                    hasAnnouncements = true;
                    continue;
                }
                if ("chef.discussion".equals(tool.getToolId())) {
                    hasDiscussion = true;
                    continue;
                }
                if ("chef.assignment".equals(tool.getToolId())) {
                    hasAssignment = true;
                    continue;
                }
                if ("chef.threadeddiscussion".equals(tool.getToolId())) {
                    hasDiscussion = true;
                    continue;
                }
                if (!"chef.dissertation".equals(tool.getToolId())) continue;
                hasDissertation = true;
            }
        }
        this.enableRealm(site);
        if (hasMailbox) {
            this.enableMailbox(site);
        } else {
            this.disableMailbox(site);
        }
        if (hasChat) {
            this.enableMessageChannel(site, GenericChatService.SERVICE_NAME);
        }
        if (hasAnnouncements) {
            this.enableMessageChannel(site, GenericAnnouncementService.SERVICE_NAME);
        }
        if (hasDiscussion) {
            this.enableMessageChannel(site, GenericDiscussionService.SERVICE_NAME);
        }
        if (hasSchedule) {
            this.enableSchedule(site);
        }
        if (hasResources) {
            this.enableResources(site);
        }
        if (hasDropbox) {
            this.enableDropbox(site);
        }
    }

    protected void disableRelated(SiteEdit site) {
        this.disableRealm(site);
        this.disableMailbox(site);
    }

    protected void enableRealm(Site site) {
        Realm realm;
        try {
            realm = RealmService.getRealm(site.getReference());
        }
        catch (IdUnusedException un) {
            Realm template = null;
            try {
                template = RealmService.getRealm("@");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                RealmEdit myRealm = null;
                myRealm = template == null ? RealmService.addRealm(site.getReference()) : RealmService.addRealm(site.getReference(), template);
                RealmService.commitEdit(myRealm);
            }
            catch (Exception e) {
                Log.warn("chef", this + ".enableRealm: Realm exception: " + e);
            }
        }
        if (!(!"site.add".equals(((BaseSiteEdit)site).getEvent()) || this.unlockCheck("site.upd", site.getReference()) && this.unlockCheck("site.visit", site.getReference()) && this.unlockCheck("site.visit.unp", site.getReference()))) {
            try {
                realm = RealmService.editRealm(site.getReference());
                User current = UsageSessionService.getSessionUser();
                RoleEdit role = realm.getRoleEdit("maintain");
                if (role == null) {
                    try {
                        role = realm.addRole("maintain");
                        role.addLock("site.upd");
                        role.addLock("site.visit");
                        role.addLock("site.visit.unp");
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                if (role != null) {
                    realm.addUserRole(current, role);
                }
                RealmService.commitEdit((RealmEdit)realm);
            }
            catch (IdUnusedException e) {
            }
            catch (PermissionException e) {
            }
            catch (InUseException e) {
                // empty catch block
            }
        }
    }

    protected void disableRealm(Site site) {
        try {
            RealmEdit realm = RealmService.editRealm(site.getReference());
            RealmService.removeRealm(realm);
        }
        catch (Exception e) {
            Log.warn("chef", this + ".removeSite: Realm exception: " + e);
        }
    }

    protected void enableMailbox(SiteEdit site) {
        MessageChannelEdit edit;
        String channelRef = MailArchiveService.channelReference(site.getId(), "main");
        MessageChannel channel = null;
        try {
            channel = MailArchiveService.getChannel(channelRef);
        }
        catch (IdUnusedException e) {
        }
        catch (PermissionException e) {
            // empty catch block
        }
        if (channel != null) {
            if (channel.getProperties().getProperty("CHEF:channel-enabled") == null) {
                try {
                    edit = MailArchiveService.editChannel(channelRef);
                    edit.getPropertiesEdit().addProperty("CHEF:channel-enabled", "true");
                    MailArchiveService.commitChannel(edit);
                    channel = edit;
                }
                catch (IdUnusedException ignore) {
                }
                catch (PermissionException ignore) {
                }
                catch (InUseException ignore) {}
            }
        } else {
            try {
                edit = MailArchiveService.addMailArchiveChannel(channelRef);
                edit.getPropertiesEdit().addProperty("CHEF:channel-enabled", "true");
                MailArchiveService.commitChannel(edit);
                channel = edit;
            }
            catch (IdUsedException e) {
            }
            catch (IdInvalidException e) {
            }
            catch (PermissionException e) {
                // empty catch block
            }
        }
        if (NotificationService.getInstance() == null) {
            return;
        }
        String notificationId = site.getProperties().getProperty("CHEF:site-email-notification-id");
        Notification notification = null;
        if (notificationId != null) {
            try {
                notification = NotificationService.getNotification(notificationId);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (notification == null) {
            NotificationEdit edit2 = NotificationService.addNotification();
            edit2.setFunction("mail.new");
            edit2.setResourceFilter(MailArchiveService.messageReference(site.getId(), "main", ""));
            edit2.setAction(new EmailSiteEmailNotification(site.getId()));
            NotificationService.commitEdit(edit2);
            notification = edit2;
            site.getPropertiesEdit().addProperty("CHEF:site-email-notification-id", notification.getId());
        }
    }

    protected void disableMailbox(SiteEdit site) {
        String channelRef = MailArchiveService.channelReference(site.getId(), "main");
        MessageChannel channel = null;
        try {
            channel = MailArchiveService.getChannel(channelRef);
        }
        catch (IdUnusedException e) {
        }
        catch (PermissionException e) {
            // empty catch block
        }
        if (channel != null && channel.getProperties().getProperty("CHEF:channel-enabled") != null) {
            try {
                MessageChannelEdit edit = MailArchiveService.editChannel(channelRef);
                edit.getPropertiesEdit().removeProperty("CHEF:channel-enabled");
                MailArchiveService.commitChannel(edit);
                channel = edit;
            }
            catch (IdUnusedException ignore) {
            }
            catch (PermissionException ignore) {
            }
            catch (InUseException ignore) {
                // empty catch block
            }
        }
        if (NotificationService.getInstance() == null) {
            return;
        }
        String notificationId = site.getProperties().getProperty("CHEF:site-email-notification-id");
        if (notificationId != null) {
            try {
                NotificationEdit edit = NotificationService.editNotification(notificationId);
                NotificationService.removeNotification(edit);
            }
            catch (IdUnusedException e) {
            }
            catch (InUseException e) {
                // empty catch block
            }
        }
        site.getPropertiesEdit().removeProperty("CHEF:site-email-notification-id");
    }

    protected void enableMessageChannel(SiteEdit site, String serviceId) {
        GenericMessageService service = (GenericMessageService)((Object)TurbineServices.getInstance().getService(serviceId));
        String channelRef = service.channelReference(site.getId(), "main");
        try {
            service.getChannel(channelRef);
        }
        catch (IdUnusedException un) {
            try {
                MessageChannelEdit edit = service.addChannel(channelRef);
                service.commitChannel(edit);
            }
            catch (IdUsedException e) {
            }
            catch (IdInvalidException e) {
            }
            catch (PermissionException e) {}
        }
        catch (PermissionException e) {
            // empty catch block
        }
    }

    protected void enableSchedule(SiteEdit site) {
        String calRef = CalendarService.calendarReference(site.getId(), "main");
        try {
            CalendarService.getCalendar(calRef);
        }
        catch (IdUnusedException un) {
            try {
                CalendarEdit edit = CalendarService.addCalendar(calRef);
                CalendarService.commitCalendar(edit);
            }
            catch (IdUsedException e) {
            }
            catch (IdInvalidException e) {
            }
            catch (PermissionException e) {}
        }
        catch (PermissionException e) {
            // empty catch block
        }
    }

    protected void enableResources(SiteEdit site) {
        String id = DefaultId.getCollection(site.getId());
        try {
            ContentCollection collection = ContentHostingService.getCollection(id);
            if (!site.getTitle().equals(collection.getProperties().getProperty("DAV:displayname"))) {
                try {
                    ContentCollectionEdit edit = ContentHostingService.editCollection(id);
                    edit.getPropertiesEdit().addProperty("DAV:displayname", site.getTitle());
                    ContentHostingService.commitCollection(edit);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", this + ".enableResources: " + e);
                }
                catch (PermissionException e) {
                    Log.warn("chef", this + ".enableResources: " + e);
                }
                catch (InUseException e) {
                    Log.warn("chef", this + ".enableResources: " + e);
                }
            }
        }
        catch (IdUnusedException un) {
            try {
                ContentCollectionEdit collection = ContentHostingService.addCollection(id);
                collection.getPropertiesEdit().addProperty("DAV:displayname", site.getTitle());
                ContentHostingService.commitCollection(collection);
            }
            catch (IdUsedException e) {
                Log.warn("chef", this + ".enableResources: " + e);
            }
            catch (IdInvalidException e) {
                Log.warn("chef", this + ".enableResources: " + e);
            }
            catch (PermissionException e) {
                Log.warn("chef", this + ".enableResources: " + e);
            }
            catch (InconsistentException e) {
                Log.warn("chef", this + ".enableResources: " + e);
            }
        }
        catch (TypeException e) {
            Log.warn("chef", this + ".enableResources: " + e);
        }
        catch (PermissionException e) {
            Log.warn("chef", this + ".enableResources: " + e);
        }
    }

    protected void enableDropbox(SiteEdit site) {
        Dropbox.createCollection(site.getId());
    }

    public Resource newContainer(String ref) {
        return null;
    }

    public Resource newContainer(Element element) {
        return null;
    }

    public Resource newContainer(Resource other) {
        return null;
    }

    public Resource newResource(Resource container, String id, Object[] others) {
        return new BaseSite(id);
    }

    public Resource newResource(Resource container, Element element) {
        return new BaseSite(element);
    }

    public Resource newResource(Resource container, Resource other) {
        return new BaseSite((Site)other);
    }

    public Edit newContainerEdit(String ref) {
        return null;
    }

    public Edit newContainerEdit(Element element) {
        return null;
    }

    public Edit newContainerEdit(Resource other) {
        return null;
    }

    public Edit newResourceEdit(Resource container, String id, Object[] others) {
        BaseSiteEdit e = new BaseSiteEdit(id);
        e.activate();
        return e;
    }

    public Edit newResourceEdit(Resource container, Element element) {
        BaseSiteEdit e = new BaseSiteEdit(element);
        e.activate();
        return e;
    }

    public Edit newResourceEdit(Resource container, Resource other) {
        BaseSiteEdit e = new BaseSiteEdit((Site)other);
        e.activate();
        return e;
    }

    public Object[] storageFields(Resource r) {
        return null;
    }

    public Object refresh(Object key, Object oldValue, Event event) {
        String id = this.siteId((String)key);
        Site site = this.m_storage.get(id);
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".refresh(): " + key);
        }
        return site;
    }

    protected static interface Storage {
        public void open();

        public void close();

        public boolean check(String var1);

        public Site get(String var1);

        public List getAll();

        public SiteEdit put(String var1);

        public SiteEdit edit(String var1);

        public void commit(SiteEdit var1);

        public void cancel(SiteEdit var1);

        public void remove(SiteEdit var1);
    }

    protected class BaseToolConfigurationEdit
    implements ToolConfigurationEdit {
        protected String m_toolId = null;
        protected String m_title = null;
        protected String m_layoutHints = null;
        protected String m_id = null;
        protected ResourcePropertiesEdit m_properties = null;
        protected boolean m_active = false;
        protected BaseSitePageEdit m_page = null;

        protected BaseToolConfigurationEdit(SitePage page) {
            this.m_page = (BaseSitePageEdit)page;
            this.m_id = IdService.getUniqueId();
            this.m_properties = new BaseResourcePropertiesEdit();
        }

        protected BaseToolConfigurationEdit(ToolConfiguration other, SitePage page) {
            this.m_page = (BaseSitePageEdit)page;
            this.m_id = other.getId();
            this.m_toolId = other.getToolId();
            this.m_title = other.getTitle();
            this.m_layoutHints = other.getLayoutHints();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(other.getProperties());
        }

        protected BaseToolConfigurationEdit(ToolRegistration reg, SitePage page) {
            this.m_page = (BaseSitePageEdit)page;
            this.m_id = IdService.getUniqueId();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_toolId = reg.getId();
            this.m_title = reg.getTitle();
            this.m_properties.addAll(reg.getDefaultConfiguration());
        }

        protected BaseToolConfigurationEdit(Element el, SitePage page) {
            this.m_page = (BaseSitePageEdit)page;
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_id = el.getAttribute("id");
            this.m_toolId = StringUtil.trimToNull(el.getAttribute("toolId"));
            this.m_title = StringUtil.trimToNull(el.getAttribute("title"));
            this.m_layoutHints = StringUtil.trimToNull(el.getAttribute("layoutHints"));
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("properties")) {
                    this.m_properties = new BaseResourcePropertiesEdit(element);
                }
                ++i;
            }
        }

        public String getToolId() {
            return this.m_toolId;
        }

        public String getTitle() {
            return this.m_title;
        }

        public String getLayoutHints() {
            return this.m_layoutHints;
        }

        public void setToolId(String toolId) {
            this.m_toolId = StringUtil.trimToNull(toolId);
        }

        public void setTitle(String title) {
            this.m_title = StringUtil.trimToNull(title);
        }

        public void setLayoutHints(String hints) {
            this.m_layoutHints = hints;
        }

        public void moveUp() {
            this.m_page.m_tools.moveUp(this);
        }

        public void moveDown() {
            this.m_page.m_tools.moveDown(this);
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public String getUrl() {
            return ServerConfigurationService.getAccessUrl() + BaseSiteService.this.siteToolReference(this.m_page.getContainingSite().getId(), this.m_id);
        }

        public String getReference() {
            return BaseSiteService.this.siteToolReference(this.m_page.getContainingSite().getId(), this.m_id);
        }

        public String getId() {
            return this.m_id;
        }

        public SitePage getContainingPage() {
            return this.m_page;
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public Element toXml(Document doc, Stack stack) {
            Element element = doc.createElement("tool");
            ((Element)stack.peek()).appendChild(element);
            stack.push(element);
            element.setAttribute("id", this.getId());
            if (this.m_toolId != null) {
                element.setAttribute("toolId", this.m_toolId);
            }
            if (this.m_title != null) {
                element.setAttribute("title", this.m_title);
            }
            if (this.m_layoutHints != null) {
                element.setAttribute("layoutHints", this.m_layoutHints);
            }
            this.m_properties.toXml(doc, stack);
            stack.pop();
            return element;
        }
    }

    protected class BaseSitePageEdit
    implements SitePageEdit {
        protected String m_title = null;
        protected int m_layout = 0;
        protected String m_id = null;
        protected ResourcePropertiesEdit m_properties = null;
        protected ResourceVector m_tools = null;
        protected boolean m_active = false;
        protected BaseSite m_site = null;

        protected BaseSitePageEdit(Site site) {
            this.m_site = (BaseSite)site;
            this.m_id = IdService.getUniqueId();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_tools = new ResourceVector();
        }

        protected BaseSitePageEdit(SitePageEdit other, Site site) {
            BaseSitePageEdit bOther = (BaseSitePageEdit)other;
            this.m_site = (BaseSite)site;
            this.m_id = bOther.m_id;
            this.m_title = bOther.m_title;
            this.m_layout = bOther.m_layout;
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(bOther.m_properties);
            this.m_tools = new ResourceVector();
            Iterator iTools = bOther.m_tools.iterator();
            while (iTools.hasNext()) {
                BaseToolConfigurationEdit tool = (BaseToolConfigurationEdit)iTools.next();
                this.m_tools.add(new BaseToolConfigurationEdit(tool, (SitePage)this));
            }
        }

        protected BaseSitePageEdit(Element el, Site site) {
            this.m_site = (BaseSite)site;
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_tools = new ResourceVector();
            this.m_id = el.getAttribute("id");
            this.m_title = StringUtil.trimToNull(el.getAttribute("title"));
            try {
                this.m_layout = Integer.parseInt(StringUtil.trimToNull(el.getAttribute("layout")));
            }
            catch (Exception e) {
                // empty catch block
            }
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element element = (Element)child;
                    if (element.getTagName().equals("properties")) {
                        this.m_properties = new BaseResourcePropertiesEdit(element);
                    } else if (element.getTagName().equals("tools")) {
                        NodeList toolsNodes = element.getChildNodes();
                        int t = 0;
                        while (t < toolsNodes.getLength()) {
                            Element toolEl;
                            Node toolNode = toolsNodes.item(t);
                            if (toolNode.getNodeType() == 1 && (toolEl = (Element)toolNode).getTagName().equals("tool")) {
                                BaseToolConfigurationEdit tool = new BaseToolConfigurationEdit(toolEl, (SitePage)this);
                                this.m_tools.add(tool);
                            }
                            ++t;
                        }
                    }
                }
                ++i;
            }
        }

        public String getTitle() {
            return this.m_title;
        }

        public int getLayout() {
            return this.m_layout;
        }

        public String getLayoutTitle() {
            return SitePage.LAYOUT_NAMES[this.m_layout];
        }

        public List getTools() {
            return new Vector(this.m_tools);
        }

        public ToolConfiguration getTool(String id) {
            return (ToolConfiguration)this.m_tools.getById(id);
        }

        public void setTitle(String title) {
            this.m_title = StringUtil.trimToNull(title);
        }

        public void setLayout(int layout) {
            if (layout == 0 || layout == 1) {
                this.m_layout = layout;
            } else {
                Log.warn("chef", this + ".setLayout(): set to invalid value: " + layout);
            }
        }

        public ToolConfigurationEdit addTool() {
            BaseToolConfigurationEdit tool = new BaseToolConfigurationEdit(this);
            this.m_tools.add(tool);
            return tool;
        }

        public ToolConfigurationEdit addTool(ToolRegistration reg) {
            BaseToolConfigurationEdit tool = new BaseToolConfigurationEdit(reg, (SitePage)this);
            this.m_tools.add(tool);
            return tool;
        }

        public List getToolEdits() {
            return new Vector(this.m_tools);
        }

        public ToolConfigurationEdit getToolEdit(String id) {
            return (ToolConfigurationEdit)this.m_tools.getById(id);
        }

        public void removeTool(ToolConfigurationEdit tool) {
            this.m_tools.remove(tool);
        }

        public void moveUp() {
            this.m_site.m_pages.moveUp(this);
        }

        public void moveDown() {
            this.m_site.m_pages.moveDown(this);
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public String getUrl() {
            return ServerConfigurationService.getAccessUrl() + BaseSiteService.this.sitePageReference(this.m_site.getId(), this.m_id);
        }

        public String getReference() {
            return BaseSiteService.this.sitePageReference(this.m_site.getId(), this.m_id);
        }

        public String getId() {
            return this.m_id;
        }

        public Site getContainingSite() {
            return this.m_site;
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public Element toXml(Document doc, Stack stack) {
            Element page = doc.createElement("page");
            ((Element)stack.peek()).appendChild(page);
            page.setAttribute("id", this.getId());
            if (this.m_title != null) {
                page.setAttribute("title", this.m_title);
            }
            page.setAttribute("layout", Integer.toString(this.m_layout));
            stack.push(page);
            this.m_properties.toXml(doc, stack);
            stack.pop();
            Element list = doc.createElement("tools");
            page.appendChild(list);
            stack.push(list);
            Iterator iTools = this.m_tools.iterator();
            while (iTools.hasNext()) {
                BaseToolConfigurationEdit tool = (BaseToolConfigurationEdit)iTools.next();
                tool.toXml(doc, stack);
            }
            stack.pop();
            return page;
        }
    }

    public class BaseSiteEdit
    extends BaseSite
    implements SiteEdit,
    SessionStateBindingListener {
        protected String m_event = null;
        protected boolean m_active = false;

        public BaseSiteEdit(String id) {
            super(id);
        }

        public BaseSiteEdit(Element el) {
            super(el);
        }

        public BaseSiteEdit(Site otherSite) {
            super(otherSite);
        }

        protected void finalize() {
            if (this.m_active) {
                BaseSiteService.this.cancelEdit(this);
            }
        }

        public void setTitle(String title) {
            this.m_title = StringUtil.trimToNull(title);
        }

        public void setDescription(String description) {
            this.m_description = StringUtil.trimToNull(description);
        }

        public void setJoinable(boolean joinable) {
            this.m_joinable = joinable;
        }

        public void setJoinerRole(String role) {
            this.m_joinerRole = role;
        }

        public void setStatus(int status) {
            if (status >= 1 && status <= 2) {
                this.m_status = status;
            } else {
                Log.warn("chef", this + ".setStatus(): setting to invalid value: " + status);
            }
        }

        public void setSkin(String skin) {
            this.m_skin = skin;
        }

        public void setIconUrl(String url) {
            this.m_icon = StringUtil.trimToNull(url);
        }

        public void setInfoUrl(String url) {
            this.m_info = StringUtil.trimToNull(url);
        }

        public SitePageEdit addPage() {
            BaseSitePageEdit page = new BaseSitePageEdit(this);
            this.m_pages.add(page);
            return page;
        }

        public List getPageEdits() {
            return new Vector(this.m_pages);
        }

        public SitePageEdit getPageEdit(String id) {
            return (SitePageEdit)this.m_pages.getById(id);
        }

        public void removePage(SitePageEdit page) {
            this.m_pages.remove(page);
        }

        public ToolConfigurationEdit getToolEdit(String id) {
            return (ToolConfigurationEdit)this.getTool(id);
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseSiteService.this.cancelEdit(this);
            }
        }
    }

    public class BaseSite
    implements Site {
        protected String m_id = null;
        protected String m_title = null;
        protected String m_description = null;
        protected boolean m_joinable = false;
        protected String m_joinerRole = null;
        protected int m_status = 1;
        protected String m_icon = null;
        protected String m_info = null;
        protected ResourcePropertiesEdit m_properties = null;
        protected ResourceVector m_pages = null;
        protected String m_skin = null;

        public BaseSite(String id) {
            this.m_id = id;
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_pages = new ResourceVector();
            if (this.m_id != null) {
                BaseSiteService.this.addLiveProperties(this.m_properties);
            }
        }

        public BaseSite(Site other) {
            BaseSite bOther = (BaseSite)other;
            this.m_id = bOther.m_id;
            this.set(bOther);
        }

        public BaseSite(Element el) {
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_pages = new ResourceVector();
            this.m_id = el.getAttribute("id");
            this.m_title = StringUtil.trimToNull(el.getAttribute("title"));
            this.m_description = StringUtil.trimToNull(el.getAttribute("description"));
            this.m_joinable = new Boolean(el.getAttribute("joinable"));
            this.m_joinerRole = StringUtil.trimToNull(el.getAttribute("joiner-role"));
            this.m_status = new Integer(el.getAttribute("status"));
            this.m_icon = StringUtil.trimToNull(el.getAttribute("icon"));
            this.m_info = StringUtil.trimToNull(el.getAttribute("info"));
            this.m_skin = StringUtil.trimToNull(el.getAttribute("skin"));
            NodeList children = el.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element element = (Element)child;
                    if (element.getTagName().equals("properties")) {
                        this.m_properties = new BaseResourcePropertiesEdit(element);
                    } else if (element.getTagName().equals("pages")) {
                        NodeList pagesNodes = element.getChildNodes();
                        int p = 0;
                        while (p < pagesNodes.getLength()) {
                            Element pageEl;
                            Node pageNode = pagesNodes.item(p);
                            if (pageNode.getNodeType() == 1 && (pageEl = (Element)pageNode).getTagName().equals("page")) {
                                BaseSitePageEdit page = new BaseSitePageEdit(pageEl, (Site)this);
                                this.m_pages.add(page);
                            }
                            ++p;
                        }
                    }
                }
                ++i;
            }
        }

        protected void set(BaseSite other) {
            this.m_title = other.m_title;
            this.m_description = other.m_description;
            this.m_joinable = other.m_joinable;
            this.m_joinerRole = other.m_joinerRole;
            this.m_status = other.m_status;
            this.m_icon = other.m_icon;
            this.m_info = other.m_info;
            this.m_skin = other.m_skin;
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(other.m_properties);
            this.m_pages = new ResourceVector();
            Iterator iPages = other.m_pages.iterator();
            while (iPages.hasNext()) {
                BaseSitePageEdit page = (BaseSitePageEdit)iPages.next();
                this.m_pages.add(new BaseSitePageEdit(page, (Site)this));
            }
        }

        public Element toXml(Document doc, Stack stack) {
            Element site = doc.createElement("site");
            if (stack.isEmpty()) {
                doc.appendChild(site);
            } else {
                ((Element)stack.peek()).appendChild(site);
            }
            site.setAttribute("id", this.getId());
            if (this.m_title != null) {
                site.setAttribute("title", this.m_title);
            }
            if (this.m_description != null) {
                site.setAttribute("description", this.m_description);
            }
            site.setAttribute("joinable", new Boolean(this.m_joinable).toString());
            if (this.m_joinerRole != null) {
                site.setAttribute("joiner-role", this.m_joinerRole);
            }
            site.setAttribute("status", Integer.toString(this.m_status));
            if (this.m_icon != null) {
                site.setAttribute("icon", this.m_icon);
            }
            if (this.m_info != null) {
                site.setAttribute("info", this.m_info);
            }
            if (this.m_skin != null) {
                site.setAttribute("skin", this.m_skin);
            }
            stack.push(site);
            this.m_properties.toXml(doc, stack);
            stack.pop();
            Element list = doc.createElement("pages");
            site.appendChild(list);
            stack.push(list);
            Iterator iPages = this.m_pages.iterator();
            while (iPages.hasNext()) {
                BaseSitePageEdit page = (BaseSitePageEdit)iPages.next();
                page.toXml(doc, stack);
            }
            stack.pop();
            return site;
        }

        public String getId() {
            if (this.m_id == null) {
                return "";
            }
            return this.m_id;
        }

        public String getUrl() {
            return ServerConfigurationService.getAccessUrl() + BaseSiteService.this.siteReference(this.m_id);
        }

        public String getReference() {
            return BaseSiteService.this.siteReference(this.m_id);
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public String getTitle() {
            if (this.m_title != null) {
                return this.m_title;
            }
            return this.getId();
        }

        public String getDescription() {
            return this.m_description;
        }

        public boolean isJoinable() {
            return this.m_joinable;
        }

        public String getJoinerRole() {
            return this.m_joinerRole;
        }

        public int getStatus() {
            return this.m_status;
        }

        public String getSkin() {
            return this.m_skin;
        }

        public String getIconUrl() {
            return this.m_icon;
        }

        public String getInfoUrl() {
            return this.m_info;
        }

        public List getPages() {
            return new Vector(this.m_pages);
        }

        public SitePage getPage(String id) {
            return (SitePage)this.m_pages.getById(id);
        }

        public ToolConfiguration getTool(String id) {
            Iterator iPages = this.m_pages.iterator();
            while (iPages.hasNext()) {
                SitePage page = (SitePage)iPages.next();
                ToolConfiguration tool = page.getTool(id);
                if (tool == null) continue;
                return tool;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Site)) {
                return false;
            }
            return ((Site)obj).getId().equals(this.getId());
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof Site)) {
                throw new ClassCastException();
            }
            if (obj == this) {
                return 0;
            }
            int compare = this.getTitle().compareTo(((Site)obj).getTitle());
            if (compare == 0) {
                compare = this.getId().compareTo(((Site)obj).getId());
            }
            return compare;
        }
    }
}

