/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.bzip2;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.util.IOUtil;

public class BZip2UnArchiver
extends AbstractUnArchiver {
    public BZip2UnArchiver() {
    }

    public BZip2UnArchiver(File sourceFile) {
        super(sourceFile);
    }

    protected void execute() throws ArchiverException {
        if (this.getSourceFile().lastModified() > this.getDestFile().lastModified()) {
            this.getLogger().info("Expanding " + this.getSourceFile().getAbsolutePath() + " to " + this.getDestFile().getAbsolutePath());
            FileOutputStream out = null;
            BZip2CompressorInputStream zIn = null;
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            try {
                out = new FileOutputStream(this.getDestFile());
                fis = new FileInputStream(this.getSourceFile());
                bis = new BufferedInputStream(fis);
                zIn = BZip2UnArchiver.getBZip2InputStream(bis);
                if (zIn == null) {
                    throw new ArchiverException(this.getSourceFile().getAbsolutePath() + " is an invalid bz2 file.");
                }
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    out.write(buffer, 0, count);
                } while ((count = zIn.read(buffer, 0, buffer.length)) != -1);
            }
            catch (IOException ioe) {
                try {
                    String msg = "Problem expanding bzip2 " + ioe.getMessage();
                    throw new ArchiverException(msg, ioe);
                }
                catch (Throwable throwable) {
                    IOUtil.close(bis);
                    IOUtil.close(fis);
                    IOUtil.close((OutputStream)out);
                    IOUtil.close(zIn);
                    throw throwable;
                }
            }
            IOUtil.close((InputStream)bis);
            IOUtil.close((InputStream)fis);
            IOUtil.close((OutputStream)out);
            IOUtil.close((InputStream)zIn);
        }
    }

    public static BZip2CompressorInputStream getBZip2InputStream(InputStream bis) throws IOException {
        return new BZip2CompressorInputStream(bis);
    }

    protected void execute(String path, File outputDirectory) {
        throw new UnsupportedOperationException("Targeted extraction not supported in BZIP2 format.");
    }
}

