/*
 * Copyright 2022, 2024 Soren Stoutner <soren@stoutner.com>.
 *
 * This file is part of Privacy Browser PC <https://www.stoutner.com/privacy-browser-pc/>.
 *
 * Privacy Browser PC is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Privacy Browser PC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Privacy Browser PC.  If not, see <http://www.gnu.org/licenses/>.
 */

// Application headers.
#include "SearchEngineHelper.h"

// Construct the class.
SearchEngineHelper::SearchEngineHelper() {}

QString SearchEngineHelper::getSearchUrl(const QString &searchEngineName)
{
    if (searchEngineName == "Mojeek")  // Mojeek.
    {
        return "https://www.mojeek.com/search?q=";
    }
    else if (searchEngineName == "Monocles")  // Monocles.
    {
        return "https://monocles.de/search?q=";
    }
    else if (searchEngineName == "MetaGer")  // MetaGer.
    {
        return "https://metager.org/meta/meta.ger3?eingabe=";
    }
    else if (searchEngineName == "Google")  // Google.
    {
        return "https://www.google.com/search?q=";
    }
    else if (searchEngineName == "Bing")  // Bing.
    {
        return "https://www.bing.com/search?q=";
    }
    else if (searchEngineName == "Yahoo")  // Yahoo.
    {
        return "https://search.yahoo.com/search?p=";
    }
    else
    {
        // Return the custom user agent.
        return searchEngineName;
    }
}
