% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colDiffs.R, R/rowDiffs.R
\name{colDiffs,DelayedMatrix-method}
\alias{colDiffs,DelayedMatrix-method}
\alias{rowDiffs,DelayedMatrix-method}
\title{Calculates the difference between each element of a row (column) of a
matrix-like object}
\usage{
\S4method{colDiffs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  lag = 1L,
  differences = 1L,
  force_block_processing = FALSE,
  ...
)

\S4method{rowDiffs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  lag = 1L,
  differences = 1L,
  force_block_processing = FALSE,
  ...
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{lag}{An integer specifying the lag.}

\item{differences}{An integer specifying the order of difference.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{matrix}} with one column
(row) less than x: \eqn{Nx(K-1)} or \eqn{(N-1)xK}.
}
\description{
Calculates the difference between each element of a row (column) of a
matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowDiffs}
/ \code{matrixStats::colDiffs}.
}
\examples{
# A DelayedMatrix with a 'matrix' seed
dm_matrix <- DelayedArray(matrix(c(rep(1L, 5),
                                   as.integer((0:4) ^ 2),
                                   seq(-5L, -1L, 1L)),
                                 ncol = 3))
# A DelayedMatrix with a 'HDF5ArraySeed' seed
# NOTE: Requires that the HDF5Array package is installed
library(HDF5Array)
dm_HDF5 <- writeHDF5Array(matrix(c(rep(1L, 5),
                                   as.integer((0:4) ^ 2),
                                   seq(-5L, -1L, 1L)),
                                 ncol = 3))

colDiffs(dm_matrix)

rowDiffs(dm_HDF5)
# In reverse column order
rowDiffs(dm_HDF5, cols = seq(ncol(dm_HDF5), 1, -1))
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowDiffs}()} and
\code{matrixStats::\link[matrixStats:rowDiffs]{colDiffs}()} which are used
when the input is a \code{matrix} or \code{numeric} vector.
\item \code{base::\link{diff}()}.
}
}
\author{
Peter Hickey
}
