% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineBlocks.R
\name{combineBlocks}
\alias{combineBlocks}
\title{Combine blockwise statistics}
\usage{
combineBlocks(
  blocks,
  ave.fields,
  pval.field,
  method,
  geometric,
  equiweight,
  weights,
  valid
)
}
\arguments{
\item{blocks}{A list of \linkS4class{DataFrame}s containing blockwise statistics.
These should have the same number of rows and the same set of columns.}

\item{ave.fields}{Character vector specifying the columns of \code{blocks} to be averaged.
The value of each column is averaged across blocks, potentially in a weighted manner.}

\item{pval.field}{String specifying the column of \code{blocks} containing the p-value.
This is combined using \code{\link{combinePValues}}.}

\item{method}{String specifying how p-values should be combined, see \code{?\link{combinePValues}}.}

\item{geometric}{Logical scalar indicating whether the geometric mean should be computed when averaging \code{ave.fields}.}

\item{equiweight}{Logical scalar indicating whether each block should be given equal weight.}

\item{weights}{Numeric vector of length equal to \code{blocks}, containing the weight for each block.
Only used if \code{equiweight=TRUE}.}

\item{valid}{Logical vector indicating whether each block is valid.
Invalid blocks are still stored in the \code{per.block} output but are not used to compute the combined statistics.}
}
\value{
A \linkS4class{DataFrame} containing all fields in \code{ave.fields} and the p-values,
where each column is created by combining the corresponding block-specific columns.
A \code{per.block} column is also reported, containing a DataFrame of the DataFrames of blockwise statistics.
}
\description{
Combine DataFrames of statistics computed separately for each block.
This usually refers to feature-level statistics and sample-level blocks.
}
\examples{
library(scuttle)
sce <- mockSCE()

y1 <- sce[,1:100] 
y1 <- logNormCounts(y1) # normalize separately after subsetting.
results1 <- modelGeneVar(y1)

y2 <- sce[,1:100 + 100] 
y2 <- logNormCounts(y2) # normalize separately after subsetting.
results2 <- modelGeneVar(y2)

# A manual implementation of combineVar:
combineBlocks(list(results1, results2), 
    ave.fields=c("mean", "total", "bio", "tech"),
    pval.field='p.value', 
    method='fisher',
    geometric=FALSE,
    equiweight=TRUE,
    weights=NULL,
    valid=c(TRUE, TRUE))

}
\seealso{
This function is used in \code{\link{modelGeneVar}} and friends, \code{\link{combineVar}} and \code{\link{testLinearModel}}.
}
\author{
Aaron Lun
}
