% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PollenGliaData.R
\name{PollenGliaData}
\alias{PollenGliaData}
\title{Obtain the Pollen radial glia data}
\usage{
PollenGliaData(ensembl = FALSE, location = TRUE)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of read counts.
}
\description{
Obtain the human radial glia single-cell RNA-seq dataset from Pollen et al. (2017).
}
\details{
Column metadata includes the anatomical source, sample of origin, presumed cell type and assorted alignment statistics.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.
This is only performed when \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/pollen-glia}.
}
\examples{
sce <- PollenGliaData()

}
\references{
Pollen A et al. (2017). 
Molecular identity of human outer radial glia during cortical development.
\emph{Cell} 163, 55-67.
}
\author{
Aaron Lun
}
