% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwm.R
\name{makePWM}
\alias{makePWM}
\title{Constructing a pwm object}
\usage{
makePWM(pwm, alphabet = "DNA")
}
\arguments{
\item{pwm}{matrix. Numerical matrix representing the position weight matrix.}

\item{alphabet}{character. The alphabet making up the sequence. Currently, only 'DNA' and 'RNA' is supported.}
}
\value{
An object of class pwm.
}
\description{
This function constructs an object of class pwm from a matrix. It checks that the matrix has correct dimensions and that columns add up to 1.0.
}
\examples{
mFile <- system.file("extdata/pwm1", package = "seqLogo")
m <- read.table(mFile)
pwm <- makePWM(m)
}
\author{
Oliver Bembom
}
