% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitsort.R
\name{range_sortna}
\alias{range_sortna}
\title{Prepare for sorting and get range, number of NAs and unsortedness}
\usage{
range_sortna(x, decreasing = FALSE, na.last = NA)
}
\arguments{
\item{x}{an integer vector}

\item{decreasing}{(currently only \code{FALSE} is supported)}

\item{na.last}{\code{NA} removes NAs, \code{FALSE} puts NAs at the beginning,
\code{TRUE} puts NAs at the end}
}
\value{
an integer vector with \code{NA}s are treated and an \code{attribute} \code{\link[=range_na]{range_na()}}  with
four elements:
\enumerate{
\item min integer
\item max integer
\item number of NAs
\item 0 for sorted vector and 1 for \code{\link[=is.unsorted]{is.unsorted()}}
}
}
\description{
In one pass over the vector \code{NA}s are treated according to parameter
\code{na.last} exactly like \code{\link[=sort]{sort()}} does, the \code{\link[=range]{range()}},
number of \code{NA}s and unsortedness is determined.
}
\examples{
range_sortna(c(0L, 1L, NA, 2L))
range_sortna(c(2L, NA, 1L, 0L))
range_sortna(c(0L, 1L, NA, 2L), na.last=TRUE)
range_sortna(c(2L, NA, 1L, 0L), na.last=TRUE)
range_sortna(c(0L, 1L, NA, 2L), na.last=FALSE)
range_sortna(c(2L, NA, 1L, 0L), na.last=FALSE)
}
\seealso{
\code{\link[=range_na]{range_na()}} and \code{\link[=range_nanozero]{range_nanozero()}}
}
