% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-access.R
\name{backend-access}
\alias{simulate_access}
\title{Backend: MS Access}
\usage{
simulate_access()
}
\description{
See \code{vignette("translate-function")} and \code{vignette("translate-verb")} for
details of overall translation technology. Key differences for this backend
are:
\itemize{
\item \code{SELECT} uses \code{TOP}, not \code{LIMIT}
\item Non-standard types and mathematical functions
\item String concatenation uses \code{&}
\item No \code{ANALYZE} equivalent
\item \code{TRUE} and \code{FALSE} converted to 1 and 0
}

Use \code{simulate_access()} with \code{lazy_frame()} to see simulated SQL without
converting to live access database.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
lf <- lazy_frame(x = 1, y = 2, z = "a", con = simulate_access())

lf \%>\% head()
lf \%>\% mutate(y = as.numeric(y), z = sqrt(x^2 + 10))
lf \%>\% mutate(a = paste0(z, " times"))
}
