% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{log_with_separator}
\alias{log_with_separator}
\title{Logs a message in a very visible way}
\usage{
log_with_separator(
  ...,
  level = INFO,
  namespace = NA_character_,
  separator = "=",
  width = 80
)
}
\arguments{
\item{...}{R objects that can be converted to a character vector via the active message formatter function}

\item{level}{log level, see \code{\link{log_levels}} for more details}

\item{namespace}{string referring to the \code{logger} environment / config to be used to override the target of the message record to be used instead of the default namespace, which is defined by the R package name from which the logger was called, and falls back to a common, global namespace.}

\item{separator}{character to be used as a separator}

\item{width}{max width of message -- longer text will be wrapped into multiple lines}
}
\description{
Logs a message in a very visible way
}
\examples{
log_with_separator('An important message')
log_with_separator('Some critical KPI down!!!', separator = '$')
log_with_separator('This message is worth a {1e3} words')
log_with_separator(paste(
  'A very important message with a bunch of extra words that will',
  'eventually wrap into a multi-line message for our quite nice demo :wow:'))
log_with_separator(paste(
  'A very important message with a bunch of extra words that will',
  'eventually wrap into a multi-line message for our quite nice demo :wow:'),
  width = 60)
log_with_separator('Boo!', level = FATAL)
}
\seealso{
\code{\link{log_separator}}
}
