% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recreg.R
\name{recreg}
\alias{recreg}
\alias{strataAugment}
\alias{scalecumhaz}
\alias{GLprediid}
\alias{recregIPCW}
\title{Recurrent events regression with terminal event}
\usage{
recreg(
  formula,
  data = data,
  cause = 1,
  death.code = c(2),
  cens.code = 0,
  cens.model = ~1,
  weights = NULL,
  offset = NULL,
  Gc = NULL,
  wcomp = NULL,
  ...
)
}
\arguments{
\item{formula}{formula with 'EventCens' outcome}

\item{data}{data frame}

\item{cause}{of interest}

\item{death.code}{codes for death (terminating event)}

\item{cens.code}{code of censoring (1 default)}

\item{cens.model}{for stratified Cox model without covariates}

\item{weights}{weights for score equations}

\item{offset}{offsets for model}

\item{Gc}{censoring weights for time argument, default is to calculate these with a Kaplan-Meier estimator, should then give G_c(T_i-)}

\item{wcomp}{weights for composite outcome, so when cause=c(1,3), we might have wcomp=c(1,2).}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Fits Ghosh-Lin IPCW Cox-type model
}
\details{
For Cox type model :
\deqn{
E(dN_1(t)|X) = \mu_0(t)dt exp(X^T \beta)
}
by solving Cox-type IPCW weighted score equations 
\deqn{
 \int (Z - E(t)) w(t) dN_1(t) 
}
where \deqn{w(t) = G(t) (I(T_i \wedge t < C_i)/G_c(T_i \wedge t))} and
\deqn{E(t) = S_1(t)/S_0(t)} and \deqn{S_j(t) = \sum X_i^j w_i(t) \exp(X_i^T \beta)}.


The iid decomposition of the beta's are on the form
\deqn{
\int (Z - E ) w(t) dM_1 + \int q(s)/p(s) dM_c
}
and returned as iid.

Events, deaths and censorings are specified via stop start structure and the Event call, that via a status vector 
and cause (code), censoring-codes (cens.code) and death-codes (death.code) indentifies these. See example and vignette.
}
\examples{
## data with no ties
data(base1cumhaz)
data(base4cumhaz)
data(drcumhaz)
Lam1 <- base1cumhaz;  Lam2 <- base4cumhaz;  LamD <- drcumhaz
## simulates recurrent events of types 1 and 2 and with terminal event D and censoring
rr <- simRecurrentII(1000,Lam1,cumhaz2=Lam2,death.cumhaz=LamD,cens=3/5000)
rr <- count.history(rr)
rr$cens <- 0
nid <- max(rr$id)
rr$revnr <- revcumsumstrata(rep(1,nrow(rr)),rr$id-1,nid)
rr$x <- rnorm(nid)[rr$id]
rr$statusG <- rr$status
rr <- dtransform(rr,statusG=3,death==1)
dtable(rr,~statusG+status+death)
dcut(rr) <- gx~x

ll <- recreg(Event(start,stop,statusG)~x+cluster(id),data=rr,cause=1,death.code=3)
summary(ll)

## censoring stratified after quartiles of x
lls <- recreg(Event(start, stop, statusG)~x+cluster(id),data=rr,cause=1,
              death.code=3,cens.model=~strata(gx))
summary(lls)

}
\author{
Thomas Scheike
}
