% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phangorn-package.R
\docType{data}
\name{mites}
\alias{mites}
\title{Morphological characters of Mites (Schäffer et al. 2010)}
\description{
Matrix for morphological characters and character states for 12 species of
mites. See vignette '02_Phylogenetic trees from morphological data' for
examples to import morphological data.
}
\examples{
data(mites)
mites
# infer all maximum parsimony trees
trees <- bab(mites)
# For larger data sets you might use pratchet instead bab
# trees <- pratchet(mites, minit=200, trace=0, all=TRUE)
# build consensus tree
ctree <- root(consensus(trees, p=.5), outgroup = "C._cymba",
              resolve.root=TRUE, edgelabel=TRUE)
plotBS(ctree, trees)
cnet <- consensusNet(trees)
plot(cnet)
}
\references{
Schäffer, S., Pfingstl, T., Koblmüller, S., Winkler, K. A.,
Sturmbauer, C., & Krisper, G. (2010). Phylogenetic analysis of European
Scutovertex mites (Acari, Oribatida, Scutoverticidae) reveals paraphyly and
cryptic diversity: a molecular genetic and morphological approach.
\emph{Molecular Phylogenetics and Evolution}, \bold{55(2)}, 677--688.
}
\keyword{datasets}
