% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_gmm.R
\name{sargan}
\alias{sargan}
\title{Hansen--Sargan Test of Overidentifying Restrictions}
\usage{
sargan(object, weights = c("twosteps", "onestep"))
}
\arguments{
\item{object}{an object of class \code{"pgmm"},}

\item{weights}{the weighting matrix to be used for the computation of the
test.}
}
\value{
An object of class \code{"htest"}.
}
\description{
A test of overidentifying restrictions for models estimated by GMM.
}
\details{
The Hansen--Sargan test calculates the quadratic form of the moment
restrictions that is minimized while computing the GMM estimator. It follows
asymptotically a chi-square distribution with number of degrees of freedom
equal to the difference between the number of moment conditions and the
number of coefficients.
}
\examples{

data("EmplUK", package = "plm")
ar <- pgmm(log(emp) ~ lag(log(emp), 1:2) + lag(log(wage), 0:1) +
           lag(log(capital), 0:2) + lag(log(output), 0:2) | lag(log(emp), 2:99),
           data = EmplUK, effect = "twoways", model = "twosteps")
sargan(ar)

}
\references{
\insertCite{HANS:82}{plm}

\insertCite{SARG:58}{plm}
}
\seealso{
\code{\link[=pgmm]{pgmm()}}
}
\author{
Yves Croissant
}
\keyword{htest}
