% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disease2disease_by_gene.R
\name{disease2disease_by_gene}
\alias{disease2disease_by_gene}
\title{Retrieves disease-disease associations via shared genes and generates an \code{DataGeNET.DGN}}
\usage{
disease2disease_by_gene(
  disease,
  vocabulary = "UMLS",
  ndiseases = 10,
  database = "CURATED",
  api_key = NULL,
  verbose = FALSE,
  warnings = TRUE
)
}
\arguments{
\item{disease}{a CUI or a vector of CUIs
The diseases non existing in DisGeNET will
be removed from the output.}

\item{vocabulary}{The vocabulary of the disease identifier(s)
Select one of the available:  \code{UMLS} (UMLS), \code{OMIM} (OMIM), \code{MSH} (MeSH), \code{DO} (Disease Ontology),
\code{NCI} (NCI thesaurus), \code{ORDO} (Orphanet),
\code{ICD9CM} (ICD9-CM) or \code{EFO} (EFO). Default \code{'UMLS'}.}

\item{ndiseases}{The number of associated diseases to retrieve. By default 10. Set to XX to retrieve all diseases}

\item{database}{Name of the database that will be queried. It can take the values:
\code{'CTD_human'} to use Comparative Toxicogenomics Database, human data;
\code{'UNIPROT'} to use Universal Protein Resource;
\code{'CLINGEN'} to use Clinical Genome Resource;
\code{'CGI'} to use Cancer Genome Interpreter;
\code{'ORPHANET'}, to use Orphanet, the portal for rare diseases and orphan drugs;
\code{'PSYGENET'} to use PSYGENET;
\code{'GENOMICS_ENGLAND'} to use Genomics England PanelApp;
\code{'CURATED'} to use expert curated, human databases;
\code{'HPO'} to use HPO;
\code{'INFERRED'} to use inferred data from HPO, GWASDB, GWASCAT, and CLINVAR;
\code{'CTD_rat'} to use Comparative Toxicogenomics Database, rat data;
\code{'CTD_mouse'} to use Comparative Toxicogenomics Database, mouse data;
\code{'RGD'}, to use Rat Genome Database;
\code{'MGD'}, to use the Mouse Genome Database;
\code{'ANIMAL_MODELS'} to use the expert curated, animal models data;
\code{'GWASCAT'} to use the NHGRI-EBI GWAS Catalog;
\code{'GWASDB'} to use the GWAS Database GWASdb;
\code{'CLINVAR'} to use ClinVar, a public archive of relationships
among sequence variation and human phenotype;
\code{'BEFREE'} to use text mining data, generated using BeFree System;
\code{'ALL'} to use all these databases. Default \code{'CURATED'}.}

\item{verbose}{By default \code{FALSE}. Set to \code{TRUE} to get a
on-time log from the function.}

\item{warnings}{By default \code{TRUE}. Set to \code{FALSE} to hide the warnings.}

\item{pvalue}{p value of the bootstrap. See more info at www.disgenet.org. By default 1}
}
\value{
An object of class \code{DataGeNET.Dis}
}
\description{
Given the CUI of one or multiple diseases, retrieves the associated diseases
from DisGeNET and creates an object of type \code{DataGeNET.Dis}.
}
\examples{
dd1 <- disease2disease_by_gene( "C0028754", database = "CURATED" , pvalue = 0.05)
}
