# langinfo.m4
dnl Copyright (C) 2004 Michael Chapman
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

AC_DEFUN([mac_HAVE_NL_LANGINFO], [
	AC_CHECK_HEADERS_ONCE([langinfo.h])
	m4_pattern_allow(AM_STR)
	if test "$ac_cv_header_langinfo_h" = yes; then
		AC_CACHE_CHECK([for nl_langinfo in langinfo.h], mac_cv_have_nl_langinfo, [
			AC_LINK_IFELSE(AC_LANG_PROGRAM([[
#include <langinfo.h>
			]], [[
char* am = nl_langinfo(AM_STR);
char* pm = nl_langinfo(PM_STR);
char* m1 = nl_langinfo(MON_1);
char* am1 = nl_langinfo(ABMON_1);
char* d1 = nl_langinfo(DAY_1);
char* ad1 = nl_langinfo(ABDAY_1);
			]]), mac_cv_have_nl_langinfo=yes, mac_cv_have_nl_langinfo=no
			)
		])
  	if test "$mac_cv_have_nl_langinfo" = yes; then
			AC_CACHE_CHECK([for decimal point constant for nl_langinfo], mac_cv_nl_langinfo_dp, [
				AC_LINK_IFELSE(AC_LANG_PROGRAM([[
#include <langinfo.h>
				]], [[
char* dp = nl_langinfo(DECIMAL_POINT);
				]]), mac_cv_nl_langinfo_dp=DECIMAL_POINT, [AC_LINK_IFELSE(AC_LANG_PROGRAM([[
#include <langinfo.h>
					]], [[
char* dp = nl_langinfo(RADIXCHAR);
					]]), mac_cv_nl_langinfo_dp=RADIXCHAR, mac_cv_have_nl_langinfo=unknown
				)])
			])
		else
			mac_cv_nl_langinfo_dp=unknown
  	fi
  	if test "$mac_cv_have_nl_langinfo" != no; then
    	AC_DEFINE(HAVE_NL_LANGINFO, 1,
      	[Define if you have the `nl_langinfo' function.]
			)
		fi
  	if test "$mac_cv_nl_langinfo_dp" != unknown; then
    	AC_DEFINE_UNQUOTED(NL_LANGINFO_DP, $mac_cv_nl_langinfo_dp,
      	[Define to the decimal point constant for use in the `nl_langinfo' function.
				 Do not define if no constant is available.]
			)
		fi
	fi
])
