//listenpty.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2011-2019
 *
 *  This file is part of roard a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include <roard/include/roard.h>

#if defined(ROAR_HAVE_POSIX_OPENPT) && defined(ROAR_HAVE_GRANTPT) && defined(ROAR_HAVE_UNLOCKPT) && defined(ROAR_HAVE_TCGETATTR) && defined(ROAR_HAVE_TCSETATTR) && defined(ROAR_HAVE_CFMAKERAW)
#define __HAVE_SUPPORT
#endif

#ifdef __HAVE_SUPPORT
#include <termios.h>
#endif

static int init  (struct roar_dl_librarypara * para) {
#ifdef __HAVE_SUPPORT
 int serverfh = posix_openpt(O_RDWR|O_NOCTTY);
 struct termios termios;

 (void)para;

 if ( serverfh == -1 ) {
  ROAR_WARN("Can not open PTY Master: %s", strerror(errno));
  return 0;
 }

 tcgetattr(serverfh, &termios);
 cfmakeraw(&termios);
 tcsetattr(serverfh, TCSANOW, &termios);

 grantpt(serverfh);
 unlockpt(serverfh);

 if ( clients_new_from_fh(serverfh, ROAR_PROTO_ROARAUDIO, ROAR_BYTEORDER_NETWORK, 0) == -1 ) {
  close(serverfh);
  return 0;
 }

 ROAR_WARN("PTY Slave: %s", ptsname(serverfh));
 return 0;
#else
 ROAR_ERR("No PTY Support found so can not load listenpty plugin.");
 return -1;
#endif
}

static struct roar_dl_appsched sched = {
 .init   = init,
 .free   = NULL,
 .update = NULL,
 .tick   = NULL,
 .wait   = NULL
};

ROAR_DL_PLUGIN_START(listenpty) {
 ROARD_DL_CHECK_VERSIONS();

 ROAR_DL_PLUGIN_META_PRODUCT_NIV("listenpty", ROAR_VID_ROARAUDIO, ROAR_VNAME_ROARAUDIO);
 ROAR_DL_PLUGIN_META_VERSION(ROAR_VERSION_STRING);
 ROAR_DL_PLUGIN_META_LICENSE_TAG(GPLv3_0);
 ROAR_DL_PLUGIN_META_CONTACT_FLNE("Philipp", "Schafft", "ph3-der-loewe", "lion@lion.leolix.org");
 ROAR_DL_PLUGIN_META_DESC("This implements a listen socket using a PTY");

 ROAR_DL_PLUGIN_REG_APPSCHED(&sched); 
} ROAR_DL_PLUGIN_END

//ll
