/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  gengetopt --unamed-opts=OLD-TEXT NEW-TEXT [FILE...] 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "Search and replace text in files.";

const char *gengetopt_args_info_usage = "Usage: " CMDLINE_PARSER_PACKAGE " [OPTION...] OLD-TEXT NEW-TEXT [FILE...]";

const char *gengetopt_args_info_versiontext = "Copyright (C) 2025 Reuben Thomas <rrt@sc3d.org>\n\nLicence GPLv3+: GNU GPL version 3 or later <https://gnu.org/licenses/gpl.html>.\nThis is free software: you are free to change and redistribute it.\nThere is NO WARRANTY, to the extent permitted by law.";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_full_help[] = {
  "  -h, --help               Print help and exit",
  "      --full-help          Print help, including hidden options, and exit",
  "  -V, --version            Print version and exit",
  "\nOLD-TEXT matches at most once in each position, even when it matches the empty\nstring.\n",
  "      --encoding=ENCODING  specify character set encoding",
  "  -w, --whole-words        whole words (OLD-TEXT matches on word boundaries\n                             only)  (default=off)",
  "  -b, --backup             rename original FILE to FILE~ before replacing\n                             (default=off)",
  "  -q, --quiet              quiet mode  (default=off)",
  "  -v, --verbose            verbose mode  (default=off)",
  "  -s, --dry-run            simulation mode  (default=off)",
  "  -F, --fixed-strings      treat OLD-TEXT and NEW-TEXT as fixed strings, not\n                             regular expressions  (default=off)",
  "      --files              OLD-TEXT and NEW-TEXT are file names to read\n                             patterns from  (default=off)",
  "  -x, --glob=GLOB          modify only files matching the given glob (may be\n                             given more than once)  (default=`*')",
  "  -R, --recursive          search recursively  (default=off)",
  "  -p, --prompt             prompt before modifying each file  (default=off)",
  "  -f, --force              ignore errors when trying to preserve attributes\n                             (default=off)",
  "  -d, --keep-times         keep the modification times on modified files\n                             (default=off)",
  "  -E, --extended-regex     use extended regex syntax [IGNORED]  (default=off)",
  "\n Group: case\n  Treatment of upper and lower case",
  "  -i, --ignore-case        search case-insensitively",
  "  -m, --match-case         ignore case when searching, but try to match case of\n                             replacement to case of original, either\n                             capitalized, all upper-case, or mixed",
    0
};

static void
init_help_array(void)
{
  gengetopt_args_info_help[0] = gengetopt_args_info_full_help[0];
  gengetopt_args_info_help[1] = gengetopt_args_info_full_help[1];
  gengetopt_args_info_help[2] = gengetopt_args_info_full_help[2];
  gengetopt_args_info_help[3] = gengetopt_args_info_full_help[3];
  gengetopt_args_info_help[4] = gengetopt_args_info_full_help[4];
  gengetopt_args_info_help[5] = gengetopt_args_info_full_help[5];
  gengetopt_args_info_help[6] = gengetopt_args_info_full_help[6];
  gengetopt_args_info_help[7] = gengetopt_args_info_full_help[7];
  gengetopt_args_info_help[8] = gengetopt_args_info_full_help[8];
  gengetopt_args_info_help[9] = gengetopt_args_info_full_help[9];
  gengetopt_args_info_help[10] = gengetopt_args_info_full_help[10];
  gengetopt_args_info_help[11] = gengetopt_args_info_full_help[11];
  gengetopt_args_info_help[12] = gengetopt_args_info_full_help[12];
  gengetopt_args_info_help[13] = gengetopt_args_info_full_help[13];
  gengetopt_args_info_help[14] = gengetopt_args_info_full_help[14];
  gengetopt_args_info_help[15] = gengetopt_args_info_full_help[15];
  gengetopt_args_info_help[16] = gengetopt_args_info_full_help[16];
  gengetopt_args_info_help[17] = gengetopt_args_info_full_help[18];
  gengetopt_args_info_help[18] = gengetopt_args_info_full_help[19];
  gengetopt_args_info_help[19] = gengetopt_args_info_full_help[20];
  gengetopt_args_info_help[20] = 0; 
  
}

const char *gengetopt_args_info_help[21];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->encoding_given = 0 ;
  args_info->whole_words_given = 0 ;
  args_info->backup_given = 0 ;
  args_info->quiet_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->dry_run_given = 0 ;
  args_info->fixed_strings_given = 0 ;
  args_info->files_given = 0 ;
  args_info->glob_given = 0 ;
  args_info->recursive_given = 0 ;
  args_info->prompt_given = 0 ;
  args_info->force_given = 0 ;
  args_info->keep_times_given = 0 ;
  args_info->extended_regex_given = 0 ;
  args_info->ignore_case_given = 0 ;
  args_info->match_case_given = 0 ;
  args_info->case_group_counter = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->encoding_arg = NULL;
  args_info->encoding_orig = NULL;
  args_info->whole_words_flag = 0;
  args_info->backup_flag = 0;
  args_info->quiet_flag = 0;
  args_info->verbose_flag = 0;
  args_info->dry_run_flag = 0;
  args_info->fixed_strings_flag = 0;
  args_info->files_flag = 0;
  args_info->glob_arg = NULL;
  args_info->glob_orig = NULL;
  args_info->recursive_flag = 0;
  args_info->prompt_flag = 0;
  args_info->force_flag = 0;
  args_info->keep_times_flag = 0;
  args_info->extended_regex_flag = 0;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{

  init_help_array(); 
  args_info->help_help = gengetopt_args_info_full_help[0] ;
  args_info->full_help_help = gengetopt_args_info_full_help[1] ;
  args_info->version_help = gengetopt_args_info_full_help[2] ;
  args_info->encoding_help = gengetopt_args_info_full_help[4] ;
  args_info->whole_words_help = gengetopt_args_info_full_help[5] ;
  args_info->backup_help = gengetopt_args_info_full_help[6] ;
  args_info->quiet_help = gengetopt_args_info_full_help[7] ;
  args_info->verbose_help = gengetopt_args_info_full_help[8] ;
  args_info->dry_run_help = gengetopt_args_info_full_help[9] ;
  args_info->fixed_strings_help = gengetopt_args_info_full_help[10] ;
  args_info->files_help = gengetopt_args_info_full_help[11] ;
  args_info->glob_help = gengetopt_args_info_full_help[12] ;
  args_info->glob_min = 0;
  args_info->glob_max = 0;
  args_info->recursive_help = gengetopt_args_info_full_help[13] ;
  args_info->prompt_help = gengetopt_args_info_full_help[14] ;
  args_info->force_help = gengetopt_args_info_full_help[15] ;
  args_info->keep_times_help = gengetopt_args_info_full_help[16] ;
  args_info->extended_regex_help = gengetopt_args_info_full_help[17] ;
  args_info->ignore_case_help = gengetopt_args_info_full_help[19] ;
  args_info->match_case_help = gengetopt_args_info_full_help[20] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(gengetopt_args_info_purpose);
	size_t len_usage = strlen(gengetopt_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", gengetopt_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", gengetopt_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(gengetopt_args_info_description) > 0) {
		printf("%s\n\n", gengetopt_args_info_description);
	}
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_full_help[i])
    printf("%s\n", gengetopt_args_info_full_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}


static void
free_multiple_string_field(unsigned int len, char ***arg, char ***orig)
{
  unsigned int i;
  if (*arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*arg)[i]));
        free_string_field(&((*orig)[i]));
      }
    free_string_field(&((*arg)[0])); /* free default string */

    free (*arg);
    *arg = 0;
    free (*orig);
    *orig = 0;
  }
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  unsigned int i;
  free_string_field (&(args_info->encoding_arg));
  free_string_field (&(args_info->encoding_orig));
  free_multiple_string_field (args_info->glob_given, &(args_info->glob_arg), &(args_info->glob_orig));
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->encoding_given)
    write_into_file(outfile, "encoding", args_info->encoding_orig, 0);
  if (args_info->whole_words_given)
    write_into_file(outfile, "whole-words", 0, 0 );
  if (args_info->backup_given)
    write_into_file(outfile, "backup", 0, 0 );
  if (args_info->quiet_given)
    write_into_file(outfile, "quiet", 0, 0 );
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", 0, 0 );
  if (args_info->dry_run_given)
    write_into_file(outfile, "dry-run", 0, 0 );
  if (args_info->fixed_strings_given)
    write_into_file(outfile, "fixed-strings", 0, 0 );
  if (args_info->files_given)
    write_into_file(outfile, "files", 0, 0 );
  write_multiple_into_file(outfile, args_info->glob_given, "glob", args_info->glob_orig, 0);
  if (args_info->recursive_given)
    write_into_file(outfile, "recursive", 0, 0 );
  if (args_info->prompt_given)
    write_into_file(outfile, "prompt", 0, 0 );
  if (args_info->force_given)
    write_into_file(outfile, "force", 0, 0 );
  if (args_info->keep_times_given)
    write_into_file(outfile, "keep-times", 0, 0 );
  if (args_info->extended_regex_given)
    write_into_file(outfile, "extended-regex", 0, 0 );
  if (args_info->ignore_case_given)
    write_into_file(outfile, "ignore-case", 0, 0 );
  if (args_info->match_case_given)
    write_into_file(outfile, "match-case", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error_occurred = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error_occurred = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error_occurred = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error_occurred = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error_occurred = 1;
            }
        }
    }
    
  return error_occurred;
}
static void
reset_group_case(struct gengetopt_args_info *args_info)
{
  if (! args_info->case_group_counter)
    return;
  
  args_info->ignore_case_given = 0 ;
  args_info->match_case_given = 0 ;

  args_info->case_group_counter = 0;
}

int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->glob_given, args_info->glob_min, args_info->glob_max, "'--glob' ('-x')"))
     error_occurred = 1;
  
  
  /* checks for dependences among options */

  return error_occurred;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

	FIX_UNUSED(stop_char);
	
  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */
  union generic_value multiple_default_value;

  struct generic_list * glob_list = NULL;
  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "encoding",	1, NULL, 0 },
        { "whole-words",	0, NULL, 'w' },
        { "backup",	0, NULL, 'b' },
        { "quiet",	0, NULL, 'q' },
        { "verbose",	0, NULL, 'v' },
        { "dry-run",	0, NULL, 's' },
        { "fixed-strings",	0, NULL, 'F' },
        { "files",	0, NULL, 0 },
        { "glob",	1, NULL, 'x' },
        { "recursive",	0, NULL, 'R' },
        { "prompt",	0, NULL, 'p' },
        { "force",	0, NULL, 'f' },
        { "keep-times",	0, NULL, 'd' },
        { "extended-regex",	0, NULL, 'E' },
        { "ignore-case",	0, NULL, 'i' },
        { "match-case",	0, NULL, 'm' },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVwbqvsFx:RpfdEim", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'w':	/* whole words (OLD-TEXT matches on word boundaries only).  */
        
        
          if (update_arg((void *)&(args_info->whole_words_flag), 0, &(args_info->whole_words_given),
              &(local_args_info.whole_words_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "whole-words", 'w',
              additional_error))
            goto failure;
        
          break;
        case 'b':	/* rename original FILE to FILE~ before replacing.  */
        
        
          if (update_arg((void *)&(args_info->backup_flag), 0, &(args_info->backup_given),
              &(local_args_info.backup_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "backup", 'b',
              additional_error))
            goto failure;
        
          break;
        case 'q':	/* quiet mode.  */
        
        
          if (update_arg((void *)&(args_info->quiet_flag), 0, &(args_info->quiet_given),
              &(local_args_info.quiet_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "quiet", 'q',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* verbose mode.  */
        
        
          if (update_arg((void *)&(args_info->verbose_flag), 0, &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "verbose", 'v',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* simulation mode.  */
        
        
          if (update_arg((void *)&(args_info->dry_run_flag), 0, &(args_info->dry_run_given),
              &(local_args_info.dry_run_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "dry-run", 's',
              additional_error))
            goto failure;
        
          break;
        case 'F':	/* treat OLD-TEXT and NEW-TEXT as fixed strings, not regular expressions.  */
        
        
          if (update_arg((void *)&(args_info->fixed_strings_flag), 0, &(args_info->fixed_strings_given),
              &(local_args_info.fixed_strings_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "fixed-strings", 'F',
              additional_error))
            goto failure;
        
          break;
        case 'x':	/* modify only files matching the given glob (may be given more than once).  */
        
          if (update_multiple_arg_temp(&glob_list, 
              &(local_args_info.glob_given), optarg, 0, "*", ARG_STRING,
              "glob", 'x',
              additional_error))
            goto failure;
        
          break;
        case 'R':	/* search recursively.  */
        
        
          if (update_arg((void *)&(args_info->recursive_flag), 0, &(args_info->recursive_given),
              &(local_args_info.recursive_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "recursive", 'R',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* prompt before modifying each file.  */
        
        
          if (update_arg((void *)&(args_info->prompt_flag), 0, &(args_info->prompt_given),
              &(local_args_info.prompt_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "prompt", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* ignore errors when trying to preserve attributes.  */
        
        
          if (update_arg((void *)&(args_info->force_flag), 0, &(args_info->force_given),
              &(local_args_info.force_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "force", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* keep the modification times on modified files.  */
        
        
          if (update_arg((void *)&(args_info->keep_times_flag), 0, &(args_info->keep_times_given),
              &(local_args_info.keep_times_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "keep-times", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'E':	/* use extended regex syntax [IGNORED].  */
        
        
          if (update_arg((void *)&(args_info->extended_regex_flag), 0, &(args_info->extended_regex_given),
              &(local_args_info.extended_regex_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "extended-regex", 'E',
              additional_error))
            goto failure;
        
          break;
        case 'i':	/* search case-insensitively.  */
        
          if (args_info->case_group_counter && override)
            reset_group_case (args_info);
          args_info->case_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->ignore_case_given),
              &(local_args_info.ignore_case_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "ignore-case", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'm':	/* ignore case when searching, but try to match case of replacement to case of original, either capitalized, all upper-case, or mixed.  */
        
          if (args_info->case_group_counter && override)
            reset_group_case (args_info);
          args_info->case_group_counter += 1;
        
          if (update_arg( 0 , 
               0 , &(args_info->match_case_given),
              &(local_args_info.match_case_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "match-case", 'm',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            cmdline_parser_print_full_help ();
            cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* specify character set encoding.  */
          if (strcmp (long_options[option_index].name, "encoding") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->encoding_arg), 
                 &(args_info->encoding_orig), &(args_info->encoding_given),
                &(local_args_info.encoding_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "encoding", '-',
                additional_error))
              goto failure;
          
          }
          /* OLD-TEXT and NEW-TEXT are file names to read patterns from.  */
          else if (strcmp (long_options[option_index].name, "files") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->files_flag), 0, &(args_info->files_given),
                &(local_args_info.files_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "files", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */

  if (args_info->case_group_counter > 1)
    {
      fprintf (stderr, "%s: %d options of group case were given. At most one is required%s.\n", argv[0], args_info->case_group_counter, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  

  multiple_default_value.default_string_arg = "*";
  update_multiple_arg((void *)&(args_info->glob_arg),
    &(args_info->glob_orig), args_info->glob_given,
    local_args_info.glob_given, &multiple_default_value,
    ARG_STRING, glob_list);

  args_info->glob_given += local_args_info.glob_given;
  local_args_info.glob_given = 0;
  
  if (check_required)
    {
      error_occurred += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */

      i = optind;
      while (i < argc)
        if (argv[i++] == argv[0]) {
          found_prog_name = 1;
          break;
        }
      i = 0;

      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        if (argv[optind++] != argv[0])
          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;
    }

  return 0;

failure:
  free_list (glob_list, 1 );
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
