# Release Notes v0.8.0 : Complex-Fault-Tree Generator

This release upgrades the fault tree generator
and introduces support for the shorthand notation.
The release adds more support for OpenPSA MEF features.
The project licenses are upgraded,
and the project name uses a recursive acronym
("SCRAM is a Command-line Risk Analysis Multi-tool.").


## Major Changes

- Complex-fault-tree generator

    * More gate types: K/N, NOT, XOR.
    * House events
    * CCF groups
    * Common gates with no cycles in the resulting fault tree
    * More factors to control the complexity of the final fault tree
    * Reproducibility (Deterministic execution)
    * Better performance (100,000-basic-event/50,000-gate tree in less than 1min)
    * Better error reporting for wrong parameters
    * XML and the shorthand format for the output
    * Nested Boolean formula for the output
    * Topological sort of the output

- Shorthand format to XML converter

    * Logical operators: AND, OR, K/N, XOR, NOT
    * Fault tree validation: cycles, repeated children, redefined nodes.
    * Basic and House events
    * Flexible with undefined nodes
    * Multiple top events
    * Topological sort of the output
    * Nested Boolean formula, Boolean equations (Experimental support)
    * Parentheses (Experimental support)

- OpenPSA MEF features

    * Multiple top events per fault tree container
    * Nested Boolean formula for gates
    * Components in fault trees
    * Public and Private roles
    * Optional expression for basic events
    * Optional expression for house events

- Updated and corrected OpenPSA MEF DTD


## Bug Fixes

- Cycle detection in parameters that takes into account expressions
- Corrected graphing instructions for multiple-fault-tree models.


## Relicensing

- The project under the GPLv3
- The website materials under the CC BY-SA 4.0
- Individual Contributor License Agreement (Harmony ICLA 1.0-beta and Apache ICLA 2.0)
- The OIN License Agreement


## Since v0.7.0

- 226  commits resulted in 292 files changed, 16622 insertions(+), 21351 deletions(-)
