library(ggplot2)
library(reshape2)

tau <- c(0.0, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 1.0)

#######################################################################################################################
# p = 100
#######################################################################################################################

simple <- c(0.0014589349774664496, 0.6235375086028906, 0.7427709328639678, 0.8162528483915835, 0.8665601233182586, 0.9057404854135207, 0.9276081909286377, 0.944769221028639, 0.9631181112159514, 0.9720289065471478, 0.9816648760940738, 0.9875519512405019, 0.9923265668062294, 0.9957066459112708, 0.9972876631287633, 0.9989639276651334, 0.999579827729369, 0.9998199693947971, 0.9999849999249997, 0.999920006399488, 0.9999100080992711)
indirect <- c(0.0014589349774664496, 0.6661509116858518, 0.7909709712130188, 0.8652546652217576, 0.8936094884050274, 0.9276081909286377, 0.9454313449441342, 0.9631181112159514, 0.976338054121007, 0.9819033317213469, 0.9875519512405019, 0.9923265668062294, 0.9958478307802764, 0.9972876631287633, 0.9989639276651334, 0.9995197742939183, 0.9997549424114667, 0.9999599987999641, 0.9999750003749944, 0.9999100080992711, 0.9999100080992711)
overlapping <- c(0.0014589349774664496, 0.5784449609427753, 0.7046967695137432, 0.7774164364134288, 0.8384451426679753, 0.8873187720449968, 0.9110905428213644, 0.9335892719080754, 0.9534658594399996, 0.9631181112159514, 0.9763852067190074, 0.9816648760940738, 0.9888674304088009, 0.9923265668062294, 0.9958478307802764, 0.997885538486206, 0.9993145304533606, 0.999734932407764, 0.999954998424945, 0.999960001599936, 0.9999100080992711)
indirect_overlapping <- c(0.0014589349774664496, 0.6227223270483562, 0.7428025445676498, 0.8382764669663914, 0.8747735481765705, 0.9090413200600027, 0.9335892719080754, 0.9534658594399996, 0.9631181112159514, 0.9763852067190074, 0.9819033317213469, 0.9888674304088009, 0.9923519513104463, 0.9958478307802764, 0.9977599935856639, 0.9989689380061464, 0.9996398739558846, 0.9999049919243136, 0.99998, 0.9999300048996571, 0.9999100080992711)

df <- data.frame(tau, simple, indirect, overlapping, indirect_overlapping)
colnames(df) <- c("tau", "Simple", "Indirect", "Overlap", "Both")
df2 <- melt(df, id = "tau", variable.name="Method")

f1 <- ggplot(df2, aes(x = tau, y = value, color = Method)) + 
  geom_line(size = 1) + 
  geom_point(size = 3) + 
  labs(title=expression(bold("F-score vs "*tau*", p = 100")),
       x =expression(tau), 
       y ="F-score") + 
  scale_colour_discrete(name = "Method", labels =c(expression("("*bar(italic("I"))*","*bar(italic("O"))*")"), 
                                                   expression("("*italic("I")*","*bar(italic("O"))*")"), 
                                                   expression("("*bar(italic("I"))*","*italic("O")*")"), 
                                                   expression("("*italic("I")*","*italic("O")*")"))) +
  theme_bw() +
  theme(text = element_text(size=30),
        plot.title = element_text(size=30, face="bold", hjust = 0.5),
        axis.title.x = element_text(size=40, face="bold"),
        axis.title.y = element_text(size=20, face="bold"),
        legend.text.align = 0)

#######################################################################################################################
# p = 150
#######################################################################################################################

simple <- c(0.0007197408932784198, 0.4570163324821207, 0.5913905792201938, 0.6866212675418146, 0.7539872408293461, 0.796492980545309, 0.8421637643571693, 0.8729981629870056, 0.8995994542013293, 0.9248121109163827, 0.9416813508379237, 0.9572036372737132, 0.9660823308639933, 0.9771599824071516, 0.9862381833388245, 0.9920726514032868, 0.995651169564213, 0.9989889788686572, 0.9995147646608605, 0.999979999599992, 0.9998350272205087)
indirect <- c(0.0007197408932784198, 0.5108078123022166, 0.662887094186233, 0.750039061279335, 0.8078917565714967, 0.8533950971174353, 0.8818507606210201, 0.9064644354896032, 0.9293075296447978, 0.9488013707630125, 0.9642403998032056, 0.9767308597507317, 0.9855645840307576, 0.9912745246381198, 0.9946616533794448, 0.9977047438634473, 0.9989889788686572, 0.9995147646608605, 0.999929995099657, 1.0, 0.9998450240212767)
overlapping <- c(0.0007197408932784198, 0.4003967016179987, 0.5361497811543923, 0.6375928991341904, 0.7110661416409416, 0.7713629271049625, 0.8212203905296845, 0.8534345368448811, 0.8815568728330164, 0.9058721839885336, 0.9252800988742309, 0.9458704474779951, 0.9613519043612833, 0.9758295780417862, 0.9843642882171023, 0.9912745246381198, 0.9956158632430558, 0.9978001713761706, 0.9995147646608605, 0.9999749993749844, 0.9998300288950878)
indirect_overlapping <- c(0.0007197408932784198, 0.45965450050446316, 0.6133259377383347, 0.7088360802845726, 0.7713629271049625, 0.8232663771901956, 0.8633651212221098, 0.8912234794515992, 0.9145536644668287, 0.9350883078020755, 0.9520236423466286, 0.9660556055295346, 0.9775103399266875, 0.9861662383219023, 0.9920523326428892, 0.995651169564213, 0.997820259063463, 0.9994597082424509, 0.9999149927743858, 0.999989999899999, 0.9998300288950878)

df <- data.frame(tau, simple, indirect, overlapping, indirect_overlapping)
colnames(df) <- c("tau", "Simple", "Indirect", "Overlap", "Both")
df2 <- melt(df, id = "tau", variable.name="Method")

f2 <- ggplot(df2, aes(x = tau, y = value, color = Method)) + 
  geom_line(size = 1) + 
  geom_point(size = 3) + 
  labs(title=expression(bold("F-score vs "*tau*", p = 150")),
       x =expression(tau), 
       y ="F-score") + 
  scale_colour_discrete(name = "Method", labels =c(expression("("*bar(italic("I"))*","*bar(italic("O"))*")"), 
                                                   expression("("*italic("I")*","*bar(italic("O"))*")"), 
                                                   expression("("*bar(italic("I"))*","*italic("O")*")"), 
                                                   expression("("*italic("I")*","*italic("O")*")"))) +
  theme_bw() +
  theme(text = element_text(size=30),
        plot.title = element_text(size=30, face="bold", hjust = 0.5),
        axis.title.x = element_text(size=40, face="bold"),
        axis.title.y = element_text(size=20, face="bold"),
        legend.text.align = 0)

#######################################################################################################################
# p = 250
#######################################################################################################################

simple <- c(0.00019998000199980003, 0.27079370568908867, 0.41510091844901775, 0.5146897186822328, 0.58267604935122, 0.6610161548400918, 0.6963889975231391, 0.7498437304663083, 0.8006931993307868, 0.8427600173585996, 0.8702926506888391, 0.8994117355726636, 0.9277634217213686, 0.9453757362595642, 0.9619610631594792, 0.9772122898171256, 0.9870699478847488, 0.9940700429029127, 0.9980110519380971, 0.9996999099729919, 1.0)
indirect <- c(0.00019998000199980003, 0.3385530458476287, 0.4831707798019021, 0.58267604935122, 0.6676792304515236, 0.7237572586305916, 0.7752452571372583, 0.8233563759376379, 0.8639268368882955, 0.8900420119098491, 0.9148540207371396, 0.9401390537561473, 0.9593089811634925, 0.9735009264154139, 0.9827422217927134, 0.9902253816948057, 0.9946212235459708, 0.9979056227515507, 0.9994096516944998, 0.9999349957747253, 1.0)
overlapping <- c(0.00019998000199980003, 0.22479429803928527, 0.3648107268416319, 0.46591649983508604, 0.5473034319956419, 0.6091890876975821, 0.6676881057855644, 0.7237572586305916, 0.7752452571372583, 0.8006931993307868, 0.8441444357113136, 0.8819820222709182, 0.9081658277740776, 0.9327983095525223, 0.9522377582079075, 0.9703035545121298, 0.9838895691183718, 0.9918592635531921, 0.9971368256371943, 0.999519769489355, 1.0)
indirect_overlapping <- c(0.00019998000199980003, 0.2896480950955659, 0.43693827469246765, 0.5400500762823836, 0.6212981856284123, 0.6941248677801428, 0.7493512259484607, 0.7991161494860217, 0.8233563759376379, 0.8639332901627983, 0.8990785287285458, 0.9281254521970749, 0.9453757362595642, 0.9619610631594792, 0.9772018287631301, 0.9867671793624739, 0.9927376383726669, 0.997001033088936, 0.9990991892703432, 0.9998899878986689, 1.0)

df <- data.frame(tau, simple, indirect, overlapping, indirect_overlapping)
colnames(df) <- c("tau", "Simple", "Indirect", "Overlap", "Both")
df2 <- melt(df, id = "tau", variable.name="Method")

f3 <- ggplot(df2, aes(x = tau, y = value, color = Method)) + 
  geom_line(size = 1) + 
  geom_point(size = 3) + 
  labs(title=expression(bold("F-score vs "*tau*", p = 250")),
       x =expression(tau), 
       y ="F-score") + 
  scale_colour_discrete(name = "Method", labels =c(expression("("*bar(italic("I"))*","*bar(italic("O"))*")"), 
                                                   expression("("*italic("I")*","*bar(italic("O"))*")"), 
                                                   expression("("*bar(italic("I"))*","*italic("O")*")"), 
                                                   expression("("*italic("I")*","*italic("O")*")"))) +
  theme_bw() +
  theme(text = element_text(size=30),
        plot.title = element_text(size=30, face="bold", hjust = 0.5),
        axis.title.x = element_text(size=40, face="bold"),
        axis.title.y = element_text(size=20, face="bold"),
        legend.text.align = 0)

#######################################################################################################################
# Save plots
#######################################################################################################################

ggsave(file="<DIR>/f_100.svg", plot=f1, width=16, height=9)
ggsave(file="<DIR>/f_150.svg", plot=f2, width=16, height=9)
ggsave(file="<DIR>/f_250.svg", plot=f3, width=16, height=9)
