#version 330
layout(points) in;
layout(line_strip, max_vertices = 128) out;

in vec3 vertex[];

out vec4 color;

uniform vec3 origin;
uniform mat4 pmv;
uniform mat3 cholesky;


vec3 frac2cart(vec3 x){
  vec3 y = cholesky * x;
  return y;
}

void main(void){
    const vec3 strip0[] = vec3[9](vec3(0,1,1),vec3(0,1,0),vec3(1,1,0),vec3(1,0,0),vec3(1,0,1),vec3(0,0,1),vec3(0,1,1),vec3(1,1,1),vec3(1,0,1));
    vec4 p;
    for (int i = 0; i < strip0.length(); i++){
       p = vec4(frac2cart(strip0[i]) - origin, 1);
       gl_Position = pmv * p;
       color =  vec4(0.4,0.6,0.9,1.0);
       EmitVertex();
    }
    EndPrimitive();
    p = vec4(frac2cart(vec3(1,1,0)) - origin, 1);
    gl_Position = pmv * p;
    color = vec4(0.4,0.6,0.9,1.0);
    EmitVertex();

    p = vec4(frac2cart(vec3(1,1,1)) - origin, 1);
    gl_Position = pmv * p;
    color = vec4(0.4,0.6,0.9,1.0);
    EmitVertex();
    EndPrimitive();


    p = vec4(frac2cart(vec3(0,0,0)) - origin, 1);
    gl_Position = pmv * p;
    color = vec4(1,0,0,1.0);//red
    EmitVertex();

    p = vec4(frac2cart(vec3(1,0,0)) - origin, 1);
    gl_Position = pmv * p;
    color = vec4(1,0,0,1.0);//red
    EmitVertex();
    EndPrimitive();


    p = vec4(frac2cart(vec3(0,0,0)) - origin, 1);
    gl_Position = pmv * p;
    color = vec4(0,1,0,1.0);//green
    EmitVertex();

    p = vec4(frac2cart(vec3(0,1,0)) - origin, 1);
    gl_Position = pmv * p;
    color = vec4(0,1,0,1.0);//green
    EmitVertex();
    EndPrimitive();


    p = vec4(frac2cart(vec3(0,0,0)) - origin, 1);
    gl_Position = pmv * p;
    color = vec4(0,0,1,1.0);//blue
    EmitVertex();

    p = vec4(frac2cart(vec3(0,0,1)) - origin, 1);
    gl_Position = pmv * p;
    color = vec4(0,0,1,1.0);//blue
    EmitVertex();
    EndPrimitive();

const float PI = 3.14159265359;
vec3 direction   = vec3(1,0,0);
vec3 nd = normalize(frac2cart(direction));
vec3 lot = (dot(direction, vec3(1, 0, 0)) > 0.8)?
            (dot(direction, vec3(0, 1, 0)) > 0.8)?
            normalize(cross(direction, vec3(0, 0, 1))):
            normalize(cross(direction, vec3(0, 1, 0))):
            normalize(cross(direction, vec3(1, 0, 0)));
vec3 lot2 = normalize(cross(direction,lot));
vec3 r = vec3(0,0,0), vert;
int segments = 5;
float rad = 0.025;
vec3 start = frac2cart(direction);
vec3 end = start - 0.15 * nd;
vec4 col = vec4(direction,1);

for (int i = 0; i <= 2*segments; i++){
    r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;
    vert = (end  + rad * r) - origin;
    color = col;
    gl_Position = pmv* vec4(vert, 1);
    EmitVertex();
}

for (int i = 0; i <= 2*segments; i++){
    r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;
    vert = start - origin;
    color = col;
    gl_Position = pmv* vec4(vert, 1);
    //Normal = normalMatrix * r;
    EmitVertex();
    vert = (end  + rad * r)  - origin;
    color = col;
    gl_Position = pmv* vec4(vert , 1);
    //Normal = normalMatrix * r;
    EmitVertex();
}
EndPrimitive();

direction   = vec3(0,1,0);
lot = (dot(direction, vec3(1, 0, 0)) > 0.8)?
       (dot(direction, vec3(0, 1, 0)) > 0.8)?
       normalize(cross(direction, vec3(0, 0, 1))):
       normalize(cross(direction, vec3(0, 1, 0))):
       normalize(cross(direction, vec3(1, 0, 0)));
lot2 = normalize(cross(direction,lot));
start = frac2cart(direction);
nd = normalize(frac2cart(direction));
end = start - 0.1 * nd;
col = vec4(direction,1);

for (int i = 0; i <= 2*segments; i++){
    r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;
    vert = (end  + rad * r) - origin;
    color = col;
    gl_Position = pmv* vec4(vert, 1);
    EmitVertex();
}

for (int i = 0; i <= 2*segments; i++){
    r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;
    vert = start - origin;
    color = col;
    gl_Position = pmv* vec4(vert, 1);
    //Normal = normalMatrix * r;
    EmitVertex();
    vert = (end  + rad * r)  - origin;
    color = col;
    gl_Position = pmv* vec4(vert , 1);
    //Normal = normalMatrix * r;
    EmitVertex();
}
EndPrimitive();

direction   = vec3(0,0,1);
lot = (dot(direction, vec3(1, 0, 0)) > 0.8)?
       (dot(direction, vec3(0, 1, 0)) > 0.8)?
       normalize(cross(direction, vec3(0, 0, 1))):
       normalize(cross(direction, vec3(0, 1, 0))):
       normalize(cross(direction, vec3(1, 0, 0)));
lot2 = normalize(cross(direction,lot));
start = frac2cart(direction);
nd = normalize(frac2cart(direction));
end = start - 0.1 * nd;
col = vec4(direction,1);

for (int i = 0; i <= 2*segments; i++){
    r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;
    vert = (end  + rad * r) - origin;
    color = col;
    gl_Position = pmv* vec4(vert, 1);
    EmitVertex();
}

for (int i = 0; i <= 2*segments; i++){
    r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;
    vert = start - origin;
    color = col;
    gl_Position = pmv* vec4(vert, 1);
    //Normal = normalMatrix * r;
    EmitVertex();
    vert = (end  + rad * r)  - origin;
    color = col;
    gl_Position = pmv* vec4(vert , 1);
    //Normal = normalMatrix * r;
    EmitVertex();
}
EndPrimitive();
}
