/*
 * Classes handling tag patches
 *
 * Copyright (C) 2003--2008  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tests/test-utils.h>
#include <tagcoll/stream/patcher.h>
#include <tagcoll/coll/simple.h>

namespace tut {
using namespace std;
using namespace tagcoll;
using namespace tagcoll::tests;
using namespace wibble::operators;

struct tagcoll_stream_patcher_shar {
};
TESTGRP(tagcoll_stream_patcher);

// Test simple collection patching
template<> template<>
void to::test<1>()
{
	string input_coll("a: b\n");
	string output_coll("a: c\n");
	input::String patch("a: +c, -b");
	PatchList<string, string> patches = textformat::parsePatch(patch);
	coll::Simple<string, string> result;
	parseCollection(input_coll, stream::patcher(patches, inserter(result)));
	coll::Simple<string, string> reference;
	parseCollection(output_coll, inserter(reference));
	ensure_coll_equals(reference, result);
}

// Test adding new items through patching
template<> template<>
void to::test<2>()
{
	string input_coll("a: b\n");
	string output_coll("a: b\nb: c\n");
	input::String patch("b: +c, -b");
	PatchList<string, string> patches = textformat::parsePatch(patch);
	coll::Simple<string, string> result;
	parseCollection(input_coll, stream::patcher(patches, inserter(result)));
	coll::Simple<string, string> reference;
	parseCollection(output_coll, inserter(reference));
	ensure_coll_equals(reference, result);
}

template<> template<>
void to::test<3>()
{
	string input_coll(
			"a: b, c\n"
			"b:\n"
			"c: \n"
			"d:  c::D, e::F,    f::g\n"
			);
	string output_coll(
			"a: b\n"
			"b: b, c\n"
			"c: \n"
			"d: c::D, c::d, e::F\n"
			);
	coll::Simple<string, string> result;
	PatchList<string, string> patches;

	std::set<string> added;
	std::set<string> removed;

	added.insert("b");
	removed.insert("c"); removed.insert("d");
	patches.addPatch(Patch<string, string>("a", added, removed));

	added.clear(); added.insert("b"), added.insert("c"), added.insert("b");
	removed.clear(); removed.insert("a");
	patches.addPatch(Patch<string, string>("b", added, removed));

	added.clear(); added.insert("c::D"), added.insert("c::d");
	removed.clear(); removed.insert("f::g");
	patches.addPatch(Patch<string, string>("d", added, removed));

	parseCollection(input_coll, stream::patcher(patches, inserter(result)));

	coll::Simple<string, string> reference;
	parseCollection(output_coll, inserter(reference));

	ensure_coll_equals(reference, result);
}

}

#include <tagcoll/TextFormat.tcc>
#include <tagcoll/patch.tcc>
#include <tagcoll/coll/simple.tcc>

// vim:set ts=4 sw=4:
