---
myst:
  html_meta:
    keywords: LaTeX, commentaire, cacher du texte, inclure des commentaires, 
              annoter un document LaTeX
---

# Comment commenter une partie d'un fichier source LaTeX ?

## Avec le caractère %

Tout ce qui se trouve entre le caractère `%` et la fin de la ligne (inclus tous les deux) 
est ignoré dans le résultat produit par TeX et LaTeX.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Que va-t-on % vraiment
voir dans le document produit ?
\end{document}
```

Bon nombre d'éditeurs offrent la possibilité de commenter des passages. 
Par exemple, `(un)comment-region` avec `Emacs`.

Notez que le `%` est parfois important comme, dans l'exemple suivant, en 
 fin de ligne après `\ifthenelse`. Si vous l'oubliez, vous aurez une espace en trop 
dans le rendu final, entre "simple" et "de faire" :

::::{tab-set}

:::{tab-item} Sans `%`
```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{ifthen}

\begin{document}
Regardez comme c'est simple
\ifthenelse{\boolean{false}}
{Ne pas oublier le \usepackage{ifthen}
pour cette commande sous \LaTeX{}}{}
de faire disparaître du texte !
\end{document}
```
:::

:::{tab-item} Avec `%`

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{ifthen}

\begin{document}
Regardez comme c'est simple
\ifthenelse{\boolean{false}}
{Ne pas oublier le \usepackage{ifthen}
pour cette commande sous \LaTeX{}}{}%
de faire disparaître du texte !
\end{document}
```
:::

::::

La question "[](commenter_ses_fins_de_lignes)" détaille ce sujet.


:::{seealso}
La relation entre le caractère `%` et le code est évoquée dans la question
"[](/2_programmation/macros/caractere_pourcent_dans_les_macros)".
:::