# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

about-update-whats-new = What’s New
aboutDialog-title =
    .title = About { -brand-full-name }
about-dialog-title = About { -brand-full-name }
release-notes-link = Release notes
update-internal-error = Unable to check for updates due to internal error. Updates available at <a data-l10n-name="manual-link"/>
update-check-for-updates-button = Check for Updates
    .accesskey = C
update-update-button = Restart to update { -brand-shorter-name }
    .accesskey = R
update-checking-for-updates = Checking for updates…
update-downloading-message = Downloading update — <span data-l10n-name="download-status"></span>
update-applying = Applying update…
update-downloading = <img data-l10n-name="icon"/>Downloading update — <span data-l10n-name="download-status"></hspan>
update-failed = Update failed. <a data-l10n-name="failed-link">Download the latest version</a>
update-admin-disabled = Updates disabled by your system administrator
update-no-updates-found = { -brand-short-name } is up to date
update-other-instance-handling-updates = { -brand-short-name } is being updated by another instance
update-manual = Updates available at <a data-l10n-name="manual-link"/>
update-unsupported = You can not perform further updates on this system. <a data-l10n-name="unsupported-link">Learn more</a>
update-restarting = Restarting…
# Variables:
#   $channel (String): description of the update channel (e.g. "release", "beta", "nightly" etc.)
channel-description = You are currently on the <span data-l10n-name="current-channel">{ $channel }</span> update channel.
warning-desc-version = { -brand-short-name } is experimental and may be unstable.
warning-desc-telemetry = It automatically sends information about performance, hardware, usage and customisations back to { -vendor-short-name } to help make { -brand-short-name } better.
# Example of resulting string: 66.0.1 (64-bit)
# Variables:
#   $version (String): version of Thunderbird, e.g. 66.0.1
#   $bits (Number): bits of the architecture (32 or 64)
aboutDialog-version = { $version } ({ $bits }-bit)
# Example of resulting string: 66.0a1 (2019-01-16) (64-bit)
# Variables:
#   $version (String): version of Thunderbird for Daily builds, e.g. 66.0a1
#   $isodate (String): date in ISO format, e.g. 2019-01-16
#   $bits (Number): bits of the architecture (32 or 64)
aboutDialog-version-nightly = { $version } ({ $isodate }) ({ $bits }-bit)
aboutdialog-update-checking-failed = Failed to check for updates.
community-exp =
    <a data-l10n-name="community-exp-mozilla-link">
    { -vendor-short-name }</a>
     is a <a data-l10n-name="community-exp-credits-link">
    global community</a>
     working together to keep the Web open, public and accessible to all.
community-2 =
    { -brand-short-name } is designed by <a data-l10n-name="community-mozilla-link">
    { -vendor-short-name }</a>
    , a <a data-l10n-name="community-credits-link">
    global community</a>
     working together to keep the Web open, public and accessible to all.
about-helpus =
    Want to help? <a data-l10n-name="helpus-donate-link">
    Make a donation</a> or <a data-l10n-name="helpus-get-involved-link">
    get involved!</a>
community-experimental = <a data-l10n-name="community-exp-mozilla-link">{ -vendor-short-name }</a> is a <a data-l10n-name="community-exp-credits-link">global community</a> working together to keep the Web open, public and accessible to all.
community-desc = { -brand-short-name } is designed by <a data-l10n-name="community-mozilla-link">{ -vendor-short-name }</a>, a <a data-l10n-name="community-credits-link">global community</a> working together to keep the Web open, public and accessible to all.
about-donation = Want to help? <a data-l10n-name="helpus-donate-link">Make a donation</a> or <a data-l10n-name="helpus-get-involved-link">get involved!</a>
bottom-links-license = Licensing Information
bottom-links-rights = End-User Rights
bottom-links-privacy = Privacy Policy
cmd-close-mac-command-key =
    .key = w
