
(define-library (srfi 129 test)
  (export run-tests)
  (import (scheme base) (scheme char) (srfi 129) (chibi test))
  (begin
    (define Floo "\xFB02;oo")
    (define Floo-bar "\xFB02;oo bar")
    (define Baffle "Ba\xFB04;e")
    (define LJUBLJANA "\x01C7;ub\x01C7;ana")
    (define Ljubljana "\x01C8;ub\x01C9;ana")
    (define ljubljana "\x01C9;ub\x01C9;ana")
    (define (run-tests)
      (test-begin "srfi-129: titlecase")
      (test-group "titlecase/predicate"
        (test-assert (char-title-case? #\x01C5))
        (test-assert (char-title-case? #\x1FFC))
        (test-assert (char-upper-case? #\x01C7))
        (test-assert (char-title-case? #\x01C8))
        (test-assert (char-lower-case? #\x01C9))
        (test-assert (not (char-title-case? #\Z)))
        (test-assert (not (char-title-case? #\z))))

      (test-group "titlecase/char"
        (test #\x01C5 (char-titlecase #\x01C4))
        (test #\x01C5 (char-titlecase #\x01C5))
        (test #\x01C5 (char-titlecase #\x01C6))
        (test #\x1F88 (char-titlecase #\x1F80))
        (test #\x01C7 (char-upcase #\x01C7))
        (test #\x01C7 (char-upcase #\x01C8))
        (test #\x01C7 (char-upcase #\x01C9))
        (test #\x01C8 (char-titlecase #\x01C7))
        (test #\x01C8 (char-titlecase #\x01C8))
        (test #\x01C8 (char-titlecase #\x01C9))
        (test #\x01C9 (char-downcase #\x01C7))
        (test #\x01C9 (char-downcase #\x01C8))
        (test #\x01C9 (char-downcase #\x01C9))
        (test #\Z (char-titlecase #\Z))
        (test #\Z (char-titlecase #\z)))

      (test-group "titlecase/string"
        (test "\x01C5" (string-titlecase "\x01C5"))
        (test "\x01C5" (string-titlecase "\x01C4"))
        (test "Ss" (string-titlecase "\x00DF"))
        (test "Xi\x0307" (string-titlecase "x\x0130"))
        (test "\x1F88" (string-titlecase "\x1F80"))
        (test "\x1F88" (string-titlecase "\x1F88"))
        (test "Bar Baz" (string-titlecase "bAr baZ"))
        (test "Floo" (string-titlecase "floo"))
        (test "Floo" (string-titlecase "FLOO"))
        (test "Floo" (string-titlecase Floo))
        (test "Floo Bar" (string-titlecase "floo bar"))
        (test "Floo Bar" (string-titlecase "FLOO BAR"))
        (test "Floo Bar" (string-titlecase Floo-bar))
        (test Baffle (string-titlecase Baffle))
        (test Ljubljana (string-titlecase LJUBLJANA))
        (test Ljubljana (string-titlecase Ljubljana))
        (test Ljubljana (string-titlecase ljubljana)))
      (test-end))))
