See /usr/share/doc/debhelper/PROGRAMMING.md on general design of debhelper.
This follows that design.

For convenience of Python code, dhfortran/debhelper.py implements Python equivalents of any Perl debhelper routines we use.

The scripts are written in Python for ease of development and testing. The package provides:
  * dh_fortran_mod: Move Fortran-module files to per-compiler directories
  * dh_fortan_lib: Ditto for libraries, but also change SONAMES
  * dh_fortran_pkgconf: rewrite pkgconfig files to match the above
  * dh_fortran: overall builder script

See manual pages for each.

TODO:
  * What if buildsystem == meson, cmake, ecbuild ?
    --buildsystem=fortran means using fpm.
       automatically enables --with fortran
    --with fortran will use fpm if buildsystem is not set.
 * dh_fortran_lib:
    Install ar archives correctly with multifortran, keep_orig

 * For 0.65 release:
   _lib,_pkg,_cmake,_mod scripts have --buildsystem mode where they run without config file


Targets are called with FC, FCFLAGS, FMODDIR, FC_DEFAULT, FLIBDIR set as appropriate

Set 0.80 release as having full multifortran and cross-compilation support
 * With fpm 0.13+ for multiple builddirs; meson overrides

Set 1.0 as release to remove --flavor flags. Full deprecation warnings in 0.80

FPM Integration:
 * dh-fortran executes fpm where fpm.toml is present and buildsystem=fortran
 *  check fortran-fpm in environment
 *  fpm search plugin for Apt/dpkg integration (?)
    fpm will use / install modules if they exist in Debian; alert missing modules
-DONE

Multicompiler builds will be triggered by:
* Presence of FC_DEFAULT, FC_OPTIONAL in the environment
* presence of *.fortran-mod or *fortran-lib files in debian

ISSUES:
 * fpm only works with one builddirectory ./build
   This will be fixed in the next release


 --with=fortran needs to add most of the work (inject something into d/rules)
 because --buildsystem may point to eg ecbuild,meson

Multi-fortran decision process:
* DO a make -P | grep FC_DEFAULT, FC_OPTIONAL check. If they're defined in d/rules, then thats what sets their values
  store flags env in .debhelper/fc_env. len(FC_OPTIONAL)>=1 means multifortran build
* For the moment, FC_DEFAULT allows a single flavor
* Set BUILDDIR. TMPDIR. Will need a different TMPDIR for each of the other Fortran builds.
* for FC_DEFAULT, BUILDDIR=$(BUILDDIR), for all compilers define $(BUILDDIR)-$(FLAVOR) and for default its a  symlink to $(BUILDDIR)
* ditto $TMPDIR.
* 

dh_assistant which-build-system
{
   "build-directory": "obj-aarch64-linux-gnu",
   "build-system": "cmake+makefile",
   "buildpath": "obj-aarch64-linux-gnu",
   "dest-directory": null,
   "for-build-step": "configure",
   "parallel": 1,
   "source-directory": ".",
   "upstream-arguments": []
}

Pick build-directory, dest-directory from dh_assistant or equiv.

Check dh-fortrans' use of source,dest etc terms correct.

* Allow FC= to be a cross-compiler, deprecate --flavor in favour of use --fc and accept aliases, but use flavor internally
  for the "canonical"

Notes:
	Dropped get_flavor(), get_fc() in favour of get_fc_flavor() which does all checking.
	Use  FC as the external API, flavor as Internal, but we should track the FC for cross-compiling:
	when --fc = other-arch-gfortran-15 , flavor=gfortran-15, but we've lost the arch.
	How about flavor, arch = get_fc_flavor_arch() ?
	

Issue: what if binaries in a package use the pre-adjusted sonames?
       Best if we can set the SONAME pattern at build-time


FPM Integration
export FPM_FFLAGS="-I/usr/lib/aarch64-linux-gnu/fortran/gfortran-mod-16/ -I/usr/include -cpp"

