// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file inheritanceTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "inheritanceTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "inheritance.hpp"

#include "helpers/basic_inner_types.hpp"

using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_InnerStructureHelperChild_type_identifier(
        TypeIdentifierPair& type_ids_InnerStructureHelperChild)
{

    ReturnCode_t return_code_InnerStructureHelperChild {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InnerStructureHelperChild =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "InnerStructureHelperChild", type_ids_InnerStructureHelperChild);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerStructureHelperChild)
    {
        StructTypeFlag struct_flags_InnerStructureHelperChild = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_InnerStructureHelperChild =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "InnerStructureHelper", type_ids_InnerStructureHelperChild);

        if (return_code_InnerStructureHelperChild != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_InnerStructureHelper_type_identifier(type_ids_InnerStructureHelperChild);
        }
        QualifiedTypeName type_name_InnerStructureHelperChild = "InnerStructureHelperChild";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InnerStructureHelperChild;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InnerStructureHelperChild;
        CompleteTypeDetail detail_InnerStructureHelperChild = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InnerStructureHelperChild, ann_custom_InnerStructureHelperChild, type_name_InnerStructureHelperChild.to_string());
        CompleteStructHeader header_InnerStructureHelperChild;
        if (EK_COMPLETE == type_ids_InnerStructureHelperChild.type_identifier1()._d())
        {
            header_InnerStructureHelperChild = TypeObjectUtils::build_complete_struct_header(type_ids_InnerStructureHelperChild.type_identifier1(), detail_InnerStructureHelperChild);
        }
        else if (EK_COMPLETE == type_ids_InnerStructureHelperChild.type_identifier2()._d())
        {
            header_InnerStructureHelperChild = TypeObjectUtils::build_complete_struct_header(type_ids_InnerStructureHelperChild.type_identifier2(), detail_InnerStructureHelperChild);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InnerStructureHelperChild Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_InnerStructureHelperChild;
        {
            TypeIdentifierPair type_ids_var_child_longlong;
            ReturnCode_t return_code_var_child_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_child_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_var_child_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_child_longlong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_child_longlong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_child_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_child_longlong = 0x00000002;
            bool common_var_child_longlong_ec {false};
            CommonStructMember common_var_child_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_child_longlong, member_flags_var_child_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_child_longlong, common_var_child_longlong_ec))};
            if (!common_var_child_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_child_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_child_longlong = "var_child_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_child_longlong;
            ann_custom_InnerStructureHelperChild.reset();
            CompleteMemberDetail detail_var_child_longlong = TypeObjectUtils::build_complete_member_detail(name_var_child_longlong, member_ann_builtin_var_child_longlong, ann_custom_InnerStructureHelperChild);
            CompleteStructMember member_var_child_longlong = TypeObjectUtils::build_complete_struct_member(common_var_child_longlong, detail_var_child_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_InnerStructureHelperChild, member_var_child_longlong);
        }
        {
            TypeIdentifierPair type_ids_var_child_ulonglong;
            ReturnCode_t return_code_var_child_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_child_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_var_child_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_child_ulonglong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_child_ulonglong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_child_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_child_ulonglong = 0x00000003;
            bool common_var_child_ulonglong_ec {false};
            CommonStructMember common_var_child_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_child_ulonglong, member_flags_var_child_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_child_ulonglong, common_var_child_ulonglong_ec))};
            if (!common_var_child_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_child_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_child_ulonglong = "var_child_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_child_ulonglong;
            ann_custom_InnerStructureHelperChild.reset();
            CompleteMemberDetail detail_var_child_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_child_ulonglong, member_ann_builtin_var_child_ulonglong, ann_custom_InnerStructureHelperChild);
            CompleteStructMember member_var_child_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_child_ulonglong, detail_var_child_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_InnerStructureHelperChild, member_var_child_ulonglong);
        }
        CompleteStructType struct_type_InnerStructureHelperChild = TypeObjectUtils::build_complete_struct_type(struct_flags_InnerStructureHelperChild, header_InnerStructureHelperChild, member_seq_InnerStructureHelperChild);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_InnerStructureHelperChild, type_name_InnerStructureHelperChild.to_string(), type_ids_InnerStructureHelperChild))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InnerStructureHelperChild already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_InnerStructureHelperChildChild_type_identifier(
        TypeIdentifierPair& type_ids_InnerStructureHelperChildChild)
{

    ReturnCode_t return_code_InnerStructureHelperChildChild {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InnerStructureHelperChildChild =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "InnerStructureHelperChildChild", type_ids_InnerStructureHelperChildChild);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerStructureHelperChildChild)
    {
        StructTypeFlag struct_flags_InnerStructureHelperChildChild = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_InnerStructureHelperChildChild =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "InnerStructureHelperChild", type_ids_InnerStructureHelperChildChild);

        if (return_code_InnerStructureHelperChildChild != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_InnerStructureHelperChild_type_identifier(type_ids_InnerStructureHelperChildChild);
        }
        QualifiedTypeName type_name_InnerStructureHelperChildChild = "InnerStructureHelperChildChild";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InnerStructureHelperChildChild;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InnerStructureHelperChildChild;
        CompleteTypeDetail detail_InnerStructureHelperChildChild = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InnerStructureHelperChildChild, ann_custom_InnerStructureHelperChildChild, type_name_InnerStructureHelperChildChild.to_string());
        CompleteStructHeader header_InnerStructureHelperChildChild;
        if (EK_COMPLETE == type_ids_InnerStructureHelperChildChild.type_identifier1()._d())
        {
            header_InnerStructureHelperChildChild = TypeObjectUtils::build_complete_struct_header(type_ids_InnerStructureHelperChildChild.type_identifier1(), detail_InnerStructureHelperChildChild);
        }
        else if (EK_COMPLETE == type_ids_InnerStructureHelperChildChild.type_identifier2()._d())
        {
            header_InnerStructureHelperChildChild = TypeObjectUtils::build_complete_struct_header(type_ids_InnerStructureHelperChildChild.type_identifier2(), detail_InnerStructureHelperChildChild);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InnerStructureHelperChildChild Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_InnerStructureHelperChildChild;
        {
            TypeIdentifierPair type_ids_var_child_childlonglong2;
            ReturnCode_t return_code_var_child_childlonglong2 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_child_childlonglong2 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_var_child_childlonglong2);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_child_childlonglong2)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_child_childlonglong2 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_child_childlonglong2 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_child_childlonglong2 = 0x00000004;
            bool common_var_child_childlonglong2_ec {false};
            CommonStructMember common_var_child_childlonglong2 {TypeObjectUtils::build_common_struct_member(member_id_var_child_childlonglong2, member_flags_var_child_childlonglong2, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_child_childlonglong2, common_var_child_childlonglong2_ec))};
            if (!common_var_child_childlonglong2_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_child_childlonglong2 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_child_childlonglong2 = "var_child_childlonglong2";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_child_childlonglong2;
            ann_custom_InnerStructureHelperChildChild.reset();
            CompleteMemberDetail detail_var_child_childlonglong2 = TypeObjectUtils::build_complete_member_detail(name_var_child_childlonglong2, member_ann_builtin_var_child_childlonglong2, ann_custom_InnerStructureHelperChildChild);
            CompleteStructMember member_var_child_childlonglong2 = TypeObjectUtils::build_complete_struct_member(common_var_child_childlonglong2, detail_var_child_childlonglong2);
            TypeObjectUtils::add_complete_struct_member(member_seq_InnerStructureHelperChildChild, member_var_child_childlonglong2);
        }
        {
            TypeIdentifierPair type_ids_var_childchild_ulonglong2;
            ReturnCode_t return_code_var_childchild_ulonglong2 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_childchild_ulonglong2 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_var_childchild_ulonglong2);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_childchild_ulonglong2)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_childchild_ulonglong2 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_childchild_ulonglong2 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_childchild_ulonglong2 = 0x00000005;
            bool common_var_childchild_ulonglong2_ec {false};
            CommonStructMember common_var_childchild_ulonglong2 {TypeObjectUtils::build_common_struct_member(member_id_var_childchild_ulonglong2, member_flags_var_childchild_ulonglong2, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_childchild_ulonglong2, common_var_childchild_ulonglong2_ec))};
            if (!common_var_childchild_ulonglong2_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_childchild_ulonglong2 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_childchild_ulonglong2 = "var_childchild_ulonglong2";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_childchild_ulonglong2;
            ann_custom_InnerStructureHelperChildChild.reset();
            CompleteMemberDetail detail_var_childchild_ulonglong2 = TypeObjectUtils::build_complete_member_detail(name_var_childchild_ulonglong2, member_ann_builtin_var_childchild_ulonglong2, ann_custom_InnerStructureHelperChildChild);
            CompleteStructMember member_var_childchild_ulonglong2 = TypeObjectUtils::build_complete_struct_member(common_var_childchild_ulonglong2, detail_var_childchild_ulonglong2);
            TypeObjectUtils::add_complete_struct_member(member_seq_InnerStructureHelperChildChild, member_var_childchild_ulonglong2);
        }
        CompleteStructType struct_type_InnerStructureHelperChildChild = TypeObjectUtils::build_complete_struct_type(struct_flags_InnerStructureHelperChildChild, header_InnerStructureHelperChildChild, member_seq_InnerStructureHelperChildChild);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_InnerStructureHelperChildChild, type_name_InnerStructureHelperChildChild.to_string(), type_ids_InnerStructureHelperChildChild))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InnerStructureHelperChildChild already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_InnerStructureHelperEmptyChild_type_identifier(
        TypeIdentifierPair& type_ids_InnerStructureHelperEmptyChild)
{

    ReturnCode_t return_code_InnerStructureHelperEmptyChild {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InnerStructureHelperEmptyChild =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "InnerStructureHelperEmptyChild", type_ids_InnerStructureHelperEmptyChild);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerStructureHelperEmptyChild)
    {
        StructTypeFlag struct_flags_InnerStructureHelperEmptyChild = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_InnerStructureHelperEmptyChild =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "InnerStructureHelper", type_ids_InnerStructureHelperEmptyChild);

        if (return_code_InnerStructureHelperEmptyChild != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_InnerStructureHelper_type_identifier(type_ids_InnerStructureHelperEmptyChild);
        }
        QualifiedTypeName type_name_InnerStructureHelperEmptyChild = "InnerStructureHelperEmptyChild";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InnerStructureHelperEmptyChild;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InnerStructureHelperEmptyChild;
        CompleteTypeDetail detail_InnerStructureHelperEmptyChild = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InnerStructureHelperEmptyChild, ann_custom_InnerStructureHelperEmptyChild, type_name_InnerStructureHelperEmptyChild.to_string());
        CompleteStructHeader header_InnerStructureHelperEmptyChild;
        if (EK_COMPLETE == type_ids_InnerStructureHelperEmptyChild.type_identifier1()._d())
        {
            header_InnerStructureHelperEmptyChild = TypeObjectUtils::build_complete_struct_header(type_ids_InnerStructureHelperEmptyChild.type_identifier1(), detail_InnerStructureHelperEmptyChild);
        }
        else if (EK_COMPLETE == type_ids_InnerStructureHelperEmptyChild.type_identifier2()._d())
        {
            header_InnerStructureHelperEmptyChild = TypeObjectUtils::build_complete_struct_header(type_ids_InnerStructureHelperEmptyChild.type_identifier2(), detail_InnerStructureHelperEmptyChild);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InnerStructureHelperEmptyChild Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_InnerStructureHelperEmptyChild;
        CompleteStructType struct_type_InnerStructureHelperEmptyChild = TypeObjectUtils::build_complete_struct_type(struct_flags_InnerStructureHelperEmptyChild, header_InnerStructureHelperEmptyChild, member_seq_InnerStructureHelperEmptyChild);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_InnerStructureHelperEmptyChild, type_name_InnerStructureHelperEmptyChild.to_string(), type_ids_InnerStructureHelperEmptyChild))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InnerStructureHelperEmptyChild already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_InnerStructureHelperEmptyChildChild_type_identifier(
        TypeIdentifierPair& type_ids_InnerStructureHelperEmptyChildChild)
{

    ReturnCode_t return_code_InnerStructureHelperEmptyChildChild {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InnerStructureHelperEmptyChildChild =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "InnerStructureHelperEmptyChildChild", type_ids_InnerStructureHelperEmptyChildChild);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerStructureHelperEmptyChildChild)
    {
        StructTypeFlag struct_flags_InnerStructureHelperEmptyChildChild = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_InnerStructureHelperEmptyChildChild =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "InnerStructureHelperEmptyChild", type_ids_InnerStructureHelperEmptyChildChild);

        if (return_code_InnerStructureHelperEmptyChildChild != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_InnerStructureHelperEmptyChild_type_identifier(type_ids_InnerStructureHelperEmptyChildChild);
        }
        QualifiedTypeName type_name_InnerStructureHelperEmptyChildChild = "InnerStructureHelperEmptyChildChild";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InnerStructureHelperEmptyChildChild;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InnerStructureHelperEmptyChildChild;
        CompleteTypeDetail detail_InnerStructureHelperEmptyChildChild = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InnerStructureHelperEmptyChildChild, ann_custom_InnerStructureHelperEmptyChildChild, type_name_InnerStructureHelperEmptyChildChild.to_string());
        CompleteStructHeader header_InnerStructureHelperEmptyChildChild;
        if (EK_COMPLETE == type_ids_InnerStructureHelperEmptyChildChild.type_identifier1()._d())
        {
            header_InnerStructureHelperEmptyChildChild = TypeObjectUtils::build_complete_struct_header(type_ids_InnerStructureHelperEmptyChildChild.type_identifier1(), detail_InnerStructureHelperEmptyChildChild);
        }
        else if (EK_COMPLETE == type_ids_InnerStructureHelperEmptyChildChild.type_identifier2()._d())
        {
            header_InnerStructureHelperEmptyChildChild = TypeObjectUtils::build_complete_struct_header(type_ids_InnerStructureHelperEmptyChildChild.type_identifier2(), detail_InnerStructureHelperEmptyChildChild);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InnerStructureHelperEmptyChildChild Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_InnerStructureHelperEmptyChildChild;
        {
            TypeIdentifierPair type_ids_var_char;
            ReturnCode_t return_code_var_char {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_var_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_char)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_char = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_char = 0x00000002;
            bool common_var_char_ec {false};
            CommonStructMember common_var_char {TypeObjectUtils::build_common_struct_member(member_id_var_char, member_flags_var_char, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_char, common_var_char_ec))};
            if (!common_var_char_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_char member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_char = "var_char";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_char;
            ann_custom_InnerStructureHelperEmptyChildChild.reset();
            CompleteMemberDetail detail_var_char = TypeObjectUtils::build_complete_member_detail(name_var_char, member_ann_builtin_var_char, ann_custom_InnerStructureHelperEmptyChildChild);
            CompleteStructMember member_var_char = TypeObjectUtils::build_complete_struct_member(common_var_char, detail_var_char);
            TypeObjectUtils::add_complete_struct_member(member_seq_InnerStructureHelperEmptyChildChild, member_var_char);
        }
        CompleteStructType struct_type_InnerStructureHelperEmptyChildChild = TypeObjectUtils::build_complete_struct_type(struct_flags_InnerStructureHelperEmptyChildChild, header_InnerStructureHelperEmptyChildChild, member_seq_InnerStructureHelperEmptyChildChild);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_InnerStructureHelperEmptyChildChild, type_name_InnerStructureHelperEmptyChildChild.to_string(), type_ids_InnerStructureHelperEmptyChildChild))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InnerStructureHelperEmptyChildChild already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_InnerEmptyStructureHelperChild_type_identifier(
        TypeIdentifierPair& type_ids_InnerEmptyStructureHelperChild)
{

    ReturnCode_t return_code_InnerEmptyStructureHelperChild {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InnerEmptyStructureHelperChild =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "InnerEmptyStructureHelperChild", type_ids_InnerEmptyStructureHelperChild);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerEmptyStructureHelperChild)
    {
        StructTypeFlag struct_flags_InnerEmptyStructureHelperChild = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_InnerEmptyStructureHelperChild =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "InnerEmptyStructureHelper", type_ids_InnerEmptyStructureHelperChild);

        if (return_code_InnerEmptyStructureHelperChild != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_InnerEmptyStructureHelper_type_identifier(type_ids_InnerEmptyStructureHelperChild);
        }
        QualifiedTypeName type_name_InnerEmptyStructureHelperChild = "InnerEmptyStructureHelperChild";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InnerEmptyStructureHelperChild;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InnerEmptyStructureHelperChild;
        CompleteTypeDetail detail_InnerEmptyStructureHelperChild = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InnerEmptyStructureHelperChild, ann_custom_InnerEmptyStructureHelperChild, type_name_InnerEmptyStructureHelperChild.to_string());
        CompleteStructHeader header_InnerEmptyStructureHelperChild;
        if (EK_COMPLETE == type_ids_InnerEmptyStructureHelperChild.type_identifier1()._d())
        {
            header_InnerEmptyStructureHelperChild = TypeObjectUtils::build_complete_struct_header(type_ids_InnerEmptyStructureHelperChild.type_identifier1(), detail_InnerEmptyStructureHelperChild);
        }
        else if (EK_COMPLETE == type_ids_InnerEmptyStructureHelperChild.type_identifier2()._d())
        {
            header_InnerEmptyStructureHelperChild = TypeObjectUtils::build_complete_struct_header(type_ids_InnerEmptyStructureHelperChild.type_identifier2(), detail_InnerEmptyStructureHelperChild);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InnerEmptyStructureHelperChild Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_InnerEmptyStructureHelperChild;
        {
            TypeIdentifierPair type_ids_var_child_longlong;
            ReturnCode_t return_code_var_child_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_child_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_var_child_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_child_longlong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_child_longlong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_child_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_child_longlong = 0x00000000;
            bool common_var_child_longlong_ec {false};
            CommonStructMember common_var_child_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_child_longlong, member_flags_var_child_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_child_longlong, common_var_child_longlong_ec))};
            if (!common_var_child_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_child_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_child_longlong = "var_child_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_child_longlong;
            ann_custom_InnerEmptyStructureHelperChild.reset();
            CompleteMemberDetail detail_var_child_longlong = TypeObjectUtils::build_complete_member_detail(name_var_child_longlong, member_ann_builtin_var_child_longlong, ann_custom_InnerEmptyStructureHelperChild);
            CompleteStructMember member_var_child_longlong = TypeObjectUtils::build_complete_struct_member(common_var_child_longlong, detail_var_child_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_InnerEmptyStructureHelperChild, member_var_child_longlong);
        }
        {
            TypeIdentifierPair type_ids_var_child_ulonglong;
            ReturnCode_t return_code_var_child_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_child_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_var_child_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_child_ulonglong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_child_ulonglong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_child_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_child_ulonglong = 0x00000001;
            bool common_var_child_ulonglong_ec {false};
            CommonStructMember common_var_child_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_child_ulonglong, member_flags_var_child_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_child_ulonglong, common_var_child_ulonglong_ec))};
            if (!common_var_child_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_child_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_child_ulonglong = "var_child_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_child_ulonglong;
            ann_custom_InnerEmptyStructureHelperChild.reset();
            CompleteMemberDetail detail_var_child_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_child_ulonglong, member_ann_builtin_var_child_ulonglong, ann_custom_InnerEmptyStructureHelperChild);
            CompleteStructMember member_var_child_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_child_ulonglong, detail_var_child_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_InnerEmptyStructureHelperChild, member_var_child_ulonglong);
        }
        CompleteStructType struct_type_InnerEmptyStructureHelperChild = TypeObjectUtils::build_complete_struct_type(struct_flags_InnerEmptyStructureHelperChild, header_InnerEmptyStructureHelperChild, member_seq_InnerEmptyStructureHelperChild);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_InnerEmptyStructureHelperChild, type_name_InnerEmptyStructureHelperChild.to_string(), type_ids_InnerEmptyStructureHelperChild))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "InnerEmptyStructureHelperChild already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructAliasInheritanceStruct_type_identifier(
        TypeIdentifierPair& type_ids_StructAliasInheritanceStruct)
{

    ReturnCode_t return_code_StructAliasInheritanceStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructAliasInheritanceStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructAliasInheritanceStruct", type_ids_StructAliasInheritanceStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructAliasInheritanceStruct)
    {
        StructTypeFlag struct_flags_StructAliasInheritanceStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_StructAliasInheritanceStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "inner_structure_helper_alias", type_ids_StructAliasInheritanceStruct);

        if (return_code_StructAliasInheritanceStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_inner_structure_helper_alias_type_identifier(type_ids_StructAliasInheritanceStruct);
        }
        QualifiedTypeName type_name_StructAliasInheritanceStruct = "StructAliasInheritanceStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructAliasInheritanceStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructAliasInheritanceStruct;
        CompleteTypeDetail detail_StructAliasInheritanceStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructAliasInheritanceStruct, ann_custom_StructAliasInheritanceStruct, type_name_StructAliasInheritanceStruct.to_string());
        CompleteStructHeader header_StructAliasInheritanceStruct;
        if (EK_COMPLETE == type_ids_StructAliasInheritanceStruct.type_identifier1()._d())
        {
            header_StructAliasInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_StructAliasInheritanceStruct.type_identifier1(), detail_StructAliasInheritanceStruct);
        }
        else if (EK_COMPLETE == type_ids_StructAliasInheritanceStruct.type_identifier2()._d())
        {
            header_StructAliasInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_StructAliasInheritanceStruct.type_identifier2(), detail_StructAliasInheritanceStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructAliasInheritanceStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_StructAliasInheritanceStruct;
        {
            TypeIdentifierPair type_ids_new_member;
            ReturnCode_t return_code_new_member {eprosima::fastdds::dds::RETCODE_OK};
            return_code_new_member =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_new_member);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_new_member)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "new_member Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_new_member = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_new_member = 0x00000002;
            bool common_new_member_ec {false};
            CommonStructMember common_new_member {TypeObjectUtils::build_common_struct_member(member_id_new_member, member_flags_new_member, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_new_member, common_new_member_ec))};
            if (!common_new_member_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure new_member member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_new_member = "new_member";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_new_member;
            ann_custom_StructAliasInheritanceStruct.reset();
            CompleteMemberDetail detail_new_member = TypeObjectUtils::build_complete_member_detail(name_new_member, member_ann_builtin_new_member, ann_custom_StructAliasInheritanceStruct);
            CompleteStructMember member_new_member = TypeObjectUtils::build_complete_struct_member(common_new_member, detail_new_member);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructAliasInheritanceStruct, member_new_member);
        }
        CompleteStructType struct_type_StructAliasInheritanceStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_StructAliasInheritanceStruct, header_StructAliasInheritanceStruct, member_seq_StructAliasInheritanceStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructAliasInheritanceStruct, type_name_StructAliasInheritanceStruct.to_string(), type_ids_StructAliasInheritanceStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructAliasInheritanceStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructuresInheritanceStruct_type_identifier(
        TypeIdentifierPair& type_ids_StructuresInheritanceStruct)
{

    ReturnCode_t return_code_StructuresInheritanceStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructuresInheritanceStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructuresInheritanceStruct", type_ids_StructuresInheritanceStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructuresInheritanceStruct)
    {
        StructTypeFlag struct_flags_StructuresInheritanceStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructuresInheritanceStruct = "StructuresInheritanceStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructuresInheritanceStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructuresInheritanceStruct;
        CompleteTypeDetail detail_StructuresInheritanceStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructuresInheritanceStruct, ann_custom_StructuresInheritanceStruct, type_name_StructuresInheritanceStruct.to_string());
        CompleteStructHeader header_StructuresInheritanceStruct;
        header_StructuresInheritanceStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructuresInheritanceStruct);
        CompleteStructMemberSeq member_seq_StructuresInheritanceStruct;
        {
            TypeIdentifierPair type_ids_var_InnerStructureHelperChild;
            ReturnCode_t return_code_var_InnerStructureHelperChild {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_InnerStructureHelperChild =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructureHelperChild", type_ids_var_InnerStructureHelperChild);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_InnerStructureHelperChild)
            {
            ::register_InnerStructureHelperChild_type_identifier(type_ids_var_InnerStructureHelperChild);
            }
            StructMemberFlag member_flags_var_InnerStructureHelperChild = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_InnerStructureHelperChild = 0x00000000;
            bool common_var_InnerStructureHelperChild_ec {false};
            CommonStructMember common_var_InnerStructureHelperChild {TypeObjectUtils::build_common_struct_member(member_id_var_InnerStructureHelperChild, member_flags_var_InnerStructureHelperChild, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_InnerStructureHelperChild, common_var_InnerStructureHelperChild_ec))};
            if (!common_var_InnerStructureHelperChild_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_InnerStructureHelperChild member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_InnerStructureHelperChild = "var_InnerStructureHelperChild";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_InnerStructureHelperChild;
            ann_custom_StructuresInheritanceStruct.reset();
            CompleteMemberDetail detail_var_InnerStructureHelperChild = TypeObjectUtils::build_complete_member_detail(name_var_InnerStructureHelperChild, member_ann_builtin_var_InnerStructureHelperChild, ann_custom_StructuresInheritanceStruct);
            CompleteStructMember member_var_InnerStructureHelperChild = TypeObjectUtils::build_complete_struct_member(common_var_InnerStructureHelperChild, detail_var_InnerStructureHelperChild);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructuresInheritanceStruct, member_var_InnerStructureHelperChild);
        }
        {
            TypeIdentifierPair type_ids_var_InnerStructureHelperChildChild;
            ReturnCode_t return_code_var_InnerStructureHelperChildChild {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_InnerStructureHelperChildChild =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructureHelperChildChild", type_ids_var_InnerStructureHelperChildChild);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_InnerStructureHelperChildChild)
            {
            ::register_InnerStructureHelperChildChild_type_identifier(type_ids_var_InnerStructureHelperChildChild);
            }
            StructMemberFlag member_flags_var_InnerStructureHelperChildChild = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_InnerStructureHelperChildChild = 0x00000001;
            bool common_var_InnerStructureHelperChildChild_ec {false};
            CommonStructMember common_var_InnerStructureHelperChildChild {TypeObjectUtils::build_common_struct_member(member_id_var_InnerStructureHelperChildChild, member_flags_var_InnerStructureHelperChildChild, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_InnerStructureHelperChildChild, common_var_InnerStructureHelperChildChild_ec))};
            if (!common_var_InnerStructureHelperChildChild_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_InnerStructureHelperChildChild member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_InnerStructureHelperChildChild = "var_InnerStructureHelperChildChild";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_InnerStructureHelperChildChild;
            ann_custom_StructuresInheritanceStruct.reset();
            CompleteMemberDetail detail_var_InnerStructureHelperChildChild = TypeObjectUtils::build_complete_member_detail(name_var_InnerStructureHelperChildChild, member_ann_builtin_var_InnerStructureHelperChildChild, ann_custom_StructuresInheritanceStruct);
            CompleteStructMember member_var_InnerStructureHelperChildChild = TypeObjectUtils::build_complete_struct_member(common_var_InnerStructureHelperChildChild, detail_var_InnerStructureHelperChildChild);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructuresInheritanceStruct, member_var_InnerStructureHelperChildChild);
        }
        {
            TypeIdentifierPair type_ids_var_InnerStructureHelperEmptyChild;
            ReturnCode_t return_code_var_InnerStructureHelperEmptyChild {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_InnerStructureHelperEmptyChild =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructureHelperEmptyChild", type_ids_var_InnerStructureHelperEmptyChild);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_InnerStructureHelperEmptyChild)
            {
            ::register_InnerStructureHelperEmptyChild_type_identifier(type_ids_var_InnerStructureHelperEmptyChild);
            }
            StructMemberFlag member_flags_var_InnerStructureHelperEmptyChild = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_InnerStructureHelperEmptyChild = 0x00000002;
            bool common_var_InnerStructureHelperEmptyChild_ec {false};
            CommonStructMember common_var_InnerStructureHelperEmptyChild {TypeObjectUtils::build_common_struct_member(member_id_var_InnerStructureHelperEmptyChild, member_flags_var_InnerStructureHelperEmptyChild, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_InnerStructureHelperEmptyChild, common_var_InnerStructureHelperEmptyChild_ec))};
            if (!common_var_InnerStructureHelperEmptyChild_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_InnerStructureHelperEmptyChild member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_InnerStructureHelperEmptyChild = "var_InnerStructureHelperEmptyChild";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_InnerStructureHelperEmptyChild;
            ann_custom_StructuresInheritanceStruct.reset();
            CompleteMemberDetail detail_var_InnerStructureHelperEmptyChild = TypeObjectUtils::build_complete_member_detail(name_var_InnerStructureHelperEmptyChild, member_ann_builtin_var_InnerStructureHelperEmptyChild, ann_custom_StructuresInheritanceStruct);
            CompleteStructMember member_var_InnerStructureHelperEmptyChild = TypeObjectUtils::build_complete_struct_member(common_var_InnerStructureHelperEmptyChild, detail_var_InnerStructureHelperEmptyChild);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructuresInheritanceStruct, member_var_InnerStructureHelperEmptyChild);
        }
        {
            TypeIdentifierPair type_ids_var_InnerStructureHelperEmptyChildChild;
            ReturnCode_t return_code_var_InnerStructureHelperEmptyChildChild {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_InnerStructureHelperEmptyChildChild =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerStructureHelperEmptyChildChild", type_ids_var_InnerStructureHelperEmptyChildChild);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_InnerStructureHelperEmptyChildChild)
            {
            ::register_InnerStructureHelperEmptyChildChild_type_identifier(type_ids_var_InnerStructureHelperEmptyChildChild);
            }
            StructMemberFlag member_flags_var_InnerStructureHelperEmptyChildChild = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_InnerStructureHelperEmptyChildChild = 0x00000003;
            bool common_var_InnerStructureHelperEmptyChildChild_ec {false};
            CommonStructMember common_var_InnerStructureHelperEmptyChildChild {TypeObjectUtils::build_common_struct_member(member_id_var_InnerStructureHelperEmptyChildChild, member_flags_var_InnerStructureHelperEmptyChildChild, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_InnerStructureHelperEmptyChildChild, common_var_InnerStructureHelperEmptyChildChild_ec))};
            if (!common_var_InnerStructureHelperEmptyChildChild_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_InnerStructureHelperEmptyChildChild member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_InnerStructureHelperEmptyChildChild = "var_InnerStructureHelperEmptyChildChild";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_InnerStructureHelperEmptyChildChild;
            ann_custom_StructuresInheritanceStruct.reset();
            CompleteMemberDetail detail_var_InnerStructureHelperEmptyChildChild = TypeObjectUtils::build_complete_member_detail(name_var_InnerStructureHelperEmptyChildChild, member_ann_builtin_var_InnerStructureHelperEmptyChildChild, ann_custom_StructuresInheritanceStruct);
            CompleteStructMember member_var_InnerStructureHelperEmptyChildChild = TypeObjectUtils::build_complete_struct_member(common_var_InnerStructureHelperEmptyChildChild, detail_var_InnerStructureHelperEmptyChildChild);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructuresInheritanceStruct, member_var_InnerStructureHelperEmptyChildChild);
        }
        {
            TypeIdentifierPair type_ids_var_InnerEmptyStructureHelperChild;
            ReturnCode_t return_code_var_InnerEmptyStructureHelperChild {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_InnerEmptyStructureHelperChild =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerEmptyStructureHelperChild", type_ids_var_InnerEmptyStructureHelperChild);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_InnerEmptyStructureHelperChild)
            {
            ::register_InnerEmptyStructureHelperChild_type_identifier(type_ids_var_InnerEmptyStructureHelperChild);
            }
            StructMemberFlag member_flags_var_InnerEmptyStructureHelperChild = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_InnerEmptyStructureHelperChild = 0x00000004;
            bool common_var_InnerEmptyStructureHelperChild_ec {false};
            CommonStructMember common_var_InnerEmptyStructureHelperChild {TypeObjectUtils::build_common_struct_member(member_id_var_InnerEmptyStructureHelperChild, member_flags_var_InnerEmptyStructureHelperChild, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_InnerEmptyStructureHelperChild, common_var_InnerEmptyStructureHelperChild_ec))};
            if (!common_var_InnerEmptyStructureHelperChild_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_InnerEmptyStructureHelperChild member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_InnerEmptyStructureHelperChild = "var_InnerEmptyStructureHelperChild";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_InnerEmptyStructureHelperChild;
            ann_custom_StructuresInheritanceStruct.reset();
            CompleteMemberDetail detail_var_InnerEmptyStructureHelperChild = TypeObjectUtils::build_complete_member_detail(name_var_InnerEmptyStructureHelperChild, member_ann_builtin_var_InnerEmptyStructureHelperChild, ann_custom_StructuresInheritanceStruct);
            CompleteStructMember member_var_InnerEmptyStructureHelperChild = TypeObjectUtils::build_complete_struct_member(common_var_InnerEmptyStructureHelperChild, detail_var_InnerEmptyStructureHelperChild);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructuresInheritanceStruct, member_var_InnerEmptyStructureHelperChild);
        }
        {
            TypeIdentifierPair type_ids_var_StructAliasInheritanceStruct;
            ReturnCode_t return_code_var_StructAliasInheritanceStruct {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_StructAliasInheritanceStruct =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructAliasInheritanceStruct", type_ids_var_StructAliasInheritanceStruct);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_StructAliasInheritanceStruct)
            {
            ::register_StructAliasInheritanceStruct_type_identifier(type_ids_var_StructAliasInheritanceStruct);
            }
            StructMemberFlag member_flags_var_StructAliasInheritanceStruct = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_StructAliasInheritanceStruct = 0x00000005;
            bool common_var_StructAliasInheritanceStruct_ec {false};
            CommonStructMember common_var_StructAliasInheritanceStruct {TypeObjectUtils::build_common_struct_member(member_id_var_StructAliasInheritanceStruct, member_flags_var_StructAliasInheritanceStruct, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_StructAliasInheritanceStruct, common_var_StructAliasInheritanceStruct_ec))};
            if (!common_var_StructAliasInheritanceStruct_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_StructAliasInheritanceStruct member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_StructAliasInheritanceStruct = "var_StructAliasInheritanceStruct";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_StructAliasInheritanceStruct;
            ann_custom_StructuresInheritanceStruct.reset();
            CompleteMemberDetail detail_var_StructAliasInheritanceStruct = TypeObjectUtils::build_complete_member_detail(name_var_StructAliasInheritanceStruct, member_ann_builtin_var_StructAliasInheritanceStruct, ann_custom_StructuresInheritanceStruct);
            CompleteStructMember member_var_StructAliasInheritanceStruct = TypeObjectUtils::build_complete_struct_member(common_var_StructAliasInheritanceStruct, detail_var_StructAliasInheritanceStruct);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructuresInheritanceStruct, member_var_StructAliasInheritanceStruct);
        }
        CompleteStructType struct_type_StructuresInheritanceStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_StructuresInheritanceStruct, header_StructuresInheritanceStruct, member_seq_StructuresInheritanceStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructuresInheritanceStruct, type_name_StructuresInheritanceStruct.to_string(), type_ids_StructuresInheritanceStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructuresInheritanceStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
void register_InnerBitsetHelperChild_type_identifier(
        TypeIdentifierPair& type_ids_InnerBitsetHelperChild)
{
    ReturnCode_t return_code_InnerBitsetHelperChild {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InnerBitsetHelperChild =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "InnerBitsetHelperChild", type_ids_InnerBitsetHelperChild);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerBitsetHelperChild)
    {
        BitsetTypeFlag bitset_flags_InnerBitsetHelperChild = 0;
        QualifiedTypeName type_name_InnerBitsetHelperChild = "InnerBitsetHelperChild";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InnerBitsetHelperChild;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InnerBitsetHelperChild;
        CompleteTypeDetail detail_InnerBitsetHelperChild = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InnerBitsetHelperChild, ann_custom_InnerBitsetHelperChild, type_name_InnerBitsetHelperChild.to_string());
        CompleteBitsetHeader header_InnerBitsetHelperChild = TypeObjectUtils::build_complete_bitset_header(detail_InnerBitsetHelperChild);
        CompleteBitfieldSeq field_seq_InnerBitsetHelperChild;
        {
            uint16_t position_a = 0;
            BitsetMemberFlag flags_a = 0;
            uint8_t bitcount_a = 3;
            TypeKind holder_type_a = TK_UINT8;
            CommonBitfield common_a = TypeObjectUtils::build_common_bitfield(position_a, flags_a, bitcount_a, holder_type_a);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_a;
            ann_custom_InnerBitsetHelperChild.reset();
            MemberName name_a = "a";
            CompleteMemberDetail detail_a = TypeObjectUtils::build_complete_member_detail(name_a, member_ann_builtin_a, ann_custom_InnerBitsetHelperChild);
            CompleteBitfield bitfield_a = TypeObjectUtils::build_complete_bitfield(common_a, detail_a);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerBitsetHelperChild, bitfield_a);
        }
        {
            uint16_t position_b = 3;
            BitsetMemberFlag flags_b = 0;
            uint8_t bitcount_b = 1;
            TypeKind holder_type_b = TK_BOOLEAN;
            CommonBitfield common_b = TypeObjectUtils::build_common_bitfield(position_b, flags_b, bitcount_b, holder_type_b);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_b;
            ann_custom_InnerBitsetHelperChild.reset();
            MemberName name_b = "b";
            CompleteMemberDetail detail_b = TypeObjectUtils::build_complete_member_detail(name_b, member_ann_builtin_b, ann_custom_InnerBitsetHelperChild);
            CompleteBitfield bitfield_b = TypeObjectUtils::build_complete_bitfield(common_b, detail_b);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerBitsetHelperChild, bitfield_b);
        }
        {
            uint16_t position_c = 8;
            BitsetMemberFlag flags_c = 0;
            uint8_t bitcount_c = 10;
            TypeKind holder_type_c = TK_UINT16;
            CommonBitfield common_c = TypeObjectUtils::build_common_bitfield(position_c, flags_c, bitcount_c, holder_type_c);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_c;
            ann_custom_InnerBitsetHelperChild.reset();
            MemberName name_c = "c";
            CompleteMemberDetail detail_c = TypeObjectUtils::build_complete_member_detail(name_c, member_ann_builtin_c, ann_custom_InnerBitsetHelperChild);
            CompleteBitfield bitfield_c = TypeObjectUtils::build_complete_bitfield(common_c, detail_c);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerBitsetHelperChild, bitfield_c);
        }
        {
            uint16_t position_d = 21;
            BitsetMemberFlag flags_d = 0;
            uint8_t bitcount_d = 12;
            TypeKind holder_type_d = TK_INT16;
            CommonBitfield common_d = TypeObjectUtils::build_common_bitfield(position_d, flags_d, bitcount_d, holder_type_d);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_d;
            ann_custom_InnerBitsetHelperChild.reset();
            MemberName name_d = "d";
            CompleteMemberDetail detail_d = TypeObjectUtils::build_complete_member_detail(name_d, member_ann_builtin_d, ann_custom_InnerBitsetHelperChild);
            CompleteBitfield bitfield_d = TypeObjectUtils::build_complete_bitfield(common_d, detail_d);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerBitsetHelperChild, bitfield_d);
        }
        {
            uint16_t position_child_w = 33;
            BitsetMemberFlag flags_child_w = 0;
            uint8_t bitcount_child_w = 17;
            TypeKind holder_type_child_w = TK_UINT32;
            CommonBitfield common_child_w = TypeObjectUtils::build_common_bitfield(position_child_w, flags_child_w, bitcount_child_w, holder_type_child_w);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_child_w;
            ann_custom_InnerBitsetHelperChild.reset();
            MemberName name_child_w = "child_w";
            CompleteMemberDetail detail_child_w = TypeObjectUtils::build_complete_member_detail(name_child_w, member_ann_builtin_child_w, ann_custom_InnerBitsetHelperChild);
            CompleteBitfield bitfield_child_w = TypeObjectUtils::build_complete_bitfield(common_child_w, detail_child_w);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerBitsetHelperChild, bitfield_child_w);
        }
        CompleteBitsetType bitset_type_InnerBitsetHelperChild = TypeObjectUtils::build_complete_bitset_type(bitset_flags_InnerBitsetHelperChild, header_InnerBitsetHelperChild, field_seq_InnerBitsetHelperChild);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_bitset_type_object(bitset_type_InnerBitsetHelperChild,
                    type_name_InnerBitsetHelperChild.to_string(), type_ids_InnerBitsetHelperChild))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "InnerBitsetHelperChild already registered in TypeObjectRegistry for a different type.");
        }
    }
}void register_InnerBitsetHelperChildChild_type_identifier(
        TypeIdentifierPair& type_ids_InnerBitsetHelperChildChild)
{
    ReturnCode_t return_code_InnerBitsetHelperChildChild {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InnerBitsetHelperChildChild =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "InnerBitsetHelperChildChild", type_ids_InnerBitsetHelperChildChild);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerBitsetHelperChildChild)
    {
        BitsetTypeFlag bitset_flags_InnerBitsetHelperChildChild = 0;
        QualifiedTypeName type_name_InnerBitsetHelperChildChild = "InnerBitsetHelperChildChild";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InnerBitsetHelperChildChild;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InnerBitsetHelperChildChild;
        CompleteTypeDetail detail_InnerBitsetHelperChildChild = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InnerBitsetHelperChildChild, ann_custom_InnerBitsetHelperChildChild, type_name_InnerBitsetHelperChildChild.to_string());
        CompleteBitsetHeader header_InnerBitsetHelperChildChild = TypeObjectUtils::build_complete_bitset_header(detail_InnerBitsetHelperChildChild);
        CompleteBitfieldSeq field_seq_InnerBitsetHelperChildChild;
        {
            uint16_t position_a = 0;
            BitsetMemberFlag flags_a = 0;
            uint8_t bitcount_a = 3;
            TypeKind holder_type_a = TK_UINT8;
            CommonBitfield common_a = TypeObjectUtils::build_common_bitfield(position_a, flags_a, bitcount_a, holder_type_a);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_a;
            ann_custom_InnerBitsetHelperChildChild.reset();
            MemberName name_a = "a";
            CompleteMemberDetail detail_a = TypeObjectUtils::build_complete_member_detail(name_a, member_ann_builtin_a, ann_custom_InnerBitsetHelperChildChild);
            CompleteBitfield bitfield_a = TypeObjectUtils::build_complete_bitfield(common_a, detail_a);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerBitsetHelperChildChild, bitfield_a);
        }
        {
            uint16_t position_b = 3;
            BitsetMemberFlag flags_b = 0;
            uint8_t bitcount_b = 1;
            TypeKind holder_type_b = TK_BOOLEAN;
            CommonBitfield common_b = TypeObjectUtils::build_common_bitfield(position_b, flags_b, bitcount_b, holder_type_b);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_b;
            ann_custom_InnerBitsetHelperChildChild.reset();
            MemberName name_b = "b";
            CompleteMemberDetail detail_b = TypeObjectUtils::build_complete_member_detail(name_b, member_ann_builtin_b, ann_custom_InnerBitsetHelperChildChild);
            CompleteBitfield bitfield_b = TypeObjectUtils::build_complete_bitfield(common_b, detail_b);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerBitsetHelperChildChild, bitfield_b);
        }
        {
            uint16_t position_c = 8;
            BitsetMemberFlag flags_c = 0;
            uint8_t bitcount_c = 10;
            TypeKind holder_type_c = TK_UINT16;
            CommonBitfield common_c = TypeObjectUtils::build_common_bitfield(position_c, flags_c, bitcount_c, holder_type_c);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_c;
            ann_custom_InnerBitsetHelperChildChild.reset();
            MemberName name_c = "c";
            CompleteMemberDetail detail_c = TypeObjectUtils::build_complete_member_detail(name_c, member_ann_builtin_c, ann_custom_InnerBitsetHelperChildChild);
            CompleteBitfield bitfield_c = TypeObjectUtils::build_complete_bitfield(common_c, detail_c);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerBitsetHelperChildChild, bitfield_c);
        }
        {
            uint16_t position_d = 21;
            BitsetMemberFlag flags_d = 0;
            uint8_t bitcount_d = 12;
            TypeKind holder_type_d = TK_INT16;
            CommonBitfield common_d = TypeObjectUtils::build_common_bitfield(position_d, flags_d, bitcount_d, holder_type_d);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_d;
            ann_custom_InnerBitsetHelperChildChild.reset();
            MemberName name_d = "d";
            CompleteMemberDetail detail_d = TypeObjectUtils::build_complete_member_detail(name_d, member_ann_builtin_d, ann_custom_InnerBitsetHelperChildChild);
            CompleteBitfield bitfield_d = TypeObjectUtils::build_complete_bitfield(common_d, detail_d);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerBitsetHelperChildChild, bitfield_d);
        }
        {
            uint16_t position_child_w = 33;
            BitsetMemberFlag flags_child_w = 0;
            uint8_t bitcount_child_w = 17;
            TypeKind holder_type_child_w = TK_UINT32;
            CommonBitfield common_child_w = TypeObjectUtils::build_common_bitfield(position_child_w, flags_child_w, bitcount_child_w, holder_type_child_w);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_child_w;
            ann_custom_InnerBitsetHelperChildChild.reset();
            MemberName name_child_w = "child_w";
            CompleteMemberDetail detail_child_w = TypeObjectUtils::build_complete_member_detail(name_child_w, member_ann_builtin_child_w, ann_custom_InnerBitsetHelperChildChild);
            CompleteBitfield bitfield_child_w = TypeObjectUtils::build_complete_bitfield(common_child_w, detail_child_w);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerBitsetHelperChildChild, bitfield_child_w);
        }
        {
            uint16_t position_childchild_z = 50;
            BitsetMemberFlag flags_childchild_z = 0;
            uint8_t bitcount_childchild_z = 14;
            TypeKind holder_type_childchild_z = TK_UINT16;
            CommonBitfield common_childchild_z = TypeObjectUtils::build_common_bitfield(position_childchild_z, flags_childchild_z, bitcount_childchild_z, holder_type_childchild_z);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_childchild_z;
            ann_custom_InnerBitsetHelperChildChild.reset();
            MemberName name_childchild_z = "childchild_z";
            CompleteMemberDetail detail_childchild_z = TypeObjectUtils::build_complete_member_detail(name_childchild_z, member_ann_builtin_childchild_z, ann_custom_InnerBitsetHelperChildChild);
            CompleteBitfield bitfield_childchild_z = TypeObjectUtils::build_complete_bitfield(common_childchild_z, detail_childchild_z);
            TypeObjectUtils::add_complete_bitfield(field_seq_InnerBitsetHelperChildChild, bitfield_childchild_z);
        }
        CompleteBitsetType bitset_type_InnerBitsetHelperChildChild = TypeObjectUtils::build_complete_bitset_type(bitset_flags_InnerBitsetHelperChildChild, header_InnerBitsetHelperChildChild, field_seq_InnerBitsetHelperChildChild);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_bitset_type_object(bitset_type_InnerBitsetHelperChildChild,
                    type_name_InnerBitsetHelperChildChild.to_string(), type_ids_InnerBitsetHelperChildChild))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "InnerBitsetHelperChildChild already registered in TypeObjectRegistry for a different type.");
        }
    }
}void register_BitsetAliasInheritanceBitset_type_identifier(
        TypeIdentifierPair& type_ids_BitsetAliasInheritanceBitset)
{
    ReturnCode_t return_code_BitsetAliasInheritanceBitset {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BitsetAliasInheritanceBitset =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "BitsetAliasInheritanceBitset", type_ids_BitsetAliasInheritanceBitset);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BitsetAliasInheritanceBitset)
    {
        BitsetTypeFlag bitset_flags_BitsetAliasInheritanceBitset = 0;
        QualifiedTypeName type_name_BitsetAliasInheritanceBitset = "BitsetAliasInheritanceBitset";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_BitsetAliasInheritanceBitset;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_BitsetAliasInheritanceBitset;
        CompleteTypeDetail detail_BitsetAliasInheritanceBitset = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_BitsetAliasInheritanceBitset, ann_custom_BitsetAliasInheritanceBitset, type_name_BitsetAliasInheritanceBitset.to_string());
        CompleteBitsetHeader header_BitsetAliasInheritanceBitset = TypeObjectUtils::build_complete_bitset_header(detail_BitsetAliasInheritanceBitset);
        CompleteBitfieldSeq field_seq_BitsetAliasInheritanceBitset;
        {
            uint16_t position_a = 0;
            BitsetMemberFlag flags_a = 0;
            uint8_t bitcount_a = 3;
            TypeKind holder_type_a = TK_UINT8;
            CommonBitfield common_a = TypeObjectUtils::build_common_bitfield(position_a, flags_a, bitcount_a, holder_type_a);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_a;
            ann_custom_BitsetAliasInheritanceBitset.reset();
            MemberName name_a = "a";
            CompleteMemberDetail detail_a = TypeObjectUtils::build_complete_member_detail(name_a, member_ann_builtin_a, ann_custom_BitsetAliasInheritanceBitset);
            CompleteBitfield bitfield_a = TypeObjectUtils::build_complete_bitfield(common_a, detail_a);
            TypeObjectUtils::add_complete_bitfield(field_seq_BitsetAliasInheritanceBitset, bitfield_a);
        }
        {
            uint16_t position_b = 3;
            BitsetMemberFlag flags_b = 0;
            uint8_t bitcount_b = 1;
            TypeKind holder_type_b = TK_BOOLEAN;
            CommonBitfield common_b = TypeObjectUtils::build_common_bitfield(position_b, flags_b, bitcount_b, holder_type_b);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_b;
            ann_custom_BitsetAliasInheritanceBitset.reset();
            MemberName name_b = "b";
            CompleteMemberDetail detail_b = TypeObjectUtils::build_complete_member_detail(name_b, member_ann_builtin_b, ann_custom_BitsetAliasInheritanceBitset);
            CompleteBitfield bitfield_b = TypeObjectUtils::build_complete_bitfield(common_b, detail_b);
            TypeObjectUtils::add_complete_bitfield(field_seq_BitsetAliasInheritanceBitset, bitfield_b);
        }
        {
            uint16_t position_c = 8;
            BitsetMemberFlag flags_c = 0;
            uint8_t bitcount_c = 10;
            TypeKind holder_type_c = TK_UINT16;
            CommonBitfield common_c = TypeObjectUtils::build_common_bitfield(position_c, flags_c, bitcount_c, holder_type_c);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_c;
            ann_custom_BitsetAliasInheritanceBitset.reset();
            MemberName name_c = "c";
            CompleteMemberDetail detail_c = TypeObjectUtils::build_complete_member_detail(name_c, member_ann_builtin_c, ann_custom_BitsetAliasInheritanceBitset);
            CompleteBitfield bitfield_c = TypeObjectUtils::build_complete_bitfield(common_c, detail_c);
            TypeObjectUtils::add_complete_bitfield(field_seq_BitsetAliasInheritanceBitset, bitfield_c);
        }
        {
            uint16_t position_d = 21;
            BitsetMemberFlag flags_d = 0;
            uint8_t bitcount_d = 12;
            TypeKind holder_type_d = TK_INT16;
            CommonBitfield common_d = TypeObjectUtils::build_common_bitfield(position_d, flags_d, bitcount_d, holder_type_d);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_d;
            ann_custom_BitsetAliasInheritanceBitset.reset();
            MemberName name_d = "d";
            CompleteMemberDetail detail_d = TypeObjectUtils::build_complete_member_detail(name_d, member_ann_builtin_d, ann_custom_BitsetAliasInheritanceBitset);
            CompleteBitfield bitfield_d = TypeObjectUtils::build_complete_bitfield(common_d, detail_d);
            TypeObjectUtils::add_complete_bitfield(field_seq_BitsetAliasInheritanceBitset, bitfield_d);
        }
        {
            uint16_t position_new_bitfield = 33;
            BitsetMemberFlag flags_new_bitfield = 0;
            uint8_t bitcount_new_bitfield = 10;
            TypeKind holder_type_new_bitfield = TK_UINT16;
            CommonBitfield common_new_bitfield = TypeObjectUtils::build_common_bitfield(position_new_bitfield, flags_new_bitfield, bitcount_new_bitfield, holder_type_new_bitfield);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_new_bitfield;
            ann_custom_BitsetAliasInheritanceBitset.reset();
            MemberName name_new_bitfield = "new_bitfield";
            CompleteMemberDetail detail_new_bitfield = TypeObjectUtils::build_complete_member_detail(name_new_bitfield, member_ann_builtin_new_bitfield, ann_custom_BitsetAliasInheritanceBitset);
            CompleteBitfield bitfield_new_bitfield = TypeObjectUtils::build_complete_bitfield(common_new_bitfield, detail_new_bitfield);
            TypeObjectUtils::add_complete_bitfield(field_seq_BitsetAliasInheritanceBitset, bitfield_new_bitfield);
        }
        CompleteBitsetType bitset_type_BitsetAliasInheritanceBitset = TypeObjectUtils::build_complete_bitset_type(bitset_flags_BitsetAliasInheritanceBitset, header_BitsetAliasInheritanceBitset, field_seq_BitsetAliasInheritanceBitset);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_bitset_type_object(bitset_type_BitsetAliasInheritanceBitset,
                    type_name_BitsetAliasInheritanceBitset.to_string(), type_ids_BitsetAliasInheritanceBitset))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "BitsetAliasInheritanceBitset already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_BitsetsChildInheritanceStruct_type_identifier(
        TypeIdentifierPair& type_ids_BitsetsChildInheritanceStruct)
{

    ReturnCode_t return_code_BitsetsChildInheritanceStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BitsetsChildInheritanceStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "BitsetsChildInheritanceStruct", type_ids_BitsetsChildInheritanceStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BitsetsChildInheritanceStruct)
    {
        StructTypeFlag struct_flags_BitsetsChildInheritanceStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_BitsetsChildInheritanceStruct = "BitsetsChildInheritanceStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_BitsetsChildInheritanceStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_BitsetsChildInheritanceStruct;
        CompleteTypeDetail detail_BitsetsChildInheritanceStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_BitsetsChildInheritanceStruct, ann_custom_BitsetsChildInheritanceStruct, type_name_BitsetsChildInheritanceStruct.to_string());
        CompleteStructHeader header_BitsetsChildInheritanceStruct;
        header_BitsetsChildInheritanceStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_BitsetsChildInheritanceStruct);
        CompleteStructMemberSeq member_seq_BitsetsChildInheritanceStruct;
        {
            TypeIdentifierPair type_ids_var_InnerBitsetHelperChild;
            ReturnCode_t return_code_var_InnerBitsetHelperChild {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_InnerBitsetHelperChild =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerBitsetHelperChild", type_ids_var_InnerBitsetHelperChild);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_InnerBitsetHelperChild)
            {
            ::register_InnerBitsetHelperChild_type_identifier(type_ids_var_InnerBitsetHelperChild);
            }
            StructMemberFlag member_flags_var_InnerBitsetHelperChild = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_InnerBitsetHelperChild = 0x00000000;
            bool common_var_InnerBitsetHelperChild_ec {false};
            CommonStructMember common_var_InnerBitsetHelperChild {TypeObjectUtils::build_common_struct_member(member_id_var_InnerBitsetHelperChild, member_flags_var_InnerBitsetHelperChild, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_InnerBitsetHelperChild, common_var_InnerBitsetHelperChild_ec))};
            if (!common_var_InnerBitsetHelperChild_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_InnerBitsetHelperChild member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_InnerBitsetHelperChild = "var_InnerBitsetHelperChild";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_InnerBitsetHelperChild;
            ann_custom_BitsetsChildInheritanceStruct.reset();
            CompleteMemberDetail detail_var_InnerBitsetHelperChild = TypeObjectUtils::build_complete_member_detail(name_var_InnerBitsetHelperChild, member_ann_builtin_var_InnerBitsetHelperChild, ann_custom_BitsetsChildInheritanceStruct);
            CompleteStructMember member_var_InnerBitsetHelperChild = TypeObjectUtils::build_complete_struct_member(common_var_InnerBitsetHelperChild, detail_var_InnerBitsetHelperChild);
            TypeObjectUtils::add_complete_struct_member(member_seq_BitsetsChildInheritanceStruct, member_var_InnerBitsetHelperChild);
        }
        {
            TypeIdentifierPair type_ids_var_InnerBitsetHelperChildChild;
            ReturnCode_t return_code_var_InnerBitsetHelperChildChild {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_InnerBitsetHelperChildChild =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerBitsetHelperChildChild", type_ids_var_InnerBitsetHelperChildChild);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_InnerBitsetHelperChildChild)
            {
            ::register_InnerBitsetHelperChildChild_type_identifier(type_ids_var_InnerBitsetHelperChildChild);
            }
            StructMemberFlag member_flags_var_InnerBitsetHelperChildChild = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_InnerBitsetHelperChildChild = 0x00000001;
            bool common_var_InnerBitsetHelperChildChild_ec {false};
            CommonStructMember common_var_InnerBitsetHelperChildChild {TypeObjectUtils::build_common_struct_member(member_id_var_InnerBitsetHelperChildChild, member_flags_var_InnerBitsetHelperChildChild, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_InnerBitsetHelperChildChild, common_var_InnerBitsetHelperChildChild_ec))};
            if (!common_var_InnerBitsetHelperChildChild_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_InnerBitsetHelperChildChild member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_InnerBitsetHelperChildChild = "var_InnerBitsetHelperChildChild";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_InnerBitsetHelperChildChild;
            ann_custom_BitsetsChildInheritanceStruct.reset();
            CompleteMemberDetail detail_var_InnerBitsetHelperChildChild = TypeObjectUtils::build_complete_member_detail(name_var_InnerBitsetHelperChildChild, member_ann_builtin_var_InnerBitsetHelperChildChild, ann_custom_BitsetsChildInheritanceStruct);
            CompleteStructMember member_var_InnerBitsetHelperChildChild = TypeObjectUtils::build_complete_struct_member(common_var_InnerBitsetHelperChildChild, detail_var_InnerBitsetHelperChildChild);
            TypeObjectUtils::add_complete_struct_member(member_seq_BitsetsChildInheritanceStruct, member_var_InnerBitsetHelperChildChild);
        }
        {
            TypeIdentifierPair type_ids_var_BitsetAliasInheritanceBitset;
            ReturnCode_t return_code_var_BitsetAliasInheritanceBitset {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_BitsetAliasInheritanceBitset =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "BitsetAliasInheritanceBitset", type_ids_var_BitsetAliasInheritanceBitset);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_BitsetAliasInheritanceBitset)
            {
            ::register_BitsetAliasInheritanceBitset_type_identifier(type_ids_var_BitsetAliasInheritanceBitset);
            }
            StructMemberFlag member_flags_var_BitsetAliasInheritanceBitset = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_BitsetAliasInheritanceBitset = 0x00000002;
            bool common_var_BitsetAliasInheritanceBitset_ec {false};
            CommonStructMember common_var_BitsetAliasInheritanceBitset {TypeObjectUtils::build_common_struct_member(member_id_var_BitsetAliasInheritanceBitset, member_flags_var_BitsetAliasInheritanceBitset, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_BitsetAliasInheritanceBitset, common_var_BitsetAliasInheritanceBitset_ec))};
            if (!common_var_BitsetAliasInheritanceBitset_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_BitsetAliasInheritanceBitset member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_BitsetAliasInheritanceBitset = "var_BitsetAliasInheritanceBitset";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_BitsetAliasInheritanceBitset;
            ann_custom_BitsetsChildInheritanceStruct.reset();
            CompleteMemberDetail detail_var_BitsetAliasInheritanceBitset = TypeObjectUtils::build_complete_member_detail(name_var_BitsetAliasInheritanceBitset, member_ann_builtin_var_BitsetAliasInheritanceBitset, ann_custom_BitsetsChildInheritanceStruct);
            CompleteStructMember member_var_BitsetAliasInheritanceBitset = TypeObjectUtils::build_complete_struct_member(common_var_BitsetAliasInheritanceBitset, detail_var_BitsetAliasInheritanceBitset);
            TypeObjectUtils::add_complete_struct_member(member_seq_BitsetsChildInheritanceStruct, member_var_BitsetAliasInheritanceBitset);
        }
        CompleteStructType struct_type_BitsetsChildInheritanceStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_BitsetsChildInheritanceStruct, header_BitsetsChildInheritanceStruct, member_seq_BitsetsChildInheritanceStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_BitsetsChildInheritanceStruct, type_name_BitsetsChildInheritanceStruct.to_string(), type_ids_BitsetsChildInheritanceStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "BitsetsChildInheritanceStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}

