/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.impl.commands;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.commands.DefaultMdacContextualCommand;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.ITransaction;
import com.modeliosoft.modelio.api.model.InvalidTransactionException;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.modelingwizard.impl.engine.InterfaceImplementer;

public class UnimplementInterfaces
extends DefaultMdacContextualCommand {
    public void actionPerformed(ObList<IElement> selectedElements, IMdac mdac) {
        InterfaceImplementer interfaceManager = new InterfaceImplementer();
        IModelingSession session = mdac.getModelingSession();
        ITransaction transaction = session.createTransaction("Unimplement Interfaces in class");
        try {
            try {
                boolean hasDoneWork = false;
                for (IElement theElement : selectedElements) {
                    IClassifier theClassifier = (IClassifier)theElement;
                    boolean newResult = interfaceManager.unImplementInterfaces(theClassifier);
                    boolean bl = hasDoneWork = hasDoneWork || newResult;
                }
                if (hasDoneWork) {
                    session.commit(transaction);
                    transaction = null;
                }
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    session.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
            }
        }
    }

    public boolean accept(ObList<IElement> selectedElements, IMdac mdac) {
        if (selectedElements.size() <= 0) {
            return false;
        }
        IClass current = (IClass)selectedElements.get(0);
        return current.getRealized().size() > 0;
    }

    public boolean isActiveFor(ObList<IElement> selectedElements, IMdac mdac) {
        return true;
    }
}

