/**
 * File name: PresetNavigator.h
 * Project: Geonkick (A percussive synthesizer)
 *
 * Copyright (C) 2024 Iurie Nistor
 *
 * This file is part of Geonkick.
 *
 * GeonKick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef PRESET_NAVIGATOR_H
#define PRESET_NAVIGATOR_H

#include "geonkick_widget.h"

#include <RkLabel.h>

class PresetBrowserModel;

class PresetNameLabel: public RkLabel
{
public:
        PresetNameLabel(RkWidget* parent);
        RK_DECL_ACT(previousPreset,
                    previousPreset(),
                    RK_ARG_TYPE(),
                    RK_ARG_VAL());
        RK_DECL_ACT(nextPreset,
                    nextPreset(),
                    RK_ARG_TYPE(),
                    RK_ARG_VAL());
protected:
        void wheelEvent(RkWheelEvent *event) override;
};

class PresetNavigator: public GeonkickWidget
{
 public:
        PresetNavigator(GeonkickWidget *parent,
                        PresetBrowserModel* model);
        ~PresetNavigator() = default;

protected:
        void updateView();

 private:
        PresetBrowserModel *presetsModel;
        PresetNameLabel *presetFolderName;
        PresetNameLabel *presetName;
};

#endif // PRESET_NAVIGATOR_H
