library ieee;
use ieee.std_logic_1164.all;


library ieee;
use ieee.numeric_std.all;

entity lmask is
	port (
		clk : in  std_logic;
		ra0_addr : in  std_logic_vector(4 downto 0);
		ra0_data : out std_logic_vector(31 downto 0)
	);
end lmask;
architecture augh of lmask is

	-- Embedded RAM

	type ram_type is array (0 to 31) of std_logic_vector(31 downto 0);
	signal ram : ram_type := (
		"00000000000000000000000000000001", "00000000000000000000000000000011", "00000000000000000000000000000111",
		"00000000000000000000000000001111", "00000000000000000000000000011111", "00000000000000000000000000111111",
		"00000000000000000000000001111111", "00000000000000000000000011111111", "00000000000000000000000111111111",
		"00000000000000000000001111111111", "00000000000000000000011111111111", "00000000000000000000111111111111",
		"00000000000000000001111111111111", "00000000000000000011111111111111", "00000000000000000111111111111111",
		"00000000000000001111111111111111", "00000000000000011111111111111111", "00000000000000111111111111111111",
		"00000000000001111111111111111111", "00000000000011111111111111111111", "00000000000111111111111111111111",
		"00000000001111111111111111111111", "00000000011111111111111111111111", "00000000111111111111111111111111",
		"00000001111111111111111111111111", "00000011111111111111111111111111", "00000111111111111111111111111111",
		"00001111111111111111111111111111", "00011111111111111111111111111111", "00111111111111111111111111111111",
		"01111111111111111111111111111111", "11111111111111111111111111111111"
	);


	-- Little utility functions to make VHDL syntactically correct
	--   with the syntax to_integer(unsigned(vector)) when 'vector' is a std_logic.
	--   This happens when accessing arrays with <= 2 cells, for example.

	function to_integer(B: std_logic) return integer is
		variable V: std_logic_vector(0 to 0);
	begin
		V(0) := B;
		return to_integer(unsigned(V));
	end;

	function to_integer(V: std_logic_vector) return integer is
	begin
		return to_integer(unsigned(V));
	end;

begin

	-- The component is a ROM.
	-- There is no Write side.

	-- The Read side (the outputs)

	ra0_data <= ram( to_integer(ra0_addr) );

end architecture;
