# Copyright (C) 2004 Jean-Yves Lefort.
#
# This file is part of GNOME Translate.
# It may be distributed under the same terms as GNOME Translate.

### feature handling ##########################################################

dnl GT_FEATURE_VAR_NAME(FEATURE)
dnl
AC_DEFUN([GT_FEATURE_VAR_NAME], [enable_[]translit([$1], -, _)])

dnl GT_FEATURE_DISABLE_REASON_VAR_NAME(FEATURE)
dnl
AC_DEFUN([GT_FEATURE_DISABLE_REASON_VAR_NAME], [disable_[]translit([$1], -, _)_reason])

dnl GT_FEATURE_SYMBOL_NAME(FEATURE)
dnl
AC_DEFUN([GT_FEATURE_SYMBOL_NAME], [WITH_[]translit([$1], -a-z, _A-Z)])

dnl GT_FEATURE_ENABLED(FEATURE)
dnl
AC_DEFUN([GT_FEATURE_ENABLED], [test $GT_FEATURE_VAR_NAME([$1]) = yes])

dnl GT_FEATURE_DISABLED(FEATURE)
dnl
AC_DEFUN([GT_FEATURE_DISABLED], [test $GT_FEATURE_VAR_NAME([$1]) = no])

dnl GT_FEATURE_DISABLE(FEATURE, REASON)
dnl
AC_DEFUN([GT_FEATURE_DISABLE],
[AC_MSG_NOTICE([[$2]: forcing --disable-[$1]])
GT_FEATURE_VAR_NAME([$1])=no
GT_FEATURE_DISABLE_REASON_VAR_NAME([$1])="([$2])"])

dnl GT_FEATURE_DEFINE(FEATURE)
dnl
AC_DEFUN([GT_FEATURE_DEFINE],
[if GT_FEATURE_ENABLED([$1]); then
	AC_DEFINE(GT_FEATURE_SYMBOL_NAME([$1]), 1, [Define to 1 if [$1] is enabled])
fi
])

dnl GT_FEATURES_DEFINE(FEATURES)
dnl
AC_DEFUN([GT_FEATURES_DEFINE], [m4_foreach(feature, [$1], [GT_FEATURE_DEFINE(feature)])])

### command line arguments ####################################################

dnl GT_ARG_ENABLE(FEATURE, DESCRIPTION, [DEFAULT])
dnl
AC_DEFUN([GT_ARG_ENABLE],
[AC_ARG_ENABLE([$1],
AS_HELP_STRING(--ifelse([$3], no, enable, disable)-[$1], $2),
[case "$enableval" in
	yes|no) GT_FEATURE_VAR_NAME([$1])=$enableval ;;
	*) AC_MSG_ERROR([bad value $enableval for --enable-[$1]]) ;;
esac], [GT_FEATURE_VAR_NAME([$1])=ifelse([$3],, yes, [$3])])])

dnl GT_ARG_COMPILE_WARNINGS
dnl
AC_DEFUN([GT_ARG_COMPILE_WARNINGS],
[AC_ARG_ENABLE(compile-warnings,
AS_HELP_STRING([--enable-compile-warnings=no|yes|error],
[enable compiler warnings [[no]]]),
[case "$enableval" in
	yes|no|error) enable_compile_warnings=$enableval ;;
	*) AC_MSG_ERROR([bad value $enableval for --enable-compile-warnings]) ;;
esac], [enable_compile_warnings=no])

if test $enable_compile_warnings = no; then
	WARN_CFLAGS=
else
	# some flags are specific to GCC
	WARN_CFLAGS="-Wall \
-Wformat-y2k \
-Wformat-security \
-Wno-unused-parameter \
-Wfloat-equal \
-Wdeclaration-after-statement \
-Wendif-labels \
-Wpointer-arith \
-Wcast-align \
-Waggregate-return \
-Wmissing-noreturn \
-Wmissing-format-attribute \
-Wpacked \
-Wredundant-decls \
-Wnested-externs \
-Winline"
	test $enable_compile_warnings = error && WARN_CFLAGS="$WARN_CFLAGS -Werror"
fi

AC_SUBST(WARN_CFLAGS)])

### report ####################################################################

dnl GT_REPORT(NAME, VALUE)
dnl
AC_DEFUN([GT_REPORT], [  m4_format([%-30s %s], [$1], [$2])])

dnl GT_REPORT_ARG(NAME)
dnl
AC_DEFUN([GT_REPORT_ARG], [GT_REPORT([--[$1]], [$translit([$1], -, _)])])

dnl GT_REPORT_ARGS(NAMES)
dnl
AC_DEFUN([GT_REPORT_ARGS], [m4_foreach(name, [$1], [GT_REPORT_ARG(name)
])])

dnl GT_REPORT_FEATURE(FEATURE)
dnl
AC_DEFUN([GT_REPORT_FEATURE],
[GT_REPORT([--enable-[$1]],
[$GT_FEATURE_VAR_NAME([$1]) $GT_FEATURE_DISABLE_REASON_VAR_NAME([$1])])])

dnl GT_REPORT_FEATURES(FEATURES)
dnl
AC_DEFUN([GT_REPORT_FEATURES], [m4_foreach(feature, [$1], [GT_REPORT_FEATURE(feature)
])])
