package lb_domains_test

import (
	"testing"

	"github.com/jarcoal/httpmock"
	. "github.com/onsi/ginkgo"
	. "github.com/onsi/gomega"
	"github.com/onsi/gomega/format"
)

func TestGinkgo(t *testing.T) {
	format.MaxLength = 8000
	format.MaxDepth = uint(20)
	RegisterFailHandler(Fail)
	RunSpecs(t, "lb_domains package test suite")
}

var _ = BeforeSuite(func() {
	httpmock.Activate()
})

var _ = BeforeEach(func() {
	httpmock.Reset()
})

var _ = AfterSuite(func() {
	httpmock.DeactivateAndReset()
})
