/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.dd.impl.ejb.annotation;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.ExcludeList;
import org.netbeans.modules.j2ee.dd.api.ejb.MethodPermission;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.CommonAnnotationHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;

public class AssemblyDescriptorImpl implements AssemblyDescriptor {

    private final AnnotationModelHelper helper;
    
    public AssemblyDescriptorImpl(AnnotationModelHelper helper) {
        this.helper = helper;
    }
    
    public SecurityRole[] getSecurityRole() {
        return CommonAnnotationHelper.getSecurityRoles(helper);
    }
    
    public MessageDestination[] getMessageDestination() throws VersionNotSupportedException {
        return new MessageDestination[0];
    }

    // <editor-fold defaultstate="collapsed" desc="Not implemented methods">

    public Object clone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
    
    public ContainerTransaction[] getContainerTransaction() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ContainerTransaction getContainerTransaction(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setContainerTransaction(ContainerTransaction[] value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setContainerTransaction(int index, ContainerTransaction value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int sizeContainerTransaction() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int addContainerTransaction(ContainerTransaction value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int removeContainerTransaction(ContainerTransaction value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ContainerTransaction newContainerTransaction() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MethodPermission[] getMethodPermission() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MethodPermission getMethodPermission(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setMethodPermission(MethodPermission[] value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setMethodPermission(int index, MethodPermission value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int addMethodPermission(MethodPermission value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int sizeMethodPermission() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int removeMethodPermission(MethodPermission value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MethodPermission newMethodPermission() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SecurityRole getSecurityRole(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSecurityRole(SecurityRole[] value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSecurityRole(int index, SecurityRole value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int sizeSecurityRole() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int removeSecurityRole(SecurityRole value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int addSecurityRole(SecurityRole value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SecurityRole newSecurityRole() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setExcludeList(ExcludeList value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ExcludeList getExcludeList() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ExcludeList newExcludeList() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageDestination getMessageDestination(int index) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setMessageDestination(MessageDestination[] value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setMessageDestination(int index, MessageDestination value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int sizeMessageDestination() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int removeMessageDestination(MessageDestination value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int addMessageDestination(MessageDestination value) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageDestination newMessageDestination() throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setId(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getValue(String propertyName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(OutputStream os) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    // </editor-fold>

} 

