/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import org.chefproject.core.ChatChannel;
import org.chefproject.core.ChatChannelEdit;
import org.chefproject.core.ChatMessage;
import org.chefproject.core.ChatMessageEdit;
import org.chefproject.core.ChatMessageHeader;
import org.chefproject.core.ChatMessageHeaderEdit;
import org.chefproject.core.Edit;
import org.chefproject.core.Message;
import org.chefproject.core.MessageChannel;
import org.chefproject.core.MessageHeader;
import org.chefproject.core.MessageHeaderEdit;
import org.chefproject.core.Resource;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.component.BaseMessageService;
import org.chefproject.service.generic.GenericChatService;
import org.chefproject.util.ReferenceVector;
import org.w3c.dom.Element;

public abstract class BaseChatService
extends BaseMessageService
implements GenericChatService {
    public Resource newContainer(String ref) {
        return new BaseChatChannelEdit(ref);
    }

    public Resource newContainer(Element element) {
        return new BaseChatChannelEdit(element);
    }

    public Resource newContainer(Resource other) {
        return new BaseChatChannelEdit((MessageChannel)other);
    }

    public Resource newResource(Resource container, String id, Object[] others) {
        return new BaseChatMessageEdit((MessageChannel)container, id);
    }

    public Resource newResource(Resource container, Element element) {
        return new BaseChatMessageEdit((MessageChannel)container, element);
    }

    public Resource newResource(Resource container, Resource other) {
        return new BaseChatMessageEdit((MessageChannel)container, (Message)other);
    }

    public Edit newContainerEdit(String ref) {
        BaseChatChannelEdit rv = new BaseChatChannelEdit(ref);
        rv.activate();
        return rv;
    }

    public Edit newContainerEdit(Element element) {
        BaseChatChannelEdit rv = new BaseChatChannelEdit(element);
        rv.activate();
        return rv;
    }

    public Edit newContainerEdit(Resource other) {
        BaseChatChannelEdit rv = new BaseChatChannelEdit((MessageChannel)other);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Resource container, String id, Object[] others) {
        BaseChatMessageEdit rv = new BaseChatMessageEdit((MessageChannel)container, id);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Resource container, Element element) {
        BaseChatMessageEdit rv = new BaseChatMessageEdit((MessageChannel)container, element);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Resource container, Resource other) {
        BaseChatMessageEdit rv = new BaseChatMessageEdit((MessageChannel)container, (Message)other);
        rv.activate();
        return rv;
    }

    public Object[] storageFields(Resource r) {
        Object[] rv = new Object[]{((Message)r).getHeader().getDate()};
        return rv;
    }

    protected MessageHeaderEdit newMessageHeader(String id) {
        return new BaseChatMessageHeaderEdit(id);
    }

    protected MessageHeaderEdit newMessageHeader(Element el) {
        return new BaseChatMessageHeaderEdit(el);
    }

    protected MessageHeaderEdit newMessageHeader(MessageHeader other) {
        return new BaseChatMessageHeaderEdit(other);
    }

    protected String eventId(String secure) {
        return "chat." + secure;
    }

    protected String getReferenceRoot() {
        return "/chat";
    }

    public ChatChannel getChatChannel(String ref) throws IdUnusedException, PermissionException {
        return (ChatChannel)this.getChannel(ref);
    }

    public ChatChannelEdit addChatChannel(String ref) throws IdUsedException, IdInvalidException, PermissionException {
        return (ChatChannelEdit)this.addChannel(ref);
    }

    public class BaseChatMessageHeaderEdit
    extends BaseMessageService.BaseMessageHeaderEdit
    implements ChatMessageHeaderEdit {
        public BaseChatMessageHeaderEdit(String id) {
            super((BaseMessageService)BaseChatService.this, id);
        }

        public BaseChatMessageHeaderEdit(Element el) {
            super((BaseMessageService)BaseChatService.this, el);
        }

        public BaseChatMessageHeaderEdit(MessageHeader other) {
            super((BaseMessageService)BaseChatService.this, other);
        }
    }

    public class BaseChatMessageEdit
    extends BaseMessageService.BaseMessageEdit
    implements ChatMessageEdit {
        public BaseChatMessageEdit(MessageChannel channel, String id) {
            super((BaseMessageService)BaseChatService.this, channel, id);
        }

        public BaseChatMessageEdit(MessageChannel channel, Message other) {
            super((BaseMessageService)BaseChatService.this, channel, other);
        }

        public BaseChatMessageEdit(MessageChannel channel, Element el) {
            super((BaseMessageService)BaseChatService.this, channel, el);
        }

        public ChatMessageHeader getChatHeader() {
            return (ChatMessageHeader)this.getHeader();
        }

        public ChatMessageHeaderEdit getChatHeaderEdit() {
            return (ChatMessageHeaderEdit)this.getHeader();
        }
    }

    public class BaseChatChannelEdit
    extends BaseMessageService.BaseMessageChannelEdit
    implements ChatChannelEdit {
        public BaseChatChannelEdit(String ref) {
            super((BaseMessageService)BaseChatService.this, ref);
        }

        public BaseChatChannelEdit(MessageChannel other) {
            super((BaseMessageService)BaseChatService.this, other);
        }

        public BaseChatChannelEdit(Element el) {
            super((BaseMessageService)BaseChatService.this, el);
        }

        public ChatMessage getChatMessage(String messageId) throws IdUnusedException, PermissionException {
            return (ChatMessage)this.getMessage(messageId);
        }

        public ChatMessageEdit editChatMessage(String messageId) throws IdUnusedException, PermissionException, InUseException {
            return (ChatMessageEdit)this.editMessage(messageId);
        }

        public ChatMessageEdit addChatMessage() throws PermissionException {
            return (ChatMessageEdit)this.addMessage();
        }

        public ChatMessage addChatMessage(ReferenceVector attachments, String body) throws PermissionException {
            ChatMessageEdit edit = (ChatMessageEdit)this.addMessage();
            ChatMessageHeaderEdit header = edit.getChatHeaderEdit();
            edit.setBody(body);
            header.replaceAttachments(attachments);
            this.commitMessage(edit);
            return edit;
        }
    }
}

