#!/bin/bash

################################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################

if test "$2" = pegasus
then
	if !( ps -C cimserver > /dev/null 2>&1 )
	then
		echo "ERROR: Pegasus CIM server is not running"
		exit 1
	fi
fi

if test "$2" = openwbem
then
	if !( ps -C owcimomd > /dev/null 2>&1 )
	then
		echo "ERROR: OpenWBEM CIM server is not running"
		exit 1
	fi
fi

if test "$2" = sfcb
then
	/etc/init.d/sfcb stop
fi

$4/registration/OpenDRIM_AssociatedProcessorCacheMemory-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_ComputerSystemProcessor-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_ProcessorProcessorCore-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_HardwareThread-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_ProcessorCore-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_ProcessorCoreHardwareThread-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_AssociatedProcessorCoreCacheMemory-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_ProcessorConformsToProfile-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_CacheMemory-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_Processor-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_RegisteredCPUProfile-remove.sh $1 $2 $3 $4

if test "$2" = sfcb
then
	/etc/init.d/sfcb start
fi

