/*
 * Copyright 2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package demo.org.powermock.examples.tutorial.hellopower.withoutpowermock;

import org.easymock.EasyMock;
import org.junit.Test;

import static org.easymock.EasyMock.*;
import static org.junit.Assert.assertEquals;

public class HelloWorldTest {

	@Test
	public void testGreeting() {
		ConfigWrapper config = EasyMock.createMock(ConfigWrapper.class);
		expect(config.getGreeting()).andReturn("Hello");
		expect(config.getTarget()).andReturn("world");
		
		replay(config);
		
		assertEquals("Hello world", new HelloWorld(config).greet());

		verify(config);
	}
}
