#!/usr/bin/env python3

import sys
import hashlib
import binascii

def hash(data):
    '''
    '''
    h = hashlib.shake_256()
    h.update(data)
    return h.digest(32)


# l3
l3 = b''
while True:
    chunk = sys.stdin.buffer.read()
    if len(chunk) == 0:
        break
    l3 += chunk

# l2
l2 = b''
while True:
    l2 += hash(l3[0:1152])
    l3 = l3[1152:]
    if len(l3) == 0:
        break

# l1
l1 = b''
while True:
    l1 += hash(l2[0:1152])
    l2 = l2[1152:]
    if len(l2) == 0:
        break

# l0
l0 = hash(l1)
print(binascii.hexlify(l0).decode('ascii'))
exit(0)
